/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.labels;

import com.mayastudios.ixml.common.BaseEventManager;
import com.mayastudios.ixml.labels.LString;
import com.mayastudios.ixml.labels.LabelGroup;
import com.mayastudios.ixml.labels.LabelsLoader;
import com.mayastudios.ixml.misc.FormatString;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelsCore {
    private static final int DEFAULT_CAPACITY = 1024;
    private static final ReentrantReadWriteLock SYNCHRONIZER = new ReentrantReadWriteLock();
    private static final HashMap<String, String> BASE_LOCALE_LABELS = new HashMap(1024);
    private static final HashMap<String, String> CURRENT_LOCALE_LABELS = new HashMap(1024);
    private static final LinkedList<LabelGroup> LABEL_GROUPS = new LinkedList();
    private static final HashMap<String, LString> LABEL_STRINGS = new HashMap(1024);
    private static final EventManager LABELS_LISTENERS = new EventManager();
    private static Locale s_oCurrentLocale = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLabelGroup(LabelGroup p_oLabelGroup) throws LabelGroup.LocaleLoadException {
        SYNCHRONIZER.writeLock().lock();
        try {
            LABEL_GROUPS.add(p_oLabelGroup);
            LabelsCore._copyLabelsIntoHashMap(p_oLabelGroup.mf_strGroupPrefix, p_oLabelGroup.getBaseLocaleList(), BASE_LOCALE_LABELS);
            if (s_oCurrentLocale != null) {
                p_oLabelGroup.setCurrentLocale(s_oCurrentLocale);
                LabelsCore._copyLabelsIntoHashMap(p_oLabelGroup.mf_strGroupPrefix, p_oLabelGroup.getCurrentLocaleList(), CURRENT_LOCALE_LABELS);
            }
            LabelsCore._updateAndNotify(false);
        }
        finally {
            SYNCHRONIZER.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(Locale p_oLocale) throws LabelGroup.LocaleLoadException {
        if (p_oLocale == null) {
            throw new IllegalArgumentException("The locale must not be null.");
        }
        SYNCHRONIZER.writeLock().lock();
        if (p_oLocale.equals(s_oCurrentLocale)) {
            SYNCHRONIZER.writeLock().unlock();
            return;
        }
        try {
            CURRENT_LOCALE_LABELS.clear();
            s_oCurrentLocale = p_oLocale;
            for (LabelGroup oGroup : LABEL_GROUPS) {
                oGroup.setCurrentLocale(p_oLocale);
                LabelsCore._copyLabelsIntoHashMap(oGroup.mf_strGroupPrefix, oGroup.getCurrentLocaleList(), CURRENT_LOCALE_LABELS);
            }
            LabelsCore._updateAndNotify(true);
        }
        finally {
            SYNCHRONIZER.writeLock().unlock();
        }
    }

    public static Locale getLocale() {
        return s_oCurrentLocale;
    }

    private static void _copyLabelsIntoHashMap(String p_strPrefix, List<LabelsLoader.RawLabel> p_oLabelList, HashMap<String, String> p_oDestHashMap) {
        for (LabelsLoader.RawLabel oPair : p_oLabelList) {
            p_oDestHashMap.put(p_strPrefix + oPair.mf_strName, oPair.mf_strContent);
        }
    }

    private static void _updateAndNotify(boolean p_bLocaleHasChanged) {
        Collection<LString> oLabels = LABEL_STRINGS.values();
        for (LString oLabel : oLabels) {
            oLabel.update();
        }
        LABELS_LISTENERS.fireEvent(p_bLocaleHasChanged);
    }

    public static void addLabelsChangeListener(ILabelsChangeListener p_oListener, BaseEventManager.ERefType p_eRefType) {
        LABELS_LISTENERS.addListener(p_oListener, p_eRefType);
    }

    public static void removeLabelsChangeListener(ILabelsChangeListener p_oListener) {
        LABELS_LISTENERS.removeListener(p_oListener);
    }

    public static String get(String p_strKey, Object ... p_aoFormatArgs) {
        String strLabel = LabelsCore.getNullable(p_strKey, p_aoFormatArgs);
        if (strLabel == null) {
            strLabel = String.format("[%s]", p_strKey);
        }
        return strLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNullable(String p_strKey, Object ... p_aoFormatArgs) {
        if (p_strKey == null || p_strKey.length() == 0) {
            return "";
        }
        SYNCHRONIZER.readLock().lock();
        try {
            String strLabel = CURRENT_LOCALE_LABELS.get(p_strKey);
            if (strLabel == null) {
                strLabel = BASE_LOCALE_LABELS.get(p_strKey);
                if (strLabel != null) {
                    strLabel = FormatString.formatStringNoExcpt(strLabel, p_aoFormatArgs);
                }
            } else {
                strLabel = FormatString.formatStringNoExcpt(strLabel, p_aoFormatArgs);
            }
            String string = strLabel;
            return string;
        }
        finally {
            SYNCHRONIZER.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LString getLS(String p_strKey) {
        LString oString;
        if (p_strKey == null || p_strKey.length() == 0) {
            throw new IllegalArgumentException("Empty keys are not supported.");
        }
        SYNCHRONIZER.readLock().lock();
        try {
            oString = LABEL_STRINGS.get(p_strKey);
            if (oString != null) {
                LString lString = oString;
                return lString;
            }
        }
        finally {
            SYNCHRONIZER.readLock().unlock();
        }
        SYNCHRONIZER.writeLock().lock();
        try {
            oString = LABEL_STRINGS.get(p_strKey);
            if (oString == null) {
                oString = new LString(p_strKey, LabelsCore.get(p_strKey, new Object[0]));
                LABEL_STRINGS.put(p_strKey, oString);
            }
            LString lString = oString;
            return lString;
        }
        finally {
            SYNCHRONIZER.writeLock().unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventManager
    extends BaseEventManager<ILabelsChangeListener, Boolean> {
        public void fireEvent(boolean p_bLocaleHasChanged) {
            this.fireEvent(p_bLocaleHasChanged);
        }

        protected void notifyListener(ILabelsChangeListener p_oListener, Boolean p_bLocaleHasChanged) {
            p_oListener.labelsChanged(p_bLocaleHasChanged);
        }
    }

    public static interface ILabelsChangeListener {
        public void labelsChanged(boolean var1);
    }
}

