/*
 * Decompiled with CFR 0.152.
 */
package fontviewer.components;

import fontviewer.FontViewer;
import fontviewer.beans.FontNode;
import fontviewer.beans.SystemFontNode;
import fontviewer.i18n.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTreeCellRenderer;

public class TreePanel
extends JPanel {
    private final DefaultMutableTreeNode root = new DefaultMutableTreeNode();
    private final DefaultMutableTreeNode system = new DefaultMutableTreeNode();
    private final JFileChooser dirChooser = new JFileChooser();
    private final JPopupMenu addPopup = new JPopupMenu();
    private final JPopupMenu removePopup = new JPopupMenu();
    private final JTree fontsTree = new JTree(this.root);
    private ArrayList fontPaths = null;
    private I18N resources = null;
    private FontViewer parent = null;

    public TreePanel(FontViewer fontViewer) {
        this.parent = fontViewer;
        this.resources = fontViewer.getLocalisedResources();
        this.root.setUserObject(this.resources.localisedString("Gui.Tree.Root"));
        this.system.setUserObject(this.resources.localisedString("Gui.Tree.System.Node"));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.dirChooser.setDialogTitle(this.resources.localisedString("Gui.FileChooser.FontPath.Title"));
        this.dirChooser.setApproveButtonText(this.resources.localisedString("Gui.FileChooser.FontPath.Button"));
        this.dirChooser.setMultiSelectionEnabled(false);
        this.dirChooser.setFileSelectionMode(1);
        JMenuItem jMenuItem = new JMenuItem(this.resources.localisedString("Gui.Popup.Add.FontPath"));
        jMenuItem.setIcon(new ImageIcon(TreePanel.class.getResource("/fontviewer/resources/add.png")));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TreePanel.this.dirChooser.showOpenDialog((JFrame)TreePanel.this.getTopLevelAncestor());
                if (n == 0) {
                    if (TreePanel.this.fontPaths == null) {
                        TreePanel.this.fontPaths = new ArrayList();
                    }
                    if (!TreePanel.this.fontPaths.contains(TreePanel.this.dirChooser.getSelectedFile().getAbsolutePath())) {
                        TreePanel.this.fontPaths.add(TreePanel.this.dirChooser.getSelectedFile().getAbsolutePath());
                        TreePanel.this.updateTree(TreePanel.this.fontPaths);
                    }
                }
            }
        });
        this.addPopup.add(jMenuItem);
        jMenuItem = new JMenuItem(this.resources.localisedString("Gui.Popup.Remove.FontPath"));
        jMenuItem.setIcon(new ImageIcon(TreePanel.class.getResource("/fontviewer/resources/remove.png")));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)TreePanel.this.fontsTree.getLastSelectedPathComponent();
                TreePanel.this.fontPaths.remove(defaultMutableTreeNode.toString());
                TreePanel.this.updateTree(TreePanel.this.fontPaths);
            }
        });
        this.removePopup.add(jMenuItem);
        this.fontsTree.setEditable(false);
        this.fontsTree.getSelectionModel().setSelectionMode(1);
        SubstanceDefaultTreeCellRenderer substanceDefaultTreeCellRenderer = new SubstanceDefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                String string = object.toString();
                if (string.equals(TreePanel.this.resources.localisedString("Gui.Tree.Root")) || string.equals(TreePanel.this.resources.localisedString("Gui.Tree.System.Node"))) {
                    this.setIcon(new ImageIcon(TreePanel.class.getResource("/fontviewer/resources/font-folder-icon.png")));
                } else if (bl3) {
                    File file = new File(string);
                    if (file.exists() && file.isDirectory()) {
                        this.setIcon(new ImageIcon(TreePanel.class.getResource("/fontviewer/resources/font-folder-icon.png")));
                    } else {
                        this.setIcon(new ImageIcon(TreePanel.class.getResource("/fontviewer/resources/font-truetype-icon.png")));
                    }
                } else {
                    this.setIcon(new ImageIcon(TreePanel.class.getResource("/fontviewer/resources/font-folder-icon.png")));
                }
                this.setText(string);
                return this;
            }
        };
        this.fontsTree.setCellRenderer(substanceDefaultTreeCellRenderer);
        this.fontsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.performAction(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.performAction(mouseEvent);
            }

            private boolean maybeShowAddPopup(MouseEvent mouseEvent, DefaultMutableTreeNode defaultMutableTreeNode) {
                if (defaultMutableTreeNode == null || defaultMutableTreeNode == TreePanel.this.system) {
                    return false;
                }
                return defaultMutableTreeNode == TreePanel.this.root && mouseEvent.isPopupTrigger();
            }

            private boolean maybeShowRemovePopup(MouseEvent mouseEvent, DefaultMutableTreeNode defaultMutableTreeNode) {
                if (defaultMutableTreeNode == null || defaultMutableTreeNode == TreePanel.this.system) {
                    return false;
                }
                return defaultMutableTreeNode != TreePanel.this.root && mouseEvent.isPopupTrigger() && !(defaultMutableTreeNode instanceof FontNode);
            }

            private void performAction(MouseEvent mouseEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)TreePanel.this.fontsTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                if (this.maybeShowAddPopup(mouseEvent, defaultMutableTreeNode)) {
                    TreePanel.this.addPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (this.maybeShowRemovePopup(mouseEvent, defaultMutableTreeNode)) {
                    TreePanel.this.removePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (defaultMutableTreeNode instanceof FontNode) {
                    TreePanel.this.parent.updateFont(((FontNode)defaultMutableTreeNode).getFontPath());
                } else if (defaultMutableTreeNode instanceof SystemFontNode) {
                    TreePanel.this.parent.updateFont(((SystemFontNode)defaultMutableTreeNode).getFont(), true);
                }
            }
        });
        this.add((Component)new JScrollPane(this.fontsTree), "Center");
    }

    private void createTree() {
        if (this.fontPaths != null) {
            int n;
            this.root.removeAllChildren();
            this.system.removeAllChildren();
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            for (n = 0; n < fontArray.length; ++n) {
                this.system.add(new SystemFontNode(fontArray[n]));
            }
            this.root.add(this.system);
            for (n = 0; n < this.fontPaths.size(); ++n) {
                String string = (String)this.fontPaths.get(n);
                File file = new File(string);
                if (!file.exists() || !file.isDirectory()) continue;
                defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                this.root.add(defaultMutableTreeNode);
                File[] fileArray = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return file != null && string != null && !string.equals("") && (string.endsWith(".ttf") || string.endsWith(".TTF"));
                    }
                });
                for (int i = 0; i < fileArray.length; ++i) {
                    defaultMutableTreeNode.add(new FontNode(fileArray[i].getName(), fileArray[i].getAbsolutePath()));
                }
            }
        }
    }

    public ArrayList getFontPaths() {
        return this.fontPaths;
    }

    public void updateTree(ArrayList arrayList) {
        this.fontPaths = arrayList;
        this.createTree();
        ((DefaultTreeModel)this.fontsTree.getModel()).reload();
    }
}

