/*
 * Decompiled with CFR 0.152.
 */
package fontviewer.components;

import fontviewer.i18n.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatusBar
extends JPanel {
    private final JLabel fontName = new JLabel();
    private final JLabel fontSize = new JLabel();
    private final JLabel fontStats = new JLabel();
    private I18N resources;

    public StatusBar(I18N i18N) {
        this.resources = i18N;
        this.fontName.setHorizontalAlignment(2);
        this.fontSize.setHorizontalAlignment(0);
        this.fontStats.setHorizontalAlignment(4);
        this.setLayout(new BorderLayout());
        this.add((Component)this.fontName, "West");
        this.add((Component)this.fontSize, "Center");
        this.add((Component)this.fontStats, "East");
    }

    public void updateStatusBar(Font font, String string) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.fontName.setText(this.resources.localisedString("Gui.Panel.Preview.StatusBar.FontName") + ": " + font.getName());
        this.fontSize.setText(this.resources.localisedString("Gui.Panel.Preview.StatusBar.FontSize") + ": " + font.getSize());
        this.fontStats.setText(this.resources.localisedString("Gui.Panel.Preview.StatusBar.FontLength") + ": " + this.padWithSpaces(fontMetrics.stringWidth(string), 4) + "px, " + this.resources.localisedString("Gui.Panel.Preview.StatusBar.FontHeight") + ": " + this.padWithSpaces(fontMetrics.getHeight(), 4) + "px");
        this.revalidate();
    }

    private String padWithSpaces(int n, int n2) {
        return String.format("%" + n2 + "d", n);
    }
}

