#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/examples/tkinter/RCS/server.py,v $
# Version:      @(#)$RCSfile: server.py,v $ $Revision: 1.8 $
#
#############################################################################
""" A server with a 'tkinter' GUI. """


# Standard/built-in modules.
import sys

# Tkinter modules.
from Tkinter import *

# Fnorb modules.
from Fnorb.orb import BOA, CORBA, TkReactor

# Stubs and skeletons generated by 'fnidl'.
import TicToc, TicToc_skel


class Server(TicToc_skel.TicTocIF_skel):
    """ GUI Server! """

    def __init__(self):

	# Root window.
	self.root = Tk()

	# Main frame.
	self.mainFrame = MainFrame(self.root)

	# Pack it!
	self.mainFrame.pack(fill='x')

	return

    #########################################################################
    # CORBA TicTocIF operations.
    #########################################################################
    
    def tictoc(self):

	print 'Server.tictoc: operation tictoc invoked by client.'
	self.mainFrame.ticTocButton.ticToc()
	print 'Server.tictoc: operation tictoc complete.'

	return

    def quit(self):

	print 'Server.quit: operation quit invoked by client.'
	boa = BOA.BOA_init()
	boa._fnorb_quit()
	print 'Server.quit: operation tictoc complete.'

	return


class MainFrame(Frame):

    def __init__(self, parent, **kw):

	apply(Frame.__init__, (self, parent), kw)

	# Buttons.
	self.ticTocButton = TicTocButton(self)

	# Pack it!
	self.ticTocButton.pack(side='left', expand=1)

	return


class TicTocButton(Button):

    def __init__(self, parent, **kw):

	self._d_options = {'command': self.ticToc,
			   'state'  : 'normal',
			   'text'   : 'Tic!'}

	apply(Button.__init__, (self, parent), self._d_options)

	# Toggle state (0 = 'Tic!', 1 = 'Toc!').
	self._state = 0

	return

    def ticToc(self):
	""" Callback invoked when the button is pressed. """

	print 'TicTocButton.ticToc: button pressed.'

	if self._state == 0:
	    self.configure(text='Toc!')
	    self._state = 1

	else:
	    self.configure(text='Tic!')
	    self._state = 0

	print 'TicTocButton.ticToc: complete.'
	return


def main(argv):
    """ Do it! """

    print 'Initialising the ORB...'

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    print 'Initialising the Tk Reactor...'

    # Because we are using Tk, we must use the 'TkReactor' which allows Tk
    # and Fnorb events to be handled from within a single event loop.
    #
    # The 'TkReactor' MUST be be initialised BEFORE the BOA.
    TkReactor.TkReactor_init()

    print 'Initialising the BOA...'

    # Initialise the BOA.
    boa = BOA.BOA_init(sys.argv, BOA.BOA_ID)

    print 'Creating object reference...'

    # Create an object reference ('fred' is the object key).
    obj = boa.create('fred', Server._FNORB_ID)

    print 'Creating implementation...'

    # Create an instance of the implementation class.
    impl = Server()

    print 'Activating the implementation...'

    # Activate the implementation (ie. connect the generated object reference
    # to the implementation).  Note that the implementation will not receive
    # any operation requests until we start the event loop (see below).
    boa.obj_is_ready(obj, impl)

    # Write the stringified object reference to a file (this is just a 'cheap
    # and cheerful' way of making the object reference available to the
    # client!).
    open('server.ref', 'w').write(orb.object_to_string(obj))

    print 'Server created and accepting requests...'

    # Start the event loop.
    boa._fnorb_mainloop()

    print 'Server finished!'

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
