/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.librarymodel;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.fidocadj.librarymodel.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library {
    String libraryName;
    String filename;
    boolean isStd;
    ArrayList<Category> categories;

    Library(String libraryName, String filename, boolean isStd) {
        this.libraryName = libraryName;
        this.filename = filename;
        this.isStd = isStd;
        this.categories = new ArrayList();
    }

    public String getName() {
        return this.libraryName;
    }

    public void setName(String name) {
        this.libraryName = name;
    }

    public String getFileName() {
        return this.filename;
    }

    public List<Category> getAllCategories() {
        return this.categories;
    }

    public Category getCategory(String name) {
        Category result = null;
        for (Category c : this.categories) {
            if (!c.getName().equals(name)) continue;
            result = c;
            break;
        }
        return result;
    }

    public void addCategory(Category category) {
        this.categories.add(category);
    }

    public void removeCategory(Category category) {
        this.categories.remove(category);
    }

    public boolean isStdLib() {
        return this.isStd;
    }

    public boolean isHidden() {
        return false;
    }

    public static boolean isValidName(String name) {
        return true;
    }

    public boolean containsMacroKey(String key) {
        if (key == null) {
            return true;
        }
        for (Category category : this.categories) {
            if (!category.containsMacroKey(key)) continue;
            return true;
        }
        return false;
    }
}

