/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import dialogs.DialogUtil;
import globals.Globals;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class EnterCircuitFrame
extends JDialog
implements ComponentListener {
    private static final int MIN_WIDTH = 400;
    private static final int MIN_HEIGHT = 350;
    private final JTextArea textArea;
    private String stringCircuit;

    public void setStringCircuit(String s) {
        this.stringCircuit = s;
    }

    public String getStringCircuit() {
        return this.stringCircuit;
    }

    public void componentResized(ComponentEvent e) {
        int width = this.getWidth();
        int height = this.getHeight();
        boolean resize = false;
        if (width < 400) {
            resize = true;
            width = 400;
        }
        if (height < 350) {
            resize = true;
            height = 350;
        }
        if (resize) {
            this.setSize(width, height);
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public EnterCircuitFrame(JFrame parent, String circuit) {
        super(parent, Globals.messages.getString("Enter_code"), true);
        this.addComponentListener(this);
        this.getRootPane().putClientProperty("apple.awt.documentModalSheet", Boolean.TRUE);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        DialogUtil.center(this, 0.5, 0.5);
        this.stringCircuit = "[FIDOCAD]\n" + circuit;
        this.textArea = new JTextArea(this.stringCircuit, 2, 10);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        GridBagConstraints constraints = DialogUtil.createConst(0, 0, 1, 1, 100, 100, 17, 1, new Insets(20, 20, 12, 20));
        contentPane.add((Component)scrollPane, constraints);
        JButton ok = new JButton(Globals.messages.getString("Ok_btn"));
        JButton cancel = new JButton(Globals.messages.getString("Cancel_btn"));
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        ok.setPreferredSize(cancel.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            b.add(ok);
            b.add(Box.createHorizontalStrut(12));
            b.add(cancel);
        } else {
            b.add(cancel);
            b.add(Box.createHorizontalStrut(12));
            b.add(ok);
        }
        b.add(Box.createHorizontalStrut(20));
        constraints = DialogUtil.createConst(0, 1, 1, 1, 100, 0, 17, 2, new Insets(0, 0, 20, 0));
        contentPane.add((Component)b, constraints);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnterCircuitFrame.this.setVisible(false);
                EnterCircuitFrame.this.stringCircuit = EnterCircuitFrame.this.textArea.getText();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnterCircuitFrame.this.setVisible(false);
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                EnterCircuitFrame.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, cancelAction);
    }
}

