/*
 * Decompiled with CFR 0.152.
 */
package circuit.model;

import circuit.controllers.UndoActions;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import layers.LayerDesc;
import primitives.GraphicPrimitive;
import primitives.MacroDesc;
import primitives.PrimitiveMacro;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawingModel {
    public boolean[] layersUsed;
    public int maxLayer;
    public boolean drawOnlyPads;
    public int drawOnlyLayer;
    private int exportBorder;
    private String macroFont;
    private int macroFontSize;
    public boolean changed;
    private Vector<GraphicPrimitive> primitiveVector;
    public Vector<LayerDesc> layerV;
    private Map<String, MacroDesc> library;

    public DrawingModel() {
        this.setPrimitiveVector(new Vector<GraphicPrimitive>(25));
        this.layerV = new Vector(16);
        this.library = new TreeMap<String, MacroDesc>();
        this.macroFont = "Courier New";
        this.drawOnlyPads = false;
        this.drawOnlyLayer = -1;
        this.layersUsed = new boolean[16];
        this.exportBorder = 0;
        this.changed = true;
    }

    public Vector<LayerDesc> getLayers() {
        return this.layerV;
    }

    public void setLayers(Vector<LayerDesc> v) {
        this.layerV = v;
        for (int i = 0; i < this.getPrimitiveVector().size(); ++i) {
            GraphicPrimitive g = this.getPrimitiveVector().get(i);
            if (!(g instanceof PrimitiveMacro)) continue;
            ((PrimitiveMacro)g).setLayers(v);
        }
        this.changed = true;
    }

    public void setExportBorder(int b) {
        this.exportBorder = b;
    }

    public Map<String, MacroDesc> getLibrary() {
        return this.library;
    }

    public void setLibrary(Map<String, MacroDesc> l) {
        this.library = l;
        this.changed = true;
    }

    public void resetLibrary() {
        this.setLibrary(new TreeMap<String, MacroDesc>());
        this.changed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrimitive(GraphicPrimitive p, boolean sort, UndoActions ua) {
        DrawingModel drawingModel = this;
        synchronized (drawingModel) {
            this.getPrimitiveVector().add(p);
            if (sort) {
                this.sortPrimitiveLayers();
            }
            if (ua != null) {
                ua.saveUndoState();
                ua.setModified(true);
                this.changed = true;
            }
        }
    }

    public void setTextFont(String f, int tsize, UndoActions ua) {
        int size = tsize;
        this.macroFont = f;
        this.macroFontSize = size;
        for (int i = 0; i < this.getPrimitiveVector().size(); ++i) {
            this.getPrimitiveVector().get(i).setMacroFont(f, size);
        }
        this.changed = true;
        if (ua != null) {
            ua.setModified(true);
        }
    }

    public String getTextFont() {
        return this.macroFont;
    }

    public int getTextFontSize() {
        if (this.getPrimitiveVector().size() > 0) {
            int size = this.getPrimitiveVector().get(0).getMacroFontSize();
            if (size <= 0) {
                size = 1;
            }
            this.macroFontSize = size;
        }
        return this.macroFontSize;
    }

    public void sortPrimitiveLayers() {
        int i;
        int l;
        boolean cont = true;
        this.maxLayer = 0;
        for (l = this.getPrimitiveVector().size() / 2; l > 0; l /= 2) {
            for (int j = l; j < this.getPrimitiveVector().size(); ++j) {
                for (i = j - l; i >= 0 && this.getPrimitiveVector().get((int)(i + l)).layer < this.getPrimitiveVector().get((int)i).layer; i -= l) {
                    GraphicPrimitive s = this.getPrimitiveVector().get(i);
                    this.getPrimitiveVector().set(i, this.getPrimitiveVector().get(i + l));
                    this.getPrimitiveVector().set(i + l, s);
                }
            }
        }
        this.maxLayer = -1;
        int k = 0;
        block3: for (l = 0; l < 16; ++l) {
            this.layersUsed[l] = false;
            for (i = k; i < this.getPrimitiveVector().size(); ++i) {
                GraphicPrimitive g = this.getPrimitiveVector().get(i);
                if (g.layer > this.maxLayer) {
                    this.maxLayer = g.layer;
                }
                if (!g.containsLayer(l)) continue;
                this.layersUsed[l] = true;
                k = i;
                for (int z = 0; z < l; ++z) {
                    this.layersUsed[z] = true;
                }
                continue block3;
            }
        }
    }

    public final int getMaxLayer() {
        return this.maxLayer;
    }

    public boolean containsLayer(int l) {
        return this.layersUsed[l];
    }

    public boolean isEmpty() {
        return this.getPrimitiveVector().size() == 0;
    }

    public final void setChanged(boolean c) {
        this.changed = c;
    }

    public Vector<GraphicPrimitive> getPrimitiveVector() {
        return this.primitiveVector;
    }

    public void setPrimitiveVector(Vector<GraphicPrimitive> primitiveVector) {
        this.primitiveVector = primitiveVector;
    }

    public void setDrawOnlyPads(boolean pd) {
        this.drawOnlyPads = pd;
    }

    public void setDrawOnlyLayer(int la) {
        this.drawOnlyLayer = la;
    }
}

