/*
 * Decompiled with CFR 0.152.
 */
package circuit.controllers;

import circuit.HasChangedListener;
import circuit.controllers.ParserActions;
import globals.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import undo.LibraryUndoListener;
import undo.UndoActorListener;
import undo.UndoManager;
import undo.UndoState;

public class UndoActions
implements UndoActorListener {
    private final ParserActions pa;
    private final UndoManager um;
    private final Vector<String> tempDir;
    private static final int MAX_UNDO = 100;
    private boolean isModified;
    private String tempLibraryDirectory = "";
    private LibraryUndoListener libraryUndoListener;
    private HasChangedListener cl;

    public UndoActions(ParserActions a) {
        this.pa = a;
        this.um = new UndoManager(100);
        this.libraryUndoListener = null;
        this.tempDir = new Vector();
        this.cl = null;
    }

    public void undo() {
        UndoState r = this.um.undoPop();
        if (this.um.isNextOperationOnALibrary() && this.libraryUndoListener != null) {
            this.libraryUndoListener.undoLibrary(r.libraryDir);
        }
        if (!"".equals(r.text)) {
            StringBuffer s = new StringBuffer(r.text);
            this.pa.parseString(s);
        }
        this.isModified = r.isModified;
        this.pa.openFileName = r.fileName;
        if (this.cl != null) {
            this.cl.somethingHasChanged();
        }
    }

    public void redo() {
        UndoState r = this.um.undoRedo();
        if (r.libraryOperation && this.libraryUndoListener != null) {
            this.libraryUndoListener.undoLibrary(r.libraryDir);
        }
        if (!"".equals(r.text)) {
            StringBuffer s = new StringBuffer(r.text);
            this.pa.parseString(s);
        }
        this.isModified = r.isModified;
        this.pa.openFileName = r.fileName;
        if (this.cl != null) {
            this.cl.somethingHasChanged();
        }
    }

    public void saveUndoState() {
        UndoState s = new UndoState();
        s.text = this.pa.getText(true).toString();
        s.isModified = this.isModified;
        s.fileName = this.pa.openFileName;
        s.libraryDir = this.tempLibraryDirectory;
        s.libraryOperation = false;
        this.um.undoPush(s);
        this.isModified = true;
        if (this.cl != null) {
            this.cl.somethingHasChanged();
        }
    }

    public void saveUndoLibrary(String t) {
        this.tempLibraryDirectory = t;
        UndoState s = new UndoState();
        s.text = this.pa.getText(true).toString();
        s.libraryDir = this.tempLibraryDirectory;
        s.isModified = this.isModified;
        s.fileName = this.pa.openFileName;
        s.libraryOperation = true;
        this.tempDir.add(t);
        this.um.undoPush(s);
    }

    public void setLibraryUndoListener(LibraryUndoListener l) {
        this.libraryUndoListener = l;
    }

    public boolean getModified() {
        return this.isModified;
    }

    public void setModified(boolean s) {
        this.isModified = s;
        if (this.cl != null) {
            this.cl.somethingHasChanged();
        }
    }

    public void setHasChangedListener(HasChangedListener l) {
        this.cl = l;
    }

    public void doTheDishes() {
        for (int i = 0; i < this.tempDir.size(); ++i) {
            try {
                FileUtils.deleteDirectory(new File(this.tempDir.get(i)));
                continue;
            }
            catch (IOException E) {
                System.out.println("Warning: " + E);
            }
        }
    }
}

