/*
 * Decompiled with CFR 0.152.
 */
package undo;

import java.util.NoSuchElementException;
import java.util.Vector;
import undo.UndoState;

public class UndoManager {
    private Vector<Object> undoBuffer;
    private int pointer;
    private boolean isRedoable;

    public UndoManager(int size) {
        this.undoBuffer = new Vector(size);
        this.undoReset();
    }

    public void undoReset() {
        this.undoBuffer.removeAllElements();
        this.undoPush(new UndoState());
        this.pointer = 1;
        this.isRedoable = false;
    }

    public void undoPush(Object state) {
        if (this.undoBuffer.size() == this.undoBuffer.capacity()) {
            this.undoBuffer.removeElementAt(0);
            --this.pointer;
        }
        this.undoBuffer.add(this.pointer++, state);
        this.isRedoable = false;
        for (int i = this.pointer; i < this.undoBuffer.size(); ++i) {
            this.undoBuffer.removeElementAt(this.pointer);
        }
    }

    public Object undoPop() throws NoSuchElementException {
        --this.pointer;
        if (this.pointer < 1) {
            this.pointer = 1;
        }
        Object o = this.undoBuffer.get(this.pointer - 1);
        this.isRedoable = true;
        return o;
    }

    public Object undoRedo() throws NoSuchElementException {
        if (!this.isRedoable) {
            NoSuchElementException E = new NoSuchElementException();
            throw E;
        }
        ++this.pointer;
        if (this.pointer > this.undoBuffer.size()) {
            this.pointer = this.undoBuffer.size();
        }
        Object o = this.undoBuffer.get(this.pointer - 1);
        return o;
    }
}

