/*
 * Decompiled with CFR 0.152.
 */
package toolbars;

import dialogs.LayerCellRenderer;
import geom.ChangeCoordinatesListener;
import globals.Globals;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import layers.LayerDesc;
import toolbars.ChangeGridState;
import toolbars.ChangeSelectedLayer;
import toolbars.ChangeZoomListener;
import toolbars.ZoomToFitListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarZoom
extends JToolBar
implements ActionListener,
ChangeZoomListener,
ChangeCoordinatesListener {
    private JComboBox zoom;
    private JButton zoomFit;
    private JToggleButton showGrid;
    private JToggleButton snapGrid;
    private JLabel coords;
    private JLabel infos;
    private ChangeGridState changeListener;
    private boolean flagModify;
    private double oldzoom;
    private ChangeZoomListener notifyZoomChangeListener;
    private ZoomToFitListener actualZoomToFitListener;
    private JComboBox layerSel;
    private ChangeSelectedLayer changeLayerListener;
    private Vector<LayerDesc> layers;

    public ToolbarZoom(Vector<LayerDesc> l) {
        this.putClientProperty("Quaqua.ToolBar.style", "title");
        this.layers = l;
        this.zoom = new JComboBox();
        this.zoom.addItem("25%");
        this.zoom.addItem("50%");
        this.zoom.addItem("75%");
        this.zoom.addItem("100%");
        this.zoom.addItem("150%");
        this.zoom.addItem("200%");
        this.zoom.addItem("300%");
        this.zoom.addItem("400%");
        this.zoom.addItem("1000%");
        this.zoom.setPreferredSize(new Dimension(80, 29));
        this.zoom.setMaximumSize(new Dimension(80, 38));
        this.zoom.setMinimumSize(new Dimension(80, 18));
        this.zoomFit = new JButton(Globals.messages.getString("Zoom_fit"));
        this.showGrid = new JToggleButton(Globals.messages.getString("ShowGrid"));
        this.snapGrid = new JToggleButton(Globals.messages.getString("SnapToGrid"));
        this.coords = new JLabel("");
        this.infos = new JLabel("");
        this.setBorderPainted(false);
        this.layerSel = new JComboBox<LayerDesc>(new Vector<LayerDesc>(this.layers));
        this.layerSel.setToolTipText(Globals.messages.getString("tooltip_layerSel"));
        this.layerSel.setRenderer(new LayerCellRenderer());
        this.changeListener = null;
        this.zoomFit.putClientProperty("Quaqua.Button.style", "toggleWest");
        this.showGrid.putClientProperty("Quaqua.Button.style", "toggleCenter");
        this.snapGrid.putClientProperty("Quaqua.Button.style", "toggleEast");
        this.zoom.addActionListener(this);
        this.zoomFit.addActionListener(this);
        this.showGrid.addActionListener(this);
        this.snapGrid.addActionListener(this);
        this.layerSel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ToolbarZoom.this.layerSel.getSelectedIndex() >= 0 && ToolbarZoom.this.changeListener != null) {
                    ToolbarZoom.this.changeLayerListener.changeSelectedLayer(ToolbarZoom.this.layerSel.getSelectedIndex());
                }
            }
        });
        this.changeListener = null;
        this.add(this.zoom);
        this.add(this.zoomFit);
        this.add(this.showGrid);
        this.add(this.snapGrid);
        this.add(this.layerSel);
        this.add(Box.createGlue());
        this.add(this.infos);
        this.add(this.coords);
        this.infos.setPreferredSize(new Dimension(250, 28));
        this.infos.setMinimumSize(new Dimension(50, 18));
        this.infos.setMaximumSize(new Dimension(250, 38));
        this.coords.setPreferredSize(new Dimension(300, 28));
        this.coords.setMinimumSize(new Dimension(300, 18));
        this.coords.setMaximumSize(new Dimension(300, 38));
        this.setFloatable(true);
        this.setRollover(false);
        this.zoom.setEditable(true);
        this.showGrid.setSelected(true);
        this.snapGrid.setSelected(true);
        this.changeCoordinates(0, 0);
    }

    public void addLayerListener(ChangeSelectedLayer c) {
        this.changeLayerListener = c;
    }

    public void addGridStateListener(ChangeGridState c) {
        this.changeListener = c;
    }

    public void addChangeZoomListener(ChangeZoomListener c) {
        this.notifyZoomChangeListener = c;
    }

    public void addZoomToFitListener(ZoomToFitListener c) {
        this.actualZoomToFitListener = c;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String s = evt.getActionCommand();
        if (s.equals(Globals.messages.getString("ShowGrid")) && this.changeListener != null) {
            this.changeListener.setGridVisibility(this.showGrid.isSelected());
        }
        if (s.equals(Globals.messages.getString("SnapToGrid")) && this.changeListener != null) {
            this.changeListener.setSnapState(this.snapGrid.isSelected());
        }
        if (s.equals(Globals.messages.getString("Zoom_fit")) && this.actualZoomToFitListener != null) {
            this.actualZoomToFitListener.zoomToFit();
        }
        if (evt.getSource() instanceof JComboBox) {
            JComboBox source = (JComboBox)evt.getSource();
            if (this.notifyZoomChangeListener != null) {
                try {
                    s = (String)source.getSelectedItem();
                    s = s.replace('%', ' ').trim();
                    double z = Double.parseDouble(s);
                    if (z == this.oldzoom) {
                        return;
                    }
                    if (10.0 <= z && z <= 1000.0) {
                        this.oldzoom = z;
                        this.notifyZoomChangeListener.changeZoom(z / 100.0);
                    }
                }
                catch (NumberFormatException E) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void changeZoom(double z) {
        this.zoom.setSelectedItem("" + (int)(z * 100.0) + "%");
    }

    @Override
    public void changeCoordinates(int x, int y) {
        int xum = x * 127;
        int yum = y * 127;
        float xmm = (float)xum / 1000.0f;
        float ymm = (float)yum / 1000.0f;
        this.coords.setText("" + x + "; " + y + " (" + xmm + " mm; " + ymm + " mm)");
    }

    public void changeStrict(boolean strict) {
    }

    @Override
    public void changeInfos(String s) {
        this.infos.setText(s);
    }
}

