/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.Vector;
import primitives.GraphicPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitivePCBPad
extends GraphicPrimitive {
    private int rx;
    private int ry;
    private int sty;
    private int ri;
    private static final int CORNER_DIAMETER = 5;
    private boolean drawOnlyPads;
    static final int N_POINTS = 3;
    private int x1;
    private int y1;
    private int rrx;
    private int rry;
    private int xa;
    private int ya;
    private int rox;
    private int roy;
    private int rix;
    private int riy;
    private int rrx2;
    private int rry2;
    private int rix2;
    private int riy2;

    @Override
    public int getControlPointNumber() {
        return 3;
    }

    public PrimitivePCBPad(int x1, int y1, int wx, int wy, int radi, int st, int layer) {
        this.initPrimitive(-1);
        this.virtualPoint[0].x = x1;
        this.virtualPoint[0].y = y1;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
        this.rx = wx;
        this.ry = wy;
        this.ri = radi;
        this.sty = st;
        this.setLayer(layer);
    }

    public PrimitivePCBPad() {
        this.rx = 0;
        this.ry = 0;
        this.sty = 0;
        this.ri = 0;
        this.initPrimitive(-1);
    }

    @Override
    public final boolean needsHoles() {
        return true;
    }

    @Override
    public final void draw(Graphics2D g, MapCoordinates coordSys, Vector layerV) {
        if (!this.selectLayer(g, layerV)) {
            return;
        }
        this.drawText(g, coordSys, layerV, -1);
        if (this.changed) {
            this.changed = false;
            this.x1 = this.virtualPoint[0].x;
            this.y1 = this.virtualPoint[0].y;
            this.rrx = Math.abs(coordSys.mapXi(this.x1, this.y1, false) - coordSys.mapXi(this.x1 + this.rx, this.y1 + this.ry, false));
            this.rry = Math.abs(coordSys.mapYi(this.x1, this.y1, false) - coordSys.mapYi(this.x1 + this.rx, this.y1 + this.ry, false));
            this.rrx2 = this.rrx / 2;
            this.rry2 = this.rry / 2;
            this.xa = coordSys.mapX(this.x1, this.y1);
            this.ya = coordSys.mapY(this.x1, this.y1);
            coordSys.trackPoint(this.x1 - this.rrx, this.y1 - this.rry);
            coordSys.trackPoint(this.x1 + this.rrx, this.y1 + this.rry);
            this.rox = Math.abs(this.xa - coordSys.mapXi(this.x1 + 5, this.y1 + 5, false));
            this.roy = Math.abs(this.ya - coordSys.mapYi(this.x1 + 5, this.y1 + 5, false));
            this.rix = Math.abs(this.xa - coordSys.mapXi(this.x1 + this.ri, this.y1 + this.ri, false));
            this.riy = Math.abs(this.ya - coordSys.mapYi(this.x1 + this.ri, this.y1 + this.ri, false));
            this.rix2 = this.rix / 2;
            this.riy2 = this.riy / 2;
        }
        if (!g.hitClip(this.xa - this.rrx2, this.ya - this.rry2, this.rrx, this.rry)) {
            return;
        }
        if (!this.drawOnlyPads) {
            switch (this.sty) {
                case 1: {
                    g.fillRect(this.xa - this.rrx2, this.ya - this.rry2, this.rrx, this.rry);
                    break;
                }
                case 2: {
                    g.fillRoundRect(this.xa - this.rrx2, this.ya - this.rry2, this.rrx, this.rry, this.rox, this.roy);
                    break;
                }
                default: {
                    g.fillOval(this.xa - this.rrx2, this.ya - this.rry2, this.rrx, this.rry);
                    break;
                }
            }
        } else {
            g.setColor(Color.white);
            g.fillOval(this.xa - this.rix2, this.ya - this.riy2, this.rix, this.riy);
        }
    }

    @Override
    public void parseTokens(String[] tokens, int N) throws IOException {
        this.changed = true;
        if (tokens[0].equals("PA")) {
            if (N < 7) {
                IOException E = new IOException("bad arguments on PA");
                throw E;
            }
            int x1 = this.virtualPoint[0].x = Integer.parseInt(tokens[1]);
            int y1 = this.virtualPoint[0].y = Integer.parseInt(tokens[2]);
            this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
            this.rx = Integer.parseInt(tokens[3]);
            this.ry = Integer.parseInt(tokens[4]);
            this.ri = Integer.parseInt(tokens[5]);
            this.sty = Integer.parseInt(tokens[6]);
            if (N > 7) {
                this.parseLayer(tokens[7]);
            }
        } else {
            IOException E = new IOException("PA: Invalid primitive:" + tokens[0] + " programming error?");
            throw E;
        }
    }

    @Override
    public void setDrawOnlyPads(boolean pd) {
        this.drawOnlyPads = pd;
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> v = super.getControls();
        ParameterDescription pd = new ParameterDescription();
        pd.parameter = new Integer(this.rx);
        pd.description = Globals.messages.getString("ctrl_x_radius");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Integer(this.ry);
        pd.description = Globals.messages.getString("ctrl_y_radius");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Integer(this.ri);
        pd.description = Globals.messages.getString("ctrl_internal_radius");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Integer(this.sty);
        pd.description = Globals.messages.getString("ctrl_pad_style");
        v.add(pd);
        return v;
    }

    @Override
    public int setControls(Vector<ParameterDescription> v) {
        int i = super.setControls(v);
        ParameterDescription pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Integer) {
            this.rx = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Integer) {
            this.ry = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Integer) {
            this.ri = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Integer) {
            this.sty = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        return i;
    }

    @Override
    public void rotatePrimitive(boolean bCounterClockWise, int ix, int iy) {
        super.rotatePrimitive(bCounterClockWise, ix, iy);
        int swap = this.rx;
        this.rx = this.ry;
        this.ry = swap;
    }

    @Override
    public int getDistanceToPoint(int px, int py) {
        if (this.checkText(px, py)) {
            return 0;
        }
        int distance = GeometricDistances.pointToPoint(this.virtualPoint[0].x, this.virtualPoint[0].y, px, py) - Math.min(this.rx, this.ry) / 2;
        return distance > 0 ? distance : 0;
    }

    @Override
    public String toString(boolean extensions) {
        String s = "PA " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.rx + " " + this.ry + " " + this.ri + " " + this.sty + " " + this.getLayer() + "\n";
        s = s + this.saveText(extensions);
        return s;
    }

    @Override
    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        this.exportText(exp, cs, -1);
        exp.exportPCBPad(cs.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), this.sty, Math.abs(cs.mapX(this.virtualPoint[0].x + this.rx, this.virtualPoint[0].y + this.ry) - cs.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y)), Math.abs(cs.mapY(this.virtualPoint[0].x + this.rx, this.virtualPoint[0].y + this.ry) - cs.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y)), (int)((double)this.ri * cs.getXMagnitude()), this.getLayer(), this.drawOnlyPads);
    }

    @Override
    public int getNameVirtualPointNumber() {
        return 1;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return 2;
    }
}

