/*
 * Decompiled with CFR 0.152.
 */
package geom;

public class GeometricDistances {
    public static final int MIN_DISTANCE = 100;
    public static final int MAX_BEZIER_SEGMENTS = 10;
    private static double dx;
    private static double dy;
    private static double t;
    private static double xmin;
    private static double ymin;
    private static double xmax;
    private static double ymax;
    private static int idx;
    private static int idy;
    private static int it;
    private static int ixmin;
    private static int ixmax;
    private static int iymin;
    private static int iymax;
    private static int i;
    private static int j;
    private static boolean c;

    public static double pointToPoint(double xa, double ya, double xb, double yb) {
        if (Math.abs(xa - xb) < 100.0 || Math.abs(ya - yb) < 100.0) {
            return Math.sqrt((xa - xb) * (xa - xb) + (ya - yb) * (ya - yb));
        }
        return 100.0;
    }

    public static int pointToPoint(int xa, int ya, int xb, int yb) {
        if (Math.abs(xa - xb) < 100 || Math.abs(ya - yb) < 100) {
            return (int)Math.sqrt((xa - xb) * (xa - xb) + (ya - yb) * (ya - yb));
        }
        return 100;
    }

    public static double pointToSegment(double xa, double ya, double xb, double yb, double x, double y) {
        if (xa > xb) {
            xmin = xb;
            xmax = xa;
        } else {
            xmin = xa;
            xmax = xb;
        }
        if (x < xmin - 100.0 || x > xmax + 100.0) {
            return 100.0;
        }
        if (ya > yb) {
            ymin = yb;
            ymax = ya;
        } else {
            ymin = ya;
            ymax = yb;
        }
        if (y < ymin - 100.0 || y > ymax + 100.0) {
            return 100.0;
        }
        dx = xb - xa;
        dy = yb - ya;
        if (dx == 0.0 && dy == 0.0) {
            dx = x - xa;
            dy = y - yb;
            return Math.sqrt(dx * dx + dy * dy);
        }
        t = ((x - xa) * dx + (y - ya) * dy) / (dx * dx + dy * dy);
        if (t < 0.0) {
            dx = x - xa;
            dy = y - ya;
        } else if (t > 1.0) {
            dx = x - xb;
            dy = y - yb;
        } else {
            dx = x - (xa + t * dx);
            dy = y - (ya + t * dy);
        }
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static int pointToSegment(int xa, int ya, int xb, int yb, int x, int y) {
        if (xa > xb) {
            ixmin = xb;
            ixmax = xa;
        } else {
            ixmin = xa;
            ixmax = xb;
        }
        if (x < ixmin - 100 || x > ixmax + 100) {
            return 100;
        }
        if (ya > yb) {
            iymin = yb;
            iymax = ya;
        } else {
            iymin = ya;
            iymax = yb;
        }
        if (y < iymin - 100 || y > iymax + 100) {
            return 100;
        }
        if (xb == xa && yb == ya) {
            idx = x - xa;
            idy = y - yb;
            return (int)Math.sqrt(idx * idx + idy * idy);
        }
        idx = xb - xa;
        idy = yb - ya;
        it = 1000 * ((x - xa) * idx + (y - ya) * idy) / (idx * idx + idy * idy);
        if (it < 0) {
            idx = x - xa;
            idy = y - ya;
        } else if (it > 1000) {
            idx = x - xb;
            idy = y - yb;
        } else {
            idx = x - (xa + it * idx / 1000);
            idy = y - (ya + it * idy / 1000);
        }
        return (int)Math.sqrt(idx * idx + idy * idy);
    }

    public static boolean pointInPolygon(int[] xp, int[] yp, int npol, double x, double y) {
        c = false;
        i = 0;
        j = npol - 1;
        while (i < npol) {
            if (((double)yp[i] <= y && y < (double)yp[j] || (double)yp[j] <= y && y < (double)yp[i]) && x < (double)(xp[j] - xp[i]) * (y - (double)yp[i]) / (double)(yp[j] - yp[i]) + (double)xp[i]) {
                c = !c;
            }
            j = i;
            j = i++;
        }
        return c;
    }

    public static boolean pointInEllipse(double ex, double ey, double w, double h, double px, double py) {
        dx = Math.abs(px - (ex + w / 2.0));
        dy = Math.abs(py - (ey + h / 2.0));
        if (dx > w / 2.0 || dy > h / 2.0) {
            return false;
        }
        return 4.0 * dx * dx / w / w + 4.0 * dy * dy / h / h < 1.0;
    }

    public static boolean pointInEllipse(int ex, int ey, int w, int h, int px, int py) {
        return GeometricDistances.pointInEllipse((double)ex, (double)ey, (double)w, (double)h, (double)px, (double)py);
    }

    public static double pointToEllipse(double ex, double ey, double w, double h, double px, double py) {
        double dx = Math.abs(px - (ex + w / 2.0));
        double dy = Math.abs(py - (ey + h / 2.0));
        if (w == 0.0) {
            return GeometricDistances.pointToSegment(ex, ey, ex, ey + h, px, py);
        }
        if (h == 0.0) {
            return GeometricDistances.pointToSegment(ex, ey, ex + w, ey, px, py);
        }
        double l = 4.0 * dx * dx / w / w + 4.0 * dy * dy / h / h;
        l = Math.sqrt(Math.abs(l - 1.0) * Math.min(w, h) * Math.min(w, h) / 4.0) / 2.0;
        return l;
    }

    public static int pointToEllipse(int ex, int ey, int w, int h, int px, int py) {
        return (int)GeometricDistances.pointToEllipse((double)ex, (double)ey, (double)w, (double)h, (double)px, (double)py);
    }

    public static boolean pointInRectangle(double ex, double ey, double w, double h, double px, double py) {
        return !(ex > px || px > ex + w || ey > py) && !(py > ey + h);
    }

    public static boolean pointInRectangle(int ex, int ey, int w, int h, int px, int py) {
        return ex <= px && px <= ex + w && ey <= py && py <= ey + h;
    }

    public static double pointToRectangle(double ex, double ey, double w, double h, double px, double py) {
        double d1 = GeometricDistances.pointToSegment(ex, ey, ex + w, ey, px, py);
        double d2 = GeometricDistances.pointToSegment(ex + w, ey, ex + w, ey + h, px, py);
        double d3 = GeometricDistances.pointToSegment(ex + w, ey + h, ex, ey + h, px, py);
        double d4 = GeometricDistances.pointToSegment(ex, ey + h, ex, ey, px, py);
        return Math.min(Math.min(d1, d2), Math.min(d3, d4));
    }

    public static int pointToRectangle(int ex, int ey, int w, int h, int px, int py) {
        if (GeometricDistances.pointInRectangle(ex - 1, ey - 1, w + 2, h + 2, px, py) && !GeometricDistances.pointInRectangle(ex + 1, ey + 1, w - 2, h - 2, px, py)) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    public static int pointToBezier(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int px, int py) {
        int distance = Integer.MAX_VALUE;
        int i = 0;
        int[] x = new int[11];
        int[] y = new int[11];
        double limit = 0.1;
        for (double u = 0.0; u < 1.0; u += limit) {
            double umu = 1.0 - u;
            double b03 = umu * umu * umu;
            double b13 = 3.0 * u * umu * umu;
            double b23 = 3.0 * u * u * umu;
            double b33 = u * u * u;
            x[i] = (int)((double)x1 * b03 + (double)x2 * b13 + (double)x3 * b23 + (double)x4 * b33);
            y[i] = (int)((double)y1 * b03 + (double)y2 * b13 + (double)y3 * b23 + (double)y4 * b33);
            ++i;
        }
        for (int j = 0; j < 10; ++j) {
            distance = Math.min(distance, GeometricDistances.pointToSegment(x[j], y[j], x[j + 1], y[j + 1], px, py));
        }
        return distance;
    }
}

