/*
 * Decompiled with CFR 0.152.
 */
package export;

import export.ExportInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Vector;
import layers.LayerDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportSVG
implements ExportInterface {
    private OutputStreamWriter fstream;
    private BufferedWriter out;
    private Vector layerV;
    private Color c;
    private double strokeWidth;
    static final String[] dash = new String[]{"2.5,5", "1.25,1.25", "0.5,0.5", "0.5,1.25", "0.5,1.25,1.25,1.25"};

    public double cLe(double l) {
        return (double)Math.round(l * 100.0) / 100.0;
    }

    public ExportSVG(File f) throws IOException {
        this.fstream = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF8");
    }

    @Override
    public void exportStart(Dimension totalSize, Vector<LayerDesc> la, int grid) throws IOException {
        this.layerV = la;
        this.out = new BufferedWriter(this.fstream);
        int wi = totalSize.width;
        int he = totalSize.height;
        this.out.write("<?xml version=\"1.0\" encoding=\"UTF8\" standalone=\"no\"?> \n<!DOCTYPE svg PUBLIC \"-//W3C//Dtd SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/Dtd/svg11.dtd\">\n<svg width=\"" + this.cLe(wi) + "\" height=\"" + this.cLe(he) + "\" version=\"1.1\" " + "xmlns=\"http://www.w3.org/2000/svg\" " + "xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n" + "<!-- Created by FidoCadJ ver. " + "0.24.1" + ", export filter by Davide Bucci -->\n");
    }

    @Override
    public void exportEnd() throws IOException {
        this.out.write("</svg>");
        this.out.close();
    }

    @Override
    public void exportAdvText(int x, int y, int sizex, int sizey, String fontname, boolean isBold, boolean isMirrored, boolean isItalic, int orientation, int layer, String text) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        this.c = l.getColor();
        this.out.write("<g transform=\"translate(" + this.cLe(x) + "," + this.cLe(y) + ")");
        double xscale = (double)sizex / 22.0 / (double)sizey * 38.0;
        if (orientation != 0) {
            double alpha = isMirrored ? orientation : -orientation;
            this.out.write(" rotate(" + alpha + ") ");
        }
        if (isMirrored) {
            xscale = -xscale;
        }
        this.out.write(" scale(" + xscale + ",1) ");
        this.out.write("\">");
        this.out.write("<text x=\"0\" y=\"" + this.cLe(sizey) + "\" font-family=\"" + fontname + "\" font-size=\"" + this.cLe(sizey) + "\" font-style=\"" + (isItalic ? "italic" : "") + "\" font-weigth=\"" + (isBold ? "bold" : "") + "\" " + "fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"" + ">");
        this.out.write(text);
        this.out.write("</text>\n");
        this.out.write("</g>\n");
    }

    @Override
    public void exportBezier(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double sW) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        this.c = l.getColor();
        this.strokeWidth = sW;
        this.out.write("<path d=\"M " + this.cLe(x1) + "," + this.cLe(y1) + " C " + this.cLe(x2) + "," + this.cLe(y2) + " " + this.cLe(x3) + "," + this.cLe(y3) + " " + this.cLe(x4) + "," + this.cLe(y4) + "\" ");
        this.checkColorAndWidth("fill=\"none\"", dashStyle);
        if (arrowStart) {
            this.exportArrow(x1, y1, x2, y2, arrowLength, arrowHalfWidth, arrowStyle);
        }
        if (arrowEnd) {
            this.exportArrow(x4, y4, x3, y3, arrowLength, arrowHalfWidth, arrowStyle);
        }
    }

    @Override
    public void exportConnection(int x, int y, int layer, double node_size) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        this.c = l.getColor();
        this.strokeWidth = this.cLe(0.33);
        this.out.write("<circle cx=\"" + this.cLe(x) + "\" cy=\"" + this.cLe(y) + "\"" + " r=\"" + this.cLe(node_size / 2.0) + "\" style=\"stroke:#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + ";stroke-width:" + this.strokeWidth + "\" fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"/>\n");
    }

    @Override
    public void exportLine(double x1, double y1, double x2, double y2, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double sW) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        this.c = l.getColor();
        this.strokeWidth = sW;
        this.out.write("<line x1=\"" + this.cLe(x1) + "\" y1=\"" + this.cLe(y1) + "\" x2=\"" + this.cLe(x2) + "\" y2=\"" + this.cLe(y2) + "\" ");
        this.checkColorAndWidth("fill=\"none\"", dashStyle);
        if (arrowStart) {
            this.exportArrow(x1, y1, x2, y2, arrowLength, arrowHalfWidth, arrowStyle);
        }
        if (arrowEnd) {
            this.exportArrow(x2, y2, x1, y1, arrowLength, arrowHalfWidth, arrowStyle);
        }
    }

    public boolean exportMacro(int x, int y, boolean isMirrored, int orientation, String macroName, String macroDesc, String name, int xn, int yn, String value, int xv, int yv, String font, int fontSize, Map m) throws IOException {
        return false;
    }

    @Override
    public void exportOval(int x1, int y1, int x2, int y2, boolean isFilled, int layer, int dashStyle, double sW) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        this.c = l.getColor();
        String fill_pattern = "";
        this.strokeWidth = sW;
        fill_pattern = isFilled ? "fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"" : "fill=\"none\"";
        this.out.write("<ellipse cx=\"" + this.cLe((double)(x1 + x2) / 2.0) + "\" cy=\"" + this.cLe((double)(y1 + y2) / 2.0) + "\" rx=\"" + this.cLe((double)Math.abs(x2 - x1) / 2.0) + "\" ry=\"" + this.cLe((double)Math.abs(y2 - y1) / 2.0) + "\" ");
        this.checkColorAndWidth(fill_pattern, dashStyle);
    }

    @Override
    public void exportPCBLine(int x1, int y1, int x2, int y2, int width, int layer) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        this.c = l.getColor();
        this.out.write("<line x1=\"" + this.cLe(x1) + "\" y1=\"" + this.cLe(y1) + "\" x2=\"" + this.cLe(x2) + "\" y2=\"" + this.cLe(y2) + "\" style=\"stroke:#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + ";stroke-linejoin:round;stroke-linecap:round" + ";stroke-width:" + width + "\"/>\n");
    }

    @Override
    public void exportPCBPad(int x, int y, int style, int six, int siy, int indiam, int layer, boolean onlyHole) throws IOException {
        this.strokeWidth = 0.33;
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        this.c = l.getColor();
        if (!onlyHole) {
            switch (style) {
                default: {
                    this.out.write("<ellipse cx=\"" + this.cLe(x) + "\" cy=\"" + this.cLe(y) + "\"" + " rx=\"" + this.cLe((double)six / 2.0) + "\" ry=\"" + this.cLe((double)siy / 2.0) + "\" style=\"stroke:#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + ";stroke-width:" + this.cLe(this.strokeWidth) + "\" fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"/>\n");
                    break;
                }
                case 1: {
                    double xdd = this.cLe((double)x - (double)six / 2.0);
                    double ydd = this.cLe((double)y - (double)siy / 2.0);
                    this.out.write("<rect x=\"" + xdd + "\" y=\"" + ydd + "\" rx=\"0\" ry=\"0\" " + "width=\"" + this.cLe(six) + "\" height=\"" + this.cLe(siy) + "\" style=\"stroke:#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + ";stroke-width:" + this.strokeWidth + "\" fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"/>\n");
                    break;
                }
                case 2: {
                    double xdd = this.cLe((double)x - (double)six / 2.0);
                    double ydd = this.cLe((double)y - (double)siy / 2.0);
                    double rd = this.cLe(2.5);
                    this.out.write("<rect x=\"" + xdd + "\" y=\"" + ydd + "\" rx=\"" + rd + "\" ry=\"" + rd + "\" " + "width=\"" + this.cLe(six) + "\" height=\"" + this.cLe(siy) + "\" style=\"stroke:#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + ";stroke-width:" + this.strokeWidth + "\" fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"/>\n");
                }
            }
        }
        this.out.write("<circle cx=\"" + this.cLe(x) + "\" cy=\"" + this.cLe(y) + "\"" + " r=\"" + this.cLe((double)indiam / 2.0) + "\" style=\"stroke:white;stroke-width:" + this.strokeWidth + "\" fill=\"white\"/>\n");
    }

    @Override
    public void exportPolygon(Point2D.Double[] vertices, int nVertices, boolean isFilled, int layer, int dashStyle, double sW) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        this.c = l.getColor();
        String fill_pattern = "";
        this.strokeWidth = sW;
        fill_pattern = isFilled ? "fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"" : "fill=\"none\"";
        this.out.write("<polygon points=\"");
        for (int i = 0; i < nVertices; ++i) {
            this.out.write("" + this.cLe(vertices[i].x) + "," + this.cLe(vertices[i].y) + " ");
        }
        this.out.write("\" ");
        this.checkColorAndWidth(fill_pattern, dashStyle);
    }

    @Override
    public boolean exportCurve(Point2D.Double[] vertices, int nVertices, boolean isFilled, boolean isClosed, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double sW) throws IOException {
        return false;
    }

    @Override
    public void exportRectangle(int x1, int y1, int x2, int y2, boolean isFilled, int layer, int dashStyle, double sW) throws IOException {
        this.strokeWidth = sW;
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        this.c = l.getColor();
        String fill_pattern = "";
        fill_pattern = isFilled ? "fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"" : "fill=\"none\"";
        this.out.write("<rect x=\"" + this.cLe(Math.min(x1, x2)) + "\" y=\"" + this.cLe(Math.min(y1, y2)) + "\" rx=\"0\" ry=\"0\" " + "width=\"" + this.cLe(Math.abs(x2 - x1)) + "\" height=\"" + this.cLe(Math.abs(y2 - y1)) + "\" ");
        this.checkColorAndWidth(fill_pattern, dashStyle);
    }

    private String convertToHex2(int v) {
        String s = Integer.toHexString(v);
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    private void checkColorAndWidth(String fill_pattern, int dashStyle) throws IOException {
        this.out.write("style=\"stroke:#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()));
        if (dashStyle > 0) {
            this.out.write(";stroke-dasharray: " + dash[dashStyle]);
        }
        this.out.write(";stroke-width:" + this.strokeWidth + ";fill-rule: evenodd;\" " + fill_pattern + "/>\n");
    }

    private String roundTo(double n) {
        int ch = 2;
        return "" + (double)((int)(n * Math.pow(10.0, ch))) / Math.pow(10.0, ch);
    }

    @Override
    public void exportArrow(double x, double y, double xc, double yc, double l, double h, int style) throws IOException {
        double alpha = x != xc ? Math.atan((y - yc) / (x - xc)) : 1.5707963267948966 + (y - yc < 0.0 ? 0.0 : Math.PI);
        double x0 = x - l * Math.cos(alpha += x - xc > 0.0 ? 0.0 : Math.PI);
        double y0 = y - l * Math.sin(alpha);
        double x1 = x0 - h * Math.sin(alpha);
        double y1 = y0 + h * Math.cos(alpha);
        double x2 = x0 + h * Math.sin(alpha);
        double y2 = y0 - h * Math.cos(alpha);
        this.out.write("<polygon points=\"");
        this.out.write("" + this.roundTo(x) + "," + this.roundTo(y) + " ");
        this.out.write("" + this.roundTo(x1) + "," + this.roundTo(y1) + " ");
        this.out.write("" + this.roundTo(x2) + "," + this.roundTo(y2) + "\" ");
        String fill_pattern = (style & 2) == 0 ? "fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"" : "fill=\"none\"";
        this.checkColorAndWidth(fill_pattern, 0);
        if ((style & 1) != 0) {
            double x3 = x - h * Math.sin(alpha);
            double y3 = y + h * Math.cos(alpha);
            double x4 = x + h * Math.sin(alpha);
            double y4 = y - h * Math.cos(alpha);
            this.out.write("<line x1=\"" + this.cLe(x3) + "\" y1=\"" + this.cLe(y3) + "\" x2=\"" + this.cLe(x4) + "\" y2=\"" + this.cLe(y4) + "\" ");
            this.checkColorAndWidth("fill=\"none\"", 0);
        }
    }
}

