/*
 * Decompiled with CFR 0.152.
 */
package export;

import circuit.ParseSchem;
import export.ExportInterface;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Vector;
import layers.LayerDesc;
import primitives.MacroDesc;
import primitives.PrimitiveAdvText;
import primitives.PrimitiveBezier;
import primitives.PrimitiveComplexCurve;
import primitives.PrimitiveConnection;
import primitives.PrimitiveLine;
import primitives.PrimitiveMacro;
import primitives.PrimitiveOval;
import primitives.PrimitivePCBLine;
import primitives.PrimitivePCBPad;
import primitives.PrimitivePolygon;
import primitives.PrimitiveRectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportFidoCad
implements ExportInterface {
    private OutputStreamWriter fstream;
    private BufferedWriter out;
    private Vector<LayerDesc> layerV;
    private boolean extensions = true;

    public int cLe(double l) {
        return (int)l;
    }

    public ExportFidoCad(File f) throws IOException {
        this.fstream = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF8");
        this.out = new BufferedWriter(this.fstream);
    }

    public void setExtensions(boolean e) {
        this.extensions = e;
    }

    @Override
    public void exportStart(Dimension totalSize, Vector<LayerDesc> la, int grid) throws IOException {
        this.layerV = la;
        int wi = totalSize.width;
        int he = totalSize.height;
        this.out.write("[FIDOCAD]\n");
        ParseSchem P = new ParseSchem();
        P.setLayers(la);
        this.out.write(new String(P.registerConfiguration(this.extensions)));
    }

    @Override
    public void exportEnd() throws IOException {
        this.out.close();
    }

    @Override
    public void exportAdvText(int x, int y, int sizex, int sizey, String fontname, boolean isBold, boolean isMirrored, boolean isItalic, int orientation, int layer, String text) throws IOException {
        int style = 0;
        if (isBold) {
            ++style;
        }
        if (isItalic) {
            style += 2;
        }
        if (isMirrored) {
            style += 4;
        }
        this.out.write(new PrimitiveAdvText(this.cLe(x), this.cLe(y), this.cLe(sizex), this.cLe(sizey), fontname, orientation, style, text, layer).toString(this.extensions));
    }

    @Override
    public void exportBezier(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        this.out.write(new PrimitiveBezier(this.cLe(x1), this.cLe(y1), this.cLe(x2), this.cLe(y2), this.cLe(x3), this.cLe(y3), this.cLe(x4), this.cLe(y4), layer, arrowStart, arrowEnd, arrowStyle, this.cLe(arrowLength), this.cLe(arrowHalfWidth), dashStyle).toString(this.extensions));
    }

    @Override
    public void exportConnection(int x, int y, int layer, double size) throws IOException {
        this.out.write(new PrimitiveConnection(this.cLe(x), this.cLe(y), layer).toString(this.extensions));
    }

    @Override
    public void exportLine(double x1, double y1, double x2, double y2, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        this.out.write(new PrimitiveLine(this.cLe(x1), this.cLe(y1), this.cLe(x2), this.cLe(y2), layer, arrowStart, arrowEnd, arrowStyle, this.cLe(arrowLength), this.cLe(arrowHalfWidth), dashStyle).toString(this.extensions));
    }

    @Override
    public boolean exportMacro(int x, int y, boolean isMirrored, int orientation, String macroName, String macroDesc, String name, int xn, int yn, String value, int xv, int yv, String font, int fontSize, Map<String, MacroDesc> m) throws IOException {
        boolean isStandard = false;
        int dotpos = -1;
        dotpos = macroName.indexOf(".");
        if (dotpos < 0) {
            isStandard = true;
        } else {
            String library = macroName.substring(0, dotpos);
            if (this.extensions && library.equals("pcb")) {
                isStandard = true;
            } else if (this.extensions && library.equals("ihram")) {
                isStandard = true;
            } else if (this.extensions && library.equals("elettrotecnica")) {
                isStandard = true;
            }
        }
        if (isStandard) {
            this.out.write(new PrimitiveMacro(m, this.layerV, this.cLe(x), this.cLe(y), macroName, name, this.cLe(xn), this.cLe(yn), value, this.cLe(xv), this.cLe(yv), font, this.cLe(fontSize), orientation / 90, isMirrored).toString(this.extensions));
            return true;
        }
        return false;
    }

    @Override
    public void exportOval(int x1, int y1, int x2, int y2, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        this.out.write(new PrimitiveOval(this.cLe(x1), this.cLe(y1), this.cLe(x2), this.cLe(y2), isFilled, layer, dashStyle).toString(this.extensions));
    }

    @Override
    public void exportPCBLine(int x1, int y1, int x2, int y2, int width, int layer) throws IOException {
        this.out.write(new PrimitivePCBLine(this.cLe(x1), this.cLe(y1), this.cLe(x2), this.cLe(y2), this.cLe(width), this.cLe(layer)).toString(this.extensions));
    }

    @Override
    public void exportPCBPad(int x, int y, int style, int six, int siy, int indiam, int layer, boolean onlyHole) throws IOException {
        if (!onlyHole) {
            this.out.write(new PrimitivePCBPad(this.cLe(x), this.cLe(y), this.cLe(six), this.cLe(siy), this.cLe(indiam), style, layer).toString(this.extensions));
        }
    }

    @Override
    public void exportPolygon(Point2D.Double[] vertices, int nVertices, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        PrimitivePolygon p = new PrimitivePolygon(isFilled, layer, dashStyle);
        for (int i = 0; i < nVertices; ++i) {
            p.addPoint(this.cLe(vertices[i].x), this.cLe(vertices[i].y));
        }
        this.out.write(p.toString(this.extensions));
    }

    @Override
    public boolean exportCurve(Point2D.Double[] vertices, int nVertices, boolean isFilled, boolean isClosed, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        PrimitiveComplexCurve p = new PrimitiveComplexCurve(isFilled, isClosed, layer, arrowStart, arrowEnd, arrowStyle, this.cLe(arrowLength), this.cLe(arrowHalfWidth), dashStyle);
        for (int i = 0; i < nVertices; ++i) {
            p.addPoint(this.cLe(vertices[i].x), this.cLe(vertices[i].y));
        }
        this.out.write(p.toString(this.extensions));
        return true;
    }

    @Override
    public void exportRectangle(int x1, int y1, int x2, int y2, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        this.out.write(new PrimitiveRectangle(this.cLe(x1), this.cLe(y1), this.cLe(x2), this.cLe(y2), isFilled, layer, dashStyle).toString(this.extensions));
    }

    @Override
    public void exportArrow(double x, double y, double xc, double yc, double l, double h, int style) throws IOException {
    }
}

