/*
 * Decompiled with CFR 0.152.
 */
import circuit.CircuitPanel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import toolbars.ChangeSelectionListener;

public class ScrollGestureRecognizer
implements AWTEventListener,
ChangeSelectionListener {
    private int actionSelected;
    private static ScrollGestureRecognizer instance = new ScrollGestureRecognizer();

    public ScrollGestureRecognizer() {
        this.start();
    }

    public static ScrollGestureRecognizer getInstance() {
        return instance;
    }

    void start() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
    }

    void stop() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    public void eventDispatched(AWTEvent event) {
        MouseEvent me = (MouseEvent)event;
        boolean isGesture = (SwingUtilities.isMiddleMouseButton(me) || this.actionSelected == 3) && me.getID() == 501;
        Component co = me.getComponent();
        if (!(co instanceof CircuitPanel)) {
            return;
        }
        if (!isGesture) {
            return;
        }
        JViewport viewPort = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, me.getComponent());
        if (viewPort == null) {
            return;
        }
        JRootPane rootPane = SwingUtilities.getRootPane(viewPort);
        if (rootPane == null) {
            return;
        }
        Point location = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), rootPane.getGlassPane());
        ScrollGlassPane glassPane = new ScrollGlassPane(rootPane.getGlassPane(), viewPort, location);
        rootPane.setGlassPane(glassPane);
        glassPane.setVisible(true);
    }

    public void setSelectionState(int s, String macro) {
        this.actionSelected = s;
    }

    public void setStrictCompatibility(boolean strict) {
    }

    public int getSelectionState() {
        return this.actionSelected;
    }
}

