/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fatcalc.core;

import java.util.ResourceBundle;
import net.sourceforge.fatcalc.core.SkinFold;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FatMethod {
    JACKSON_POLLOCK_3("JACKSON_POLLOCK_3", "JACKSON_POLLOCK_3_DESCRIPTION", true, true, false, true, new SkinFold[]{SkinFold.CHEST, SkinFold.ABDOMINAL, SkinFold.THIGH}, new SkinFold[]{SkinFold.TRICEP, SkinFold.SUPRAILIAC, SkinFold.THIGH}),
    JACKSON_POLLOCK_7("JACKSON_POLLOCK_7", "JACKSON_POLLOCK_7_DESCRIPTION", true, true, false, true, new SkinFold[]{SkinFold.CHEST, SkinFold.ABDOMINAL, SkinFold.THIGH, SkinFold.TRICEP, SkinFold.SUBSCAPULAR, SkinFold.SUPRAILIAC, SkinFold.MIDAXILLARY}, null),
    PARILLO("PARILLO", "PARILLO_DESCRIPTION", false, false, true, true, new SkinFold[]{SkinFold.CHEST, SkinFold.SUBSCAPULAR, SkinFold.BICEP, SkinFold.TRICEP, SkinFold.ABDOMINAL, SkinFold.SUPRAILIAC, SkinFold.THIGH, SkinFold.CALF, SkinFold.LOWER_BACK}, null),
    SLOAN("SLOAN", "SLOAN_DESCRIPTION", false, false, false, false, new SkinFold[]{SkinFold.SUBSCAPULAR, SkinFold.THIGH}, null),
    LOHMANN("LOHMANN", "LOHMANN_DESCRIPTION", false, false, false, true, new SkinFold[]{SkinFold.SUBSCAPULAR, SkinFold.TRICEP, SkinFold.ABDOMINAL}, null),
    NHCA("NHCA", "NHCA_DESCRIPTION", false, true, false, true, new SkinFold[]{SkinFold.SUBSCAPULAR, SkinFold.MIDAXILLARY, SkinFold.CHEST, SkinFold.ABDOMINAL}, null),
    FORSYTH_SINNING("FORSYTH_SINNING", "FORSYTH_SINNING_DESCRIPTION", false, false, false, false, new SkinFold[]{SkinFold.ABDOMINAL, SkinFold.MIDAXILLARY, SkinFold.TRICEP, SkinFold.SUBSCAPULAR}, null),
    DURNING_WOMERSLEY("DURNING_WOMERSLEY", "DURNING_WOMERSLEY_DESCRIPTION", false, true, false, true, new SkinFold[]{SkinFold.SUBSCAPULAR, SkinFold.TRICEP, SkinFold.BICEP, SkinFold.SUPRAILIAC}, null);

    private String name;
    private String description;
    private boolean female;
    private boolean ageNeeded;
    private boolean weightNeeded;
    private boolean useSum;
    private SkinFold[] foldsMale;
    private SkinFold[] foldsFemale;
    private final ResourceBundle bundle = ResourceBundle.getBundle("net/sourceforge/fatcalc/core/resources/FatMethod");

    private FatMethod(String name, String description, boolean female, boolean ageNeeded, boolean weightNeeded, boolean useSum, SkinFold[] foldsMale, SkinFold[] foldsFemale) {
        this.name = this.bundle.getString(name);
        this.description = this.bundle.getString(description);
        this.female = female;
        this.ageNeeded = ageNeeded;
        this.weightNeeded = weightNeeded;
        this.useSum = useSum;
        this.foldsMale = foldsMale;
        this.foldsFemale = female && foldsFemale == null ? foldsMale : foldsFemale;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isFemale() {
        return this.female;
    }

    public boolean isAgeNeeded() {
        return this.ageNeeded;
    }

    public boolean isWeightNeeded() {
        return this.weightNeeded;
    }

    public boolean isUsingSum() {
        return this.useSum;
    }

    public SkinFold[] getFoldsMale() {
        return (SkinFold[])this.foldsMale.clone();
    }

    public SkinFold[] getFoldsFemale() {
        return (SkinFold[])this.foldsFemale.clone();
    }

    public SkinFold[] getFolds(boolean female) {
        if (female) {
            return this.getFoldsFemale();
        }
        return this.getFoldsMale();
    }
}

