/****************************************************************/
/*      Quick-start setup for FtpServer.  This is a             */
/*      substitute for the case where you want only one         */
/*      read-only 'anonymous ftp' account.  For anything        */
/*      more sophisticated, you'll have to run Setup.exe.       */
/*                                                              */
/*      Author:       Peter Moylan (peter@ee.newcastle.edu.au)  */
/*      Started:      28 July 2002                              */
/*      Last revised: 28 July 2002                              */
/*                                                              */
/*  Usage:                                                      */
/*         quickstart                                           */
/*                                                              */
/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

/* Check the source directory, in case this command file is     */
/* run from a different directory.                              */

PARSE SOURCE rubbish rubbish SrcDir
j = LASTPOS('\', SrcDir)
IF j > 0 THEN SrcDir = LEFT(SrcDir, j-1)
ini = SrcDir'\FTPD.INI'

SAY "This is a quick setup for FtpServer, for those who want to get it running"
SAY "before reading the manual.  It creates one read-only 'anonymous ftp' user"
SAY "account. After running this script, you will be able to run ftpd.exe without"
SAY "first running Setup.exe."
SAY
SAY "Note, however, that this gives you only the simplest possible setup.  After"
SAY "reading the manual you should run Setup.exe to fine-tune the permissions that"
SAY "this account has, to create new users, and so on."
SAY
SAY "Note that you can run Setup.exe at any time, even while the server is running,"
SAY "to modify the configuration details."
SAY

/* Get the directory to be used for anonymous ftp, and ensure that */
/* it is a full path string.                                       */

SAY "What directory do you want this user to be able to download from?"
PARSE PULL PathString
char = RIGHT(PathString, 1)
IF (char='/') | (char='\') THEN PathString=LEFT(PathString,LENGTH(PathString)-1)
char = LEFT(PathString, 1)
IF (char='/') | (char='\') THEN
      PathString = LEFT(DIRECTORY(),2)||PathString
ELSE IF POS(':', PathString) = 0 THEN
      PathString = DIRECTORY()||'\'||PathString
SAY 'Using directory 'PathString

PathString = '"/"="'PathString'"'

/* Create the INI file entries for this new user. */

SAY "Creating new user 'anonymous'"
username = 'anonymous'

CALL SysIni ini, username, 'Category', '02'X
CALL SysIni ini, username, 'Notes', 'anonymous ftp account'
CALL SysIni ini, username, 'Password', '@'
CALL SysIni ini, username, 'RealName', ''
CALL SysIni ini, username, 'SingleUse', '00'X
CALL SysIni ini, username, 'SpeedLimit', 'FFFFFFFF'X
CALL SysIni ini, username, 'UserLimit', '0A000000'X
CALL SysIni ini, username, 'Volume', PathString

/* A few other options. */

CALL SysIni ini, '$SYS', 'CheckTaggers', '01'X
CALL SysIni ini, '$SYS', 'LogLevel', '01000000'X
CALL SysIni ini, '$SYS', 'TransLevel', '06000000'X

EXIT 0

