/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.submin;

import com.alee.laf.button.IAbstractButtonPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;

public abstract class AbstractButtonPainter<E extends AbstractButton, U extends BasicButtonUI, D extends IDecoration<E, D>>
extends com.alee.laf.button.AbstractButtonPainter<E, U, D>
implements IAbstractButtonPainter<E, U> {
    protected boolean drawShade;
    protected Color shadeColor;
    protected int shadeSize;
    protected boolean shadeShadow;
    protected int shadeShiftY;
    protected Color disabledForeground;
    protected int pressedShiftY;

    public boolean isDrawShade() {
        return this.drawShade;
    }

    public void setDrawShade(boolean drawShade) {
        this.drawShade = drawShade;
    }

    public Color getShadeColor() {
        return this.shadeColor;
    }

    public void setShadeColor(Color shadeColor) {
        this.shadeColor = shadeColor;
    }

    public boolean isShadeShadow() {
        return this.shadeShadow;
    }

    public void setShadeShadow(boolean value) {
        this.shadeShadow = value;
    }

    public int getShadeShiftY() {
        return this.shadeShiftY;
    }

    public void setShadeShiftY(int value) {
        this.shadeShiftY = value;
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setDisabledForeground(Color disabledForeground) {
        this.disabledForeground = disabledForeground;
    }

    public int getPressedShiftY() {
        return this.pressedShiftY;
    }

    public void setPressedShiftY(int value) {
        this.pressedShiftY = value;
    }

    protected void paintText(Graphics2D g2d) {
        String text = ((AbstractButton)this.component).getText();
        if (text != null && !text.equals("")) {
            Map map = SwingUtils.setupTextAntialias((Graphics2D)g2d);
            View v = (View)((AbstractButton)this.component).getClientProperty("html");
            if (v != null) {
                v.paint(g2d, this.textRect);
            } else {
                this.paintText(g2d, (AbstractButton)this.component, text);
            }
            SwingUtils.restoreTextAntialias((Graphics2D)g2d, (Map)map);
        }
    }

    protected void paintText(Graphics2D g2d, E label, String text) {
        int mnemonicIndex;
        FontMetrics fm = SwingUtils.getFontMetrics(label, (Graphics)g2d);
        ButtonModel model = ((AbstractButton)label).getModel();
        boolean enabled = ((Component)label).isEnabled();
        boolean sel = enabled && (model.isPressed() || model.isSelected());
        int textX = this.textRect.x;
        int textY = this.textRect.y + fm.getAscent() + (sel ? this.pressedShiftY : 0);
        g2d.setColor(enabled ? (sel ? this.selectedForeground : ((Component)label).getForeground()) : this.disabledForeground);
        int n = mnemonicIndex = enabled ? ((AbstractButton)label).getDisplayedMnemonicIndex() : -1;
        if (enabled && this.drawShade) {
            this.paintShadowText(g2d, text, textX, textY);
            if (mnemonicIndex >= 0 && mnemonicIndex < text.length()) {
                g2d.fillRect(textX + fm.stringWidth(text.substring(0, mnemonicIndex)), textY + fm.getDescent() - 1, fm.charWidth(text.charAt(mnemonicIndex)), 1);
            }
        } else {
            SwingUtils.drawStringUnderlineCharAt((Graphics)g2d, (String)text, (int)mnemonicIndex, (int)textX, (int)textY);
        }
    }

    protected void paintShadowText(Graphics2D g2d, String text, int textX, int textY) {
        g2d.translate(textX, textY);
        GraphicsUtils.paintTextEffect((Graphics2D)g2d, (String)text, (Color)this.shadeColor, (int)this.shadeSize, (double)(-this.shadeSize), (double)(this.shadeShiftY - this.shadeSize), (boolean)this.shadeShadow);
        g2d.translate(-textX, -textY);
    }
}

