/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.util;

import de.sciss.util.DynamicURLClassLoader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class URLClassLoaderManager {
    private final ClassLoader parent;
    private DynamicURLClassLoader loader;
    private Set urls = new HashSet();

    public URLClassLoaderManager() {
        this.parent = null;
        this.makeLoader();
    }

    public URLClassLoaderManager(ClassLoader classLoader) {
        this.parent = classLoader;
        this.makeLoader();
    }

    private void makeLoader() {
        Object[] objectArray = this.urls.toArray();
        URL[] uRLArray = new URL[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            uRLArray[i] = (URL)objectArray[i];
        }
        this.loader = this.parent == null ? new DynamicURLClassLoader(uRLArray) : new DynamicURLClassLoader(uRLArray, this.parent);
    }

    public void addURL(URL uRL) {
        this.loader.addURL(uRL);
        this.urls.add(uRL);
    }

    public void addURLs(URL[] uRLArray) {
        this.loader.addURLs(uRLArray);
        for (int i = 0; i < uRLArray.length; ++i) {
            this.urls.add(uRLArray[i]);
        }
    }

    public void removeURL(URL uRL) {
        if (this.urls.remove(uRL)) {
            this.makeLoader();
        }
    }

    public void removeURLs(URL[] uRLArray) {
        boolean bl = false;
        for (int i = 0; i < uRLArray.length; ++i) {
            bl |= this.urls.remove(uRLArray[i]);
        }
        if (bl) {
            this.makeLoader();
        }
    }

    public ClassLoader getCurrentLoader() {
        return this.loader;
    }
}

