/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.util;

import de.sciss.util.Param;
import de.sciss.util.ParamSpace;
import java.util.HashMap;
import java.util.Map;

public class DefaultUnitTranslator
implements ParamSpace.Translator {
    private static final double twentyByLn10 = 20.0 / Math.log(10.0);
    private final Map mapCoeffs = new HashMap();
    private static final int DIM_UNIT_MASK = 255;
    private static final int DIM_UNIT_REL_MASK = 4095;
    private static final int DIM_UNIT_REL_SCALE_MASK = 65535;

    @Override
    public Param translate(Param param, ParamSpace paramSpace) {
        int n;
        if (paramSpace == null) {
            return new Param(param.val, 0);
        }
        if (param.unit == 0) {
            return DefaultUnitTranslator.fitParam(param.val, 0, paramSpace);
        }
        int n2 = paramSpace.unit & 0xFFF;
        int n3 = param.unit & 0xFFFF;
        double d = param.val;
        d = DefaultUnitTranslator.removeScaling(d, n3);
        if ((n3 &= 0xFFFF0FFF) == n2) {
            return DefaultUnitTranslator.fitParam(d, n3, paramSpace);
        }
        Coefficient coefficient = this.getCoeff(n3, n2);
        if (coefficient != null) {
            return DefaultUnitTranslator.fitParam(d * coefficient.coeff, n2, paramSpace);
        }
        switch (n3 & 0xF00) {
            case 512: {
                if (((n3 &= 0xFFFFF0FF) & 0xF0) == 0) {
                    n = n3 | ParamSpace.DEFAULT_UNIT[n3 & 0xF];
                    coefficient = this.getCoeff(n3 | 0x100, n);
                    if (coefficient == null) {
                        return DefaultUnitTranslator.failParam(param.val, paramSpace);
                    }
                    n3 = n;
                    d = (d + 1.0) * coefficient.coeff;
                } else {
                    coefficient = this.getCoeff(n3 & 0xFFFFFF0F | 0x100, n3);
                    if (coefficient == null) {
                        return DefaultUnitTranslator.failParam(param.val, paramSpace);
                    }
                    d += coefficient.coeff;
                }
                if (n3 == n2) {
                    return DefaultUnitTranslator.fitParam(d, n3, paramSpace);
                }
                coefficient = this.getCoeff(n3, n2);
                if (coefficient == null) break;
                return DefaultUnitTranslator.fitParam(d * coefficient.coeff, n3, paramSpace);
            }
            case 256: {
                n3 &= 0xFFFFF0FF;
                n3 |= ParamSpace.DEFAULT_UNIT[n3 & 0xF];
                coefficient = this.getCoeff(n3 & 0xFFFFFF0F | 0x100, n3);
                if (coefficient == null) {
                    return DefaultUnitTranslator.failParam(param.val, paramSpace);
                }
                d *= coefficient.coeff;
                if (n3 == n2) {
                    return DefaultUnitTranslator.fitParam(d, n3, paramSpace);
                }
                coefficient = this.getCoeff(n3, n2);
                if (coefficient == null) break;
                return DefaultUnitTranslator.fitParam(d * coefficient.coeff, n3, paramSpace);
            }
        }
        if ((n3 & 0xF0) != ParamSpace.DEFAULT_UNIT[n3 & 0xF]) {
            n = n3 & 0xFFFFFF0F | ParamSpace.DEFAULT_UNIT[n3 & 0xF];
            coefficient = this.getCoeff(n3, n);
            if (coefficient == null) {
                return DefaultUnitTranslator.failParam(param.val, paramSpace);
            }
            n3 = n;
            d *= coefficient.coeff;
            if (n3 == n2) {
                return DefaultUnitTranslator.fitParam(d, n3, paramSpace);
            }
        }
        if ((n3 & 0xF) != (n2 & 0xF)) {
            n = n2 & 0xFF;
            coefficient = this.getCoeff(n3, n);
            if (coefficient == null) {
                return DefaultUnitTranslator.failParam(param.val, paramSpace);
            }
            n3 = n;
            d *= coefficient.coeff;
            if (n3 == n2) {
                return DefaultUnitTranslator.fitParam(d, n3, paramSpace);
            }
        }
        switch (n2 & 0xF00) {
            case 256: {
                coefficient = this.getCoeff(n3, n2);
                if (coefficient == null) {
                    return DefaultUnitTranslator.failParam(param.val, paramSpace);
                }
                return DefaultUnitTranslator.fitParam(d * coefficient.coeff, n3, paramSpace);
            }
            case 512: {
                coefficient = this.getCoeff(n3, n2 & 0xFFFFF00F | 0x100);
                if (coefficient == null) {
                    return DefaultUnitTranslator.failParam(param.val, paramSpace);
                }
                if ((n2 & 0xF0) == 0) {
                    return DefaultUnitTranslator.fitParam(d * coefficient.coeff - 1.0, n2, paramSpace);
                }
                return DefaultUnitTranslator.fitParam(d - 1.0 / coefficient.coeff, n2, paramSpace);
            }
        }
        return DefaultUnitTranslator.failParam(param.val, paramSpace);
    }

    public void setLengthAndRate(long l, double d) {
        this.setCoefficient(34, 50, d);
        this.setCoefficient(546, 562, d);
        this.setCoefficient(258, 34, (double)l / d);
    }

    private Coefficient getCoeff(int n, int n2) {
        return (Coefficient)this.mapCoeffs.get(new Integer(n << 16 | n2));
    }

    private static Param failParam(double d, ParamSpace paramSpace) {
        System.err.println("failed unit conversion (" + paramSpace.unit + ")");
        return new Param(paramSpace.fitValue(d), paramSpace.unit);
    }

    private static Param fitParam(double d, int n, ParamSpace paramSpace) {
        switch (paramSpace.unit & ~n & 0xF000) {
            case 4096: {
                d *= 100.0;
                break;
            }
            case 8192: {
                d = Math.log(d) * twentyByLn10;
                break;
            }
            case 12288: {
                d *= 1000.0;
                break;
            }
            case 16384: {
                d *= 100.0;
                break;
            }
            case 20480: {
                d /= 1000.0;
                break;
            }
        }
        return new Param(paramSpace.fitValue(d), paramSpace.unit);
    }

    private static double removeScaling(double d, int n) {
        switch (n & 0xF000) {
            case 4096: {
                return d / 100.0;
            }
            case 8192: {
                return Math.exp(d / twentyByLn10);
            }
            case 12288: {
                return d / 1000.0;
            }
            case 16384: {
                return d / 100.0;
            }
            case 20480: {
                return d * 1000.0;
            }
        }
        return d;
    }

    @Override
    public void setCoefficient(int n, int n2, double d) {
        this.mapCoeffs.put(new Integer(n << 16 | n2), new Coefficient(n, n2, d));
        this.mapCoeffs.put(new Integer(n2 << 16 | n), new Coefficient(n2, n, 1.0 / d));
    }

    private static class Coefficient {
        protected final double coeff;

        protected Coefficient(int n, int n2, double d) {
            this.coeff = d;
        }
    }
}

