/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.io;

import java.io.Serializable;
import java.util.Comparator;

public class Span
implements Serializable,
Cloneable {
    public static final Comparator startComparator = new StartComparator();
    public static final Comparator stopComparator = new StopComparator();
    public final long start;
    public final long stop;

    public Span() {
        this.start = 0L;
        this.stop = 0L;
    }

    public Span(long l, long l2) {
        this.start = l;
        this.stop = l2;
    }

    public Span(Span span) {
        this.start = span.start;
        this.stop = span.stop;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean contains(long l) {
        return l >= this.start && l < this.stop;
    }

    public boolean contains(Span span) {
        return span != null && span.start >= this.start && span.stop <= this.stop;
    }

    public boolean overlaps(Span span) {
        if (span == null) {
            return false;
        }
        return span.start < this.stop && span.stop > this.start;
    }

    public boolean touches(Span span) {
        if (span == null) {
            return false;
        }
        if (this.start <= span.start) {
            return this.stop >= span.start;
        }
        return span.stop >= this.start;
    }

    public boolean isEmpty() {
        return this.start == this.stop;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Span && ((Span)object).start == this.start && ((Span)object).stop == this.stop;
    }

    public int hashCode() {
        return (int)this.start ^ -((int)this.stop);
    }

    public long getStart() {
        return this.start;
    }

    public long getStop() {
        return this.stop;
    }

    public long getLength() {
        return this.stop - this.start;
    }

    public String toString() {
        return String.valueOf(this.start) + " ... " + String.valueOf(this.stop);
    }

    public static Span union(Span span, Span span2) {
        if (span == null) {
            return span2;
        }
        return span.union(span2);
    }

    public Span union(Span span) {
        if (span == null) {
            return this;
        }
        return new Span(Math.min(this.start, span.start), Math.max(this.stop, span.stop));
    }

    public static Span intersection(Span span, Span span2) {
        if (span == null) {
            return null;
        }
        return span.intersection(span2);
    }

    public Span intersection(Span span) {
        if (span == null) {
            return null;
        }
        long l = Math.max(this.start, span.start);
        long l2 = Math.min(this.stop, span.stop);
        return new Span(l, l2);
    }

    public long clip(long l) {
        if (l < this.start) {
            return this.start;
        }
        if (l > this.stop) {
            return this.stop;
        }
        return l;
    }

    public Span replaceStart(long l) {
        return new Span(l, this.stop);
    }

    public Span replaceStop(long l) {
        return new Span(this.start, l);
    }

    public Span shift(long l) {
        return new Span(this.start + l, this.stop + l);
    }

    private static class StopComparator
    implements Comparator {
        protected StopComparator() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int compare(Object object, Object object2) {
            long l;
            long l2;
            if (object instanceof Span) {
                if (object2 instanceof Span) {
                    l2 = ((Span)object).stop;
                    l = ((Span)object2).stop;
                } else {
                    if (!(object2 instanceof Number)) throw new ClassCastException();
                    l2 = ((Span)object).stop;
                    l = ((Number)object2).longValue();
                }
            } else {
                if (!(object instanceof Number)) throw new ClassCastException();
                if (object2 instanceof Span) {
                    l2 = ((Number)object).longValue();
                    l = ((Span)object2).stop;
                } else {
                    if (!(object2 instanceof Number)) throw new ClassCastException();
                    l2 = ((Number)object).longValue();
                    l = ((Number)object2).longValue();
                }
            }
            if (l2 < l) {
                return -1;
            }
            if (l2 <= l) return 0;
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object instanceof StopComparator;
        }
    }

    private static class StartComparator
    implements Comparator {
        protected StartComparator() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int compare(Object object, Object object2) {
            long l;
            long l2;
            if (object instanceof Span) {
                if (object2 instanceof Span) {
                    l2 = ((Span)object).start;
                    l = ((Span)object2).start;
                } else {
                    if (!(object2 instanceof Number)) throw new ClassCastException();
                    l2 = ((Span)object).start;
                    l = ((Number)object2).longValue();
                }
            } else {
                if (!(object instanceof Number)) throw new ClassCastException();
                if (object2 instanceof Span) {
                    l2 = ((Number)object).longValue();
                    l = ((Span)object2).start;
                } else {
                    if (!(object2 instanceof Number)) throw new ClassCastException();
                    l2 = ((Number)object).longValue();
                    l = ((Number)object2).longValue();
                }
            }
            if (l2 < l) {
                return -1;
            }
            if (l2 <= l) return 0;
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object instanceof StartComparator;
        }
    }
}

