/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.io;

import de.sciss.io.AudioFile;
import de.sciss.io.Region;
import de.sciss.io.Span;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class AudioFileRegion
implements Serializable,
Cloneable,
Transferable {
    public final File file;
    public final Region region;
    public static DataFlavor flavor = new DataFlavor(AudioFileRegion.class, "Audio File Region");
    private static final DataFlavor[] supportedFlavors = new DataFlavor[]{DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor, flavor};

    public AudioFileRegion(File file, Region region) {
        this.file = file;
        this.region = region;
    }

    public AudioFileRegion(AudioFile audioFile, Region region) {
        this.file = audioFile.getFile();
        this.region = region;
    }

    public AudioFileRegion(File file, Span span) {
        this.file = file;
        this.region = new Region(span, file.getName());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return supportedFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < supportedFlavors.length; ++i) {
            if (!supportedFlavors[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(flavor)) {
            return this;
        }
        if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
            ArrayList<File> arrayList = new ArrayList<File>(1);
            arrayList.add(this.file);
            return arrayList;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return this.region.name;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

