/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.io;

import de.sciss.gui.StringItem;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AudioFileDescr {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_AIFF = 0;
    public static final int TYPE_SND = 1;
    public static final int TYPE_IRCAM = 2;
    public static final int TYPE_WAVE = 3;
    public static final int TYPE_RAW = 4;
    public static final int TYPE_WAVE64 = 5;
    private static final int NUM_TYPES = 6;
    public static final int FORMAT_INT = 0;
    public static final int FORMAT_FLOAT = 1;
    public File file;
    public int type;
    public int channels;
    public double rate;
    public int bitsPerSample;
    public int sampleFormat;
    public long length;
    public String appCode;
    public static final String KEY_LOOP = "loop";
    public static final String KEY_MARKERS = "markers";
    public static final String KEY_REGIONS = "regions";
    public static final String KEY_GAIN = "gain";
    public static final String KEY_APPCODE = "app";
    public static final String KEY_COMMENT = "comment";
    private final Map properties;
    private static final Set[] supports;
    private List pcs = null;
    private static final StringItem[] FORMAT_ITEMS;
    private static final String[] FORMAT_SUFFICES;
    private static final String msgPtrn = "{0,choice,0#AIFF|1#NeXT/Sun AU|2#IRCAM|3#WAVE|4#Raw|5#Wave64} audio, {1,choice,0#no channels|1#mono|2#stereo|2<{1,number,integer}-ch} {2,number,integer}-bit {3,choice,0#int|1#float} {4,number,0.###} kHz, {5,number,integer}:{6,number,00.000}";
    private static final MessageFormat msgForm;

    public AudioFileDescr() {
        this.properties = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileDescr(AudioFileDescr audioFileDescr) {
        this.file = audioFileDescr.file;
        this.type = audioFileDescr.type;
        this.channels = audioFileDescr.channels;
        this.rate = audioFileDescr.rate;
        this.bitsPerSample = audioFileDescr.bitsPerSample;
        this.sampleFormat = audioFileDescr.sampleFormat;
        this.length = audioFileDescr.length;
        this.appCode = audioFileDescr.appCode;
        Map map = audioFileDescr.properties;
        synchronized (map) {
            this.properties = new HashMap(audioFileDescr.properties);
        }
    }

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(Object object) {
        Map map = this.properties;
        synchronized (map) {
            return this.properties.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String string, Object object) {
        Map map = this.properties;
        synchronized (map) {
            this.properties.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(Object object, String string, Object object2) {
        Map map = this.properties;
        synchronized (map) {
            Object object3 = this.properties.put(string, object2);
            if (object != null && this.pcs != null) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(object, string, object3, object2);
                for (int i = 0; i < this.pcs.size(); ++i) {
                    ((PropertyChangeListener)this.pcs.get(i)).propertyChange(propertyChangeEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Map map = this.properties;
        synchronized (map) {
            if (this.pcs == null) {
                this.pcs = new ArrayList();
            }
            this.pcs.add(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Map map = this.properties;
        synchronized (map) {
            if (this.pcs == null) {
                this.pcs.remove(propertyChangeListener);
            }
        }
    }

    public boolean isPropertySupported(String string) {
        if (this.type >= 0 && this.type < supports.length) {
            return supports[this.type].contains(string);
        }
        return false;
    }

    public String getFormat() {
        Object[] objectArray = new Object[7];
        objectArray[0] = new Integer(this.type);
        objectArray[1] = new Integer(this.channels);
        objectArray[2] = new Integer(this.bitsPerSample);
        objectArray[3] = new Integer(this.sampleFormat);
        objectArray[4] = new Float((float)(this.rate / 1000.0));
        int n = (int)(AudioFileDescr.samplesToMillis(this, this.length) + 0.5);
        objectArray[5] = new Integer(n / 60000);
        objectArray[6] = new Double((double)(n % 60000) / 1000.0);
        return msgForm.format(objectArray);
    }

    public static StringItem[] getFormatItems() {
        return FORMAT_ITEMS;
    }

    public static String getFormatSuffix(int n) {
        if (n >= 0 && n < FORMAT_SUFFICES.length) {
            return FORMAT_SUFFICES[n];
        }
        return null;
    }

    public static double millisToSamples(AudioFileDescr audioFileDescr, double d) {
        return d / 1000.0 * audioFileDescr.rate;
    }

    public static double samplesToMillis(AudioFileDescr audioFileDescr, long l) {
        return (double)l / audioFileDescr.rate * 1000.0;
    }

    static {
        FORMAT_ITEMS = new StringItem[]{new StringItem("aiff", "AIFF"), new StringItem("au", "NeXT/Sun AU"), new StringItem("ircam", "IRCAM"), new StringItem("wave", "WAVE"), new StringItem("raw", "Raw"), new StringItem("w64", "Wave64")};
        FORMAT_SUFFICES = new String[]{"aif", "au", "irc", "wav", "raw", "w64"};
        msgForm = new MessageFormat(msgPtrn, Locale.US);
        supports = new Set[6];
        HashSet<String> hashSet = new HashSet<String>(5);
        hashSet.add(KEY_LOOP);
        hashSet.add(KEY_MARKERS);
        hashSet.add(KEY_GAIN);
        hashSet.add(KEY_APPCODE);
        hashSet.add(KEY_COMMENT);
        AudioFileDescr.supports[0] = hashSet;
        hashSet = new HashSet(1);
        hashSet.add(KEY_COMMENT);
        AudioFileDescr.supports[1] = hashSet;
        hashSet = new HashSet(2);
        hashSet.add(KEY_REGIONS);
        hashSet.add(KEY_COMMENT);
        AudioFileDescr.supports[2] = hashSet;
        hashSet = new HashSet(2);
        hashSet.add(KEY_MARKERS);
        hashSet.add(KEY_GAIN);
        AudioFileDescr.supports[3] = hashSet;
        AudioFileDescr.supports[4] = hashSet = new HashSet(1);
        hashSet = new HashSet(1);
        hashSet.add(KEY_MARKERS);
        AudioFileDescr.supports[5] = hashSet;
    }
}

