/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

public class UnitLabel
extends JLabel
implements Icon,
PropertyChangeListener {
    private static final int[] polyX = new int[]{0, 4, 8};
    private static final int[] polyY = new int[]{0, 4, 0};
    protected final JPopupMenu pop = new JPopupMenu();
    private final ButtonGroup bg = new ButtonGroup();
    protected final List units = new ArrayList();
    private ActionListener al = null;
    protected int selectedIdx = -1;
    protected boolean cycle = false;
    private final Color colrLabD;
    private final Color colrTri;
    private final Color colrTriD;

    public UnitLabel() {
        this.setHorizontalTextPosition(2);
        Color color = this.getForeground();
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        this.colrLabD = new Color(n, n2, n3, 127);
        this.colrTri = new Color(n, n2, n3, 176);
        this.colrTriD = new Color(n, n2, n3, 85);
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (UnitLabel.this.isEnabled() && UnitLabel.this.units.size() > 1) {
                    UnitLabel.this.requestFocus();
                    if (UnitLabel.this.cycle) {
                        ((UnitAction)UnitLabel.this.units.get((UnitLabel.this.selectedIdx + 1) % UnitLabel.this.units.size())).setLabel();
                        ((JCheckBoxMenuItem)UnitLabel.this.pop.getComponent(UnitLabel.this.selectedIdx)).setSelected(true);
                    } else {
                        UnitLabel.this.pop.show(UnitLabel.this, 0, UnitLabel.this.getHeight());
                    }
                }
            }
        });
        this.addPropertyChangeListener("font", this);
        this.addPropertyChangeListener("enabled", this);
        this.addPropertyChangeListener("insets", this);
    }

    public int getSelectedIndex() {
        return this.selectedIdx;
    }

    public Action getUnit(int n) {
        return (Action)this.units.get(n);
    }

    public Action getSelectedUnit() {
        return this.selectedIdx < 0 || this.selectedIdx >= this.units.size() ? null : (Action)this.units.get(this.selectedIdx);
    }

    public void setSelectedIndex(int n) {
        this.selectedIdx = n;
        if (n >= 0 && n < this.units.size()) {
            ((UnitAction)this.units.get(n)).setLabel();
            ((JCheckBoxMenuItem)this.pop.getComponent(n)).setSelected(true);
        }
    }

    public void addUnit(String string) {
        this.addUnit(new UnitAction(string));
    }

    public void addUnit(Icon icon) {
        this.addUnit(new UnitAction(icon));
    }

    public void addUnit(String string, Icon icon) {
        this.addUnit(new UnitAction(string, icon));
    }

    public void setCycling(boolean bl) {
        if (bl != this.cycle) {
            this.cycle = bl;
            this.repaint();
        }
    }

    public boolean getCycling() {
        return this.cycle;
    }

    private void addUnit(UnitAction unitAction) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(unitAction);
        this.bg.add(jCheckBoxMenuItem);
        this.pop.add(jCheckBoxMenuItem);
        this.units.add(unitAction);
        if (this.units.size() == 1) {
            unitAction.setLabel();
            jCheckBoxMenuItem.setSelected(true);
        }
        this.updatePreferredSize();
    }

    private void updatePreferredSize() {
        Dimension dimension;
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = 4;
        int n2 = 4;
        Insets insets = this.getInsets();
        for (int i = 0; i < this.units.size(); ++i) {
            UnitAction unitAction = (UnitAction)this.units.get(i);
            dimension = unitAction.getPreferredSize(fontMetrics);
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        dimension = new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("font")) {
            Font font = this.getFont();
            MenuElement[] menuElementArray = this.pop.getSubElements();
            for (int i = 0; i < menuElementArray.length; ++i) {
                menuElementArray[i].getComponent().setFont(font);
            }
            this.updatePreferredSize();
        } else if (propertyChangeEvent.getPropertyName().equals("enabled")) {
            this.setForeground(this.isEnabled() ? null : this.colrLabD);
        } else if (propertyChangeEvent.getPropertyName().equals("insets")) {
            this.updatePreferredSize();
        }
    }

    protected void fireUnitChanged() {
        ActionListener actionListener = this.al;
        if (actionListener != null) {
            actionListener.actionPerformed(new ActionEvent(this, 1001, this.getText()));
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.al = AWTEventMulticaster.add(this.al, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.al = AWTEventMulticaster.remove(this.al, actionListener);
    }

    @Override
    public int getIconWidth() {
        return this.units.size() > 1 ? 9 : 0;
    }

    @Override
    public int getIconHeight() {
        return this.units.size() > 1 ? 5 : 0;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.units.size() < 2) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(n, n2);
        if (this.cycle) {
            graphics2D.rotate(Math.PI, 4.0, 2.0);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.isEnabled() ? this.colrTri : this.colrTriD);
        graphics2D.fillPolygon(polyX, polyY, 3);
        graphics2D.setTransform(affineTransform);
    }

    private static class CompoundIcon
    implements Icon {
        private final Icon iconWest;
        private final Icon iconEast;
        private final int gap;

        protected CompoundIcon(Icon icon, Icon icon2, int n) {
            this.iconWest = icon;
            this.iconEast = icon2;
            this.gap = n;
        }

        @Override
        public int getIconWidth() {
            return (this.iconWest == null ? 0 : this.iconWest.getIconWidth() + this.gap) + (this.iconEast == null ? 0 : this.iconEast.getIconWidth());
        }

        @Override
        public int getIconHeight() {
            return Math.max(this.iconWest == null ? 0 : this.iconWest.getIconHeight(), this.iconEast == null ? 0 : this.iconEast.getIconHeight());
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.iconWest != null) {
                this.iconWest.paintIcon(component, graphics, n, this.iconWest.getIconHeight() - this.getIconHeight() >> 1);
            }
            if (this.iconEast != null) {
                this.iconEast.paintIcon(component, graphics, n + (this.iconWest == null ? 0 : this.iconWest.getIconWidth() + this.gap), n2 + this.getIconHeight() - this.iconEast.getIconHeight());
            }
        }
    }

    private class UnitAction
    extends AbstractAction {
        private final String name;
        private final Icon icon;

        protected UnitAction(String string) {
            super(string);
            this.name = string;
            this.icon = new CompoundIcon(null, UnitLabel.this, UnitLabel.this.getIconTextGap());
        }

        protected UnitAction(Icon icon) {
            this.putValue("SmallIcon", icon);
            this.name = null;
            this.icon = new CompoundIcon(icon, UnitLabel.this, UnitLabel.this.getIconTextGap());
        }

        protected UnitAction(String string, Icon icon) {
            super(string, icon);
            this.name = string;
            this.icon = new CompoundIcon(icon, UnitLabel.this, UnitLabel.this.getIconTextGap());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setLabel();
        }

        protected void setLabel() {
            UnitLabel.this.setText(this.name);
            UnitLabel.this.setIcon(this.icon);
            int n = UnitLabel.this.units.indexOf(this);
            if (n != UnitLabel.this.selectedIdx) {
                UnitLabel.this.selectedIdx = n;
                UnitLabel.this.fireUnitChanged();
            }
        }

        protected Dimension getPreferredSize(FontMetrics fontMetrics) {
            int n;
            int n2;
            if (this.name != null) {
                n2 = fontMetrics.stringWidth(this.name) + UnitLabel.this.getIconTextGap();
                n = fontMetrics.getHeight();
            } else {
                n2 = 0;
                n = 0;
            }
            return new Dimension(n2 + this.icon.getIconWidth(), Math.max(n, this.icon.getIconHeight()));
        }
    }
}

