/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;

public class TiledImage {
    private final Image img;
    private final int tileWidth;
    private final int tileHeight;

    public TiledImage(String string, int n, int n2) {
        this(Toolkit.getDefaultToolkit().getImage(string), n, n2);
    }

    public TiledImage(URL uRL, int n, int n2) {
        this(Toolkit.getDefaultToolkit().getImage(uRL), n, n2);
    }

    public TiledImage(Image image, int n, int n2) {
        this.img = image;
        this.tileWidth = n;
        this.tileHeight = n2;
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public boolean paintTile(Graphics graphics, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        int n5 = n3 * this.tileWidth;
        int n6 = n4 * this.tileHeight;
        return graphics.drawImage(this.img, n, n2, n + this.tileWidth, n2 + this.tileHeight, n5, n6, n5 + this.tileWidth, n6 + this.tileHeight, imageObserver);
    }

    public Icon createIcon(int n, int n2) {
        return new Icon(n, n2);
    }

    private class Icon
    implements javax.swing.Icon {
        private final int col;
        private final int row;

        protected Icon(int n, int n2) {
            this.col = n;
            this.row = n2;
        }

        @Override
        public int getIconWidth() {
            return TiledImage.this.getTileWidth();
        }

        @Override
        public int getIconHeight() {
            return TiledImage.this.getTileHeight();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            TiledImage.this.paintTile(graphics, n, n2, this.col, this.row, component);
        }
    }
}

