/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.gui.PeakMeter;
import de.sciss.gui.PeakMeterCaption;
import de.sciss.gui.PeakMeterView;
import de.sciss.gui.RecessedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

public class PeakMeterPanel
extends JPanel
implements PeakMeterView,
SwingConstants {
    protected PeakMeter[] meters = new PeakMeter[0];
    protected PeakMeterCaption caption;
    private int captionPosition = 2;
    private int captionAlign = 4;
    private boolean captionVisible = true;
    private boolean captionLabels = true;
    private int numChannels = 0;
    private boolean border = false;
    private boolean rmsPainted = true;
    private boolean holdPainted = true;
    private int orient = 1;
    private boolean vertical = true;

    public PeakMeterPanel() {
        this.setLayout(new BoxLayout(this, 0));
        this.setFont(new Font("SansSerif", 0, 12));
        this.addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PeakMeterPanel.this.caption != null) {
                    PeakMeterPanel.this.caption.setFont(PeakMeterPanel.this.getFont());
                    Border border = BorderFactory.createEmptyBorder(PeakMeterPanel.this.caption.getAscent(), 1, PeakMeterPanel.this.caption.getDescent(), 1);
                    for (int i = 0; i < PeakMeterPanel.this.meters.length; ++i) {
                        PeakMeterPanel.this.meters[i].setBorder(border);
                    }
                }
            }
        });
    }

    public void setOrientation(int n) {
        if (n != this.orient) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            this.orient = n;
            boolean bl = this.vertical = this.orient == 1;
            if (this.caption != null) {
                this.caption.setOrientation(this.orient);
            }
            for (int i = 0; i < this.meters.length; ++i) {
                this.meters[i].setOrientation(this.orient);
            }
            this.setLayout(new BoxLayout(this, this.vertical ? 0 : 1));
            this.updateBorders();
            this.revalidate();
        }
    }

    public void setRMSPainted(boolean bl) {
        if (this.rmsPainted == bl) {
            return;
        }
        this.rmsPainted = bl;
        for (int i = 0; i < this.meters.length; ++i) {
            this.meters[i].setRMSPainted(bl);
        }
    }

    public void setHoldPainted(boolean bl) {
        if (this.holdPainted == bl) {
            return;
        }
        this.holdPainted = bl;
        for (int i = 0; i < this.meters.length; ++i) {
            this.meters[i].setHoldPainted(bl);
        }
    }

    @Override
    public boolean meterUpdate(float[] fArray, int n, long l) {
        PeakMeter[] peakMeterArray = this.meters;
        int n2 = Math.min(peakMeterArray.length, fArray.length >> 1);
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!peakMeterArray[i].setPeakAndRMS(fArray[n4++], fArray[n4++], l)) continue;
            ++n3;
        }
        return n3 > 0;
    }

    @Override
    public void clearMeter() {
        for (int i = 0; i < this.meters.length; ++i) {
            this.meters[i].clearMeter();
        }
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.meters.length; ++i) {
            this.meters[i].dispose();
        }
    }

    public void setBorder(boolean bl) {
        if (this.border == bl) {
            return;
        }
        this.border = bl;
        this.setBorder(bl ? new RecessedBorder() : null);
        this.updateBorders();
    }

    public void setCaption(boolean bl) {
        if (bl == (this.caption != null)) {
            return;
        }
        if (bl) {
            this.caption = new PeakMeterCaption(this.orient);
            this.caption.setFont(this.getFont());
            this.caption.setVisible(this.captionVisible);
            this.caption.setHorizontalAlignment(this.captionAlign);
            this.caption.setPaintLabels(this.captionLabels);
        } else {
            this.caption = null;
        }
        this.rebuildMeters();
    }

    public void setCaptionPosition(int n) {
        if (this.captionPosition == n) {
            return;
        }
        switch (n) {
            case 2: {
                this.captionAlign = 4;
                break;
            }
            case 4: {
                this.captionAlign = 2;
                break;
            }
            case 0: {
                this.captionAlign = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.captionPosition = n;
        if (this.caption != null) {
            this.caption.setHorizontalAlignment(this.captionAlign);
            this.rebuildMeters();
        }
    }

    public void setCaptionLabels(boolean bl) {
        if (this.captionLabels == bl) {
            return;
        }
        this.captionLabels = bl;
        if (this.caption != null) {
            this.caption.setPaintLabels(this.captionLabels);
        }
    }

    public void setCaptionVisible(boolean bl) {
        if (this.captionVisible == bl) {
            return;
        }
        this.captionVisible = bl;
        if (this.caption != null) {
            this.caption.setVisible(this.captionVisible);
            this.updateBorders();
        }
    }

    public void setNumChannels(int n) {
        if (n != this.numChannels) {
            this.numChannels = n;
            this.rebuildMeters();
        }
    }

    @Override
    public int getNumChannels() {
        return this.numChannels;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        graphics.setColor(Color.black);
        graphics.fillRect(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
    }

    private void rebuildMeters() {
        Border border;
        this.removeAll();
        Border border2 = border = this.caption == null ? null : BorderFactory.createEmptyBorder(this.caption.getAscent(), 1, this.caption.getDescent(), 1);
        Border border3 = this.caption == null ? BorderFactory.createEmptyBorder(1, 1, this.vertical ? 1 : 0, this.vertical ? 0 : 1) : BorderFactory.createEmptyBorder(this.caption.getAscent(), 1, this.caption.getDescent(), 0);
        int n = !this.border || this.captionVisible && this.captionPosition == 4 ? this.numChannels - 1 : -1;
        int n2 = this.captionVisible && this.captionPosition == 0 ? this.numChannels >> 1 : -1;
        PeakMeter[] peakMeterArray = new PeakMeter[this.numChannels];
        for (int i = 0; i < this.numChannels; ++i) {
            peakMeterArray[i] = new PeakMeter(this.orient);
            peakMeterArray[i].setRefreshParent(true);
            peakMeterArray[i].setRMSPainted(this.rmsPainted);
            peakMeterArray[i].setHoldPainted(this.holdPainted);
            if (i == n || i == n2) {
                if (border != null) {
                    peakMeterArray[i].setBorder(border);
                }
            } else {
                peakMeterArray[i].setBorder(border3);
            }
            peakMeterArray[i].setTicks(101);
            this.add(peakMeterArray[i]);
        }
        if (this.caption != null) {
            switch (this.captionPosition) {
                case 2: {
                    this.add((Component)this.caption, 0);
                    break;
                }
                case 4: {
                    this.add(this.caption);
                    break;
                }
                case 0: {
                    this.add((Component)this.caption, this.getComponentCount() >> 1);
                    break;
                }
                default: {
                    assert (false) : this.captionPosition;
                    break;
                }
            }
        }
        this.meters = peakMeterArray;
        this.revalidate();
        this.repaint();
    }

    private void updateBorders() {
        Border border;
        Border border2 = border = this.caption == null ? BorderFactory.createEmptyBorder(1, 1, 1, 1) : BorderFactory.createEmptyBorder(this.caption.getAscent(), 1, this.caption.getDescent(), 1);
        Border border3 = this.caption == null ? BorderFactory.createEmptyBorder(1, 1, this.vertical ? 1 : 0, this.vertical ? 0 : 1) : BorderFactory.createEmptyBorder(this.caption.getAscent(), 1, this.caption.getDescent(), 0);
        int n = !this.border || this.captionVisible && this.captionPosition == 4 ? this.numChannels - 1 : -1;
        int n2 = this.captionVisible && this.captionPosition == 0 ? this.numChannels >> 1 : -1;
        for (int i = 0; i < this.numChannels; ++i) {
            if (i == n || i == n2) {
                this.meters[i].setBorder(border);
            } else {
                this.meters[i].setBorder(border3);
            }
            this.meters[i].setTicks(101);
        }
    }
}

