/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.gui.PeakMeterView;
import de.sciss.util.Disposable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class PeakMeter
extends JComponent
implements PeakMeterView,
Disposable,
SwingConstants {
    public static final int DEFAULT_HOLD_DUR = 2500;
    private int holdDuration = 2500;
    private float peak;
    private float rms;
    private float hold;
    private float peakToPaint;
    private float rmsToPaint;
    private float holdToPaint;
    private float peakNorm;
    private float rmsNorm;
    private float holdNorm;
    private int recentLength = 0;
    private int recentBreadth = 0;
    private int calcedLength = -1;
    private int calcedBreadth = -1;
    private long lastUpdate = System.currentTimeMillis();
    private long holdEnd;
    private boolean holdPainted = true;
    private boolean rmsPainted = true;
    private static final boolean isMac = System.getProperty("os.name").contains("Mac OS");
    private static final boolean isWindows = System.getProperty("os.name").contains("Windows");
    private static final boolean isLinux = !isMac && !isWindows;
    public static final boolean animationNeedsSync = isLinux && System.getProperty("java.version").startsWith("1.8.");
    private static final int[] bgPixels = new int[]{-16777216, -13355980, -12040120, -10724260, -10724260, -10724260, -10724260, -10724260, -12040120, -13355980, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216};
    private static final int[] rmsTopColor = new int[]{104, 5584825, 7753445, 9462504, 9135080, 8610024, 8151272, 8943339, 5852340, 4209251};
    private static final int[] rmsBotColor = new int[]{104, 3099574, 4417506, 5734373, 5733093, 5797094, 5861350, 7043818, 4739505, 3751266};
    private static final int[] peakTopColor = new int[]{0, 12003625, 0xFF3C3C, 0xFF6B6B, 0xFF6B6B, 0xFF6B6B, 0xFF6B6B, 0xFFA7A7, 0xFF3C3C, 12003625};
    private static final int[] peakBotColor = new int[]{0, 36352, 51200, 196354, 196354, 196354, 196354, 0x68FF68, 51200, 36352};
    private Paint pntBg;
    private BufferedImage imgBg;
    private BufferedImage imgRMS;
    private BufferedImage imgPeak;
    private static final double logPeakCorr = 20.0 / Math.log(10.0);
    private static final double logRMSCorr = 10.0 / Math.log(10.0);
    private Insets insets;
    private int holdPixPos;
    private int peakPixPos;
    private int rmsPixPos;
    private int peakPixPosP = 0;
    private int rmsPixPosP = 0;
    private int holdPixPosP = 0;
    private boolean refreshParent = false;
    private int ticks = 0;
    private boolean vertical;

    private static void sync() {
        if (animationNeedsSync) {
            Toolkit.getDefaultToolkit().sync();
        }
    }

    public PeakMeter() {
        this(1);
    }

    public PeakMeter(int n) {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.vertical = n == 1;
        this.recalcPrefSize();
        this.addPropertyChangeListener("border", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PeakMeter.this.recalcPrefSize();
            }
        });
        this.clearMeter();
    }

    public void setOrientation(int n) {
        boolean bl;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        boolean bl2 = bl = n == 1;
        if (bl != this.vertical) {
            this.vertical = bl;
            this.disposeImages();
            this.recalcPrefSize();
            this.clearMeter();
        }
    }

    @Override
    public int getNumChannels() {
        return 1;
    }

    @Override
    public boolean meterUpdate(float[] fArray, int n, long l) {
        int n2 = n + 1;
        if (n2 >= fArray.length) {
            return false;
        }
        boolean bl = this.setPeakAndRMS(fArray[n], fArray[n2], l);
        PeakMeter.sync();
        return bl;
    }

    public void setHoldPainted(boolean bl) {
        if (this.holdPainted != bl) {
            this.holdPainted = bl;
            this.repaint();
        }
    }

    public void setRMSPainted(boolean bl) {
        if (this.rmsPainted != bl) {
            this.rmsPainted = bl;
            this.repaint();
        }
    }

    @Override
    public void clearMeter() {
        int n = this.getWidth() - (this.insets.left + this.insets.right);
        int n2 = this.getHeight() - (this.insets.top + this.insets.bottom);
        int n3 = this.vertical ? n2 : n;
        int n4 = n3 - 1 & 0xFFFFFFFE;
        this.peak = -160.0f;
        this.rms = -160.0f;
        this.hold = -160.0f;
        this.peakToPaint = -160.0f;
        this.rmsToPaint = -160.0f;
        this.holdToPaint = -160.0f;
        this.peakNorm = -1.0f;
        this.rmsNorm = -1.0f;
        this.holdNorm = -1.0f;
        this.holdEnd = System.currentTimeMillis();
        this.holdPixPos = (int)(this.holdNorm * (float)n4) & 0xFFFFFFFE;
        this.peakPixPos = (int)(this.peakNorm * (float)n4) & 0xFFFFFFFE;
        this.rmsPixPos = Math.min((int)(this.rmsNorm * (float)n4) & 0xFFFFFFFE, this.peakPixPos - 4);
        if (this.refreshParent) {
            this.getParent().repaint(this.insets.left + this.getX(), this.insets.top + this.getY(), n, n2);
        } else {
            this.repaint(this.insets.left, this.insets.top, n, n2);
        }
    }

    public void setTicks(int n) {
        this.ticks = n;
        this.recalcPrefSize();
    }

    public void setRefreshParent(boolean bl) {
        this.refreshParent = bl;
    }

    public void setHoldDuration(int n) {
        this.holdDuration = n == -1 ? Integer.MAX_VALUE : n;
        this.holdEnd = System.currentTimeMillis();
    }

    public void clearHold() {
        this.hold = -160.0f;
        this.holdNorm = 0.0f;
    }

    protected void recalcPrefSize() {
        Dimension dimension;
        Dimension dimension2;
        this.insets = this.getInsets();
        if (this.vertical) {
            int n = 10 + this.insets.left + this.insets.right;
            dimension2 = new Dimension(4, 2 + this.insets.top + this.insets.bottom);
            dimension = new Dimension(n, this.ticks <= 0 ? this.getPreferredSize().height : this.ticks * 2 - 1 + this.insets.top + this.insets.bottom);
        } else {
            int n = 10 + this.insets.top + this.insets.bottom;
            dimension2 = new Dimension(2 + this.insets.left + this.insets.right, 4);
            dimension = new Dimension(this.ticks <= 0 ? this.getPreferredSize().width : this.ticks * 2 - 1 + this.insets.left + this.insets.right, n);
        }
        this.setMinimumSize(dimension2);
        this.setPreferredSize(dimension);
    }

    public float getPeakDecibels() {
        return this.peak <= -160.0f ? Float.NEGATIVE_INFINITY : this.peak;
    }

    public float getHoldDecibels() {
        return this.hold <= -160.0f ? Float.NEGATIVE_INFINITY : this.hold;
    }

    public boolean setPeakAndRMS(float f, float f2) {
        return this.setPeakAndRMS(f, f2, System.currentTimeMillis());
    }

    private float paintToNorm(float f) {
        if (f >= -30.0f) {
            if (f >= -20.0f) {
                return Math.min(1.0f, f * 0.025f + 1.0f);
            }
            return f * 0.02f + 0.9f;
        }
        if (f >= -50.0f) {
            if (f >= -40.0f) {
                return f * 0.015f + 0.75f;
            }
            return f * 0.01f + 0.55f;
        }
        if (f >= -60.0f) {
            return f * 0.005f + 0.3f;
        }
        return -1.0f;
    }

    public boolean setPeakAndRMS(float f, float f2, long l) {
        boolean bl;
        boolean bl2;
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalMonitorStateException();
        }
        this.peak = (f = (float)(Math.log(f) * logPeakCorr)) >= this.peak ? f : Math.max(f, this.peak - (float)(l - this.lastUpdate) * (this.peak > -20.0f ? 0.013333334f : 0.016f));
        this.peakToPaint = Math.max(this.peakToPaint, this.peak);
        this.peakNorm = this.paintToNorm(this.peakToPaint);
        if (this.rmsPainted) {
            this.rms = (f2 = (float)(Math.log(f2) * logRMSCorr)) > this.rms ? f2 : Math.max(f2, this.rms - (float)(l - this.lastUpdate) * (this.rms > -20.0f ? 0.013333334f : 0.016f));
            this.rmsToPaint = Math.max(this.rmsToPaint, this.rms);
            this.rmsNorm = this.paintToNorm(this.rmsToPaint);
        }
        if (this.holdPainted) {
            if (this.peak >= this.hold) {
                this.hold = this.peak;
                this.holdEnd = l + (long)this.holdDuration;
            } else if (l > this.holdEnd) {
                this.hold = this.peak > this.hold ? this.peak : (this.hold += (this.hold > -20.0f ? 0.013333334f : 0.016f) * (float)(this.lastUpdate - l));
            }
            this.holdToPaint = Math.max(this.holdToPaint, this.hold);
            this.holdNorm = this.paintToNorm(this.holdToPaint);
            bl2 = this.holdNorm >= 0.0f;
        } else {
            bl2 = this.peakNorm >= 0.0f;
        }
        this.lastUpdate = l;
        int n = this.getWidth() - this.insets.left - this.insets.right;
        int n2 = this.getHeight() - this.insets.top - this.insets.bottom;
        int n3 = this.vertical ? n2 : n;
        int n4 = n3 - 1 & 0xFFFFFFFE;
        this.recentLength = n4 + 1;
        this.holdPixPos = (int)(this.holdNorm * (float)n4) & 0xFFFFFFFE;
        this.peakPixPos = (int)(this.peakNorm * (float)n4) & 0xFFFFFFFE;
        this.rmsPixPos = Math.min((int)(this.rmsNorm * (float)n4) & 0xFFFFFFFE, this.peakPixPos - 4);
        boolean bl3 = this.peakPixPos != this.peakPixPosP;
        boolean bl4 = this.rmsPixPos != this.rmsPixPosP;
        boolean bl5 = bl = this.holdPixPos != this.holdPixPosP;
        if (bl3 || bl4 || bl) {
            int n5;
            int n6;
            Container container;
            int n7;
            int n8;
            if (this.peakPixPos < this.peakPixPosP) {
                n8 = this.peakPixPos;
                n7 = this.peakPixPosP;
            } else {
                n8 = this.peakPixPosP;
                n7 = this.peakPixPos;
            }
            if (this.holdPainted) {
                if (this.holdPixPos < this.holdPixPosP) {
                    if (this.holdPixPos < n8) {
                        n8 = this.holdPixPos;
                    }
                    if (this.holdPixPosP > n7) {
                        n7 = this.holdPixPosP;
                    }
                } else {
                    if (this.holdPixPosP < n8) {
                        n8 = this.holdPixPosP;
                    }
                    if (this.holdPixPos > n7) {
                        n7 = this.holdPixPos;
                    }
                }
            }
            if (this.rmsPainted) {
                if (this.rmsPixPos < this.rmsPixPosP) {
                    if (this.rmsPixPos < n8) {
                        n8 = this.rmsPixPos;
                    }
                    if (this.rmsPixPosP > n7) {
                        n7 = this.rmsPixPosP;
                    }
                } else {
                    if (this.rmsPixPosP < n8) {
                        n8 = this.rmsPixPosP;
                    }
                    if (this.rmsPixPos > n7) {
                        n7 = this.rmsPixPos;
                    }
                }
            }
            if (this.refreshParent) {
                container = this.getParent();
                n6 = this.insets.left + this.getX();
                n5 = this.insets.top + this.getY();
            } else {
                container = this;
                n6 = this.insets.left;
                n5 = this.insets.top;
            }
            if (this.vertical) {
                container.repaint(n6, n5 + n4 - n7, n, n7 - n8 + 2);
            } else {
                container.repaint(n6 + n8, n5, n7 - n8 + 2, n2);
            }
        } else {
            this.peakToPaint = -160.0f;
            this.rmsToPaint = -160.0f;
            this.holdToPaint = -160.0f;
        }
        return bl2;
    }

    public boolean setPeak(float f) {
        return this.setPeakAndRMS(f, this.rms);
    }

    private void recalcPaint() {
        int n;
        int n2;
        int[] nArray;
        int n3 = this.recentLength + 1 & 0xFFFFFFFE;
        int n4 = this.recentBreadth;
        if (this.imgPeak != null) {
            this.imgPeak.flush();
            this.imgPeak = null;
        }
        if (this.imgRMS != null) {
            this.imgRMS.flush();
            this.imgRMS = null;
        }
        if (this.vertical) {
            if (this.imgBg == null || this.imgBg.getWidth() != n4) {
                if (this.imgBg != null) {
                    this.imgBg.flush();
                    this.imgBg = null;
                }
                nArray = n4 == 10 ? bgPixels : PeakMeter.widenPixV(bgPixels, 10, n4, 2);
                this.imgBg = new BufferedImage(n4, 2, 2);
                this.imgBg.setRGB(0, 0, n4, 2, nArray, 0, n4);
                this.pntBg = new TexturePaint(this.imgBg, new Rectangle(0, 0, n4, 2));
            }
            n2 = n4;
            n = n3;
        } else {
            if (this.imgBg == null || this.imgBg.getHeight() != n4) {
                if (this.imgBg != null) {
                    this.imgBg.flush();
                    this.imgBg = null;
                }
                nArray = PeakMeter.widenPixH(bgPixels, 10, n4, 2);
                this.imgBg = new BufferedImage(2, n4, 2);
                this.imgBg.setRGB(0, 0, 2, n4, nArray, 0, 2);
                this.pntBg = new TexturePaint(this.imgBg, new Rectangle(0, 0, 2, n4));
            }
            n2 = n3;
            n = n4;
        }
        nArray = PeakMeter.hsbFade(n4, n3, rmsTopColor, rmsBotColor, this.vertical);
        this.imgRMS = new BufferedImage(n2, n, 2);
        this.imgRMS.setRGB(0, 0, n2, n, nArray, 0, n2);
        nArray = PeakMeter.hsbFade(n4, n3, peakTopColor, peakBotColor, this.vertical);
        this.imgPeak = new BufferedImage(n2, n, 2);
        this.imgPeak.setRGB(0, 0, n2, n, nArray, 0, n2);
        this.calcedLength = this.recentLength;
        this.calcedBreadth = this.recentBreadth;
    }

    private static int[] widenPixV(int[] nArray, int n, int n2, int n3) {
        int n4 = Math.min(n, n2);
        int n5 = n4 >> 1;
        int n6 = n4 - n5;
        int n7 = n2 - n;
        int[] nArray2 = new int[n2 * n3];
        int n8 = 0;
        int n9 = 0;
        int n10 = n - n6;
        int n11 = 0;
        int n12 = n2 - n6;
        while (n8 < n3) {
            System.arraycopy(nArray, n9, nArray2, n11, n5);
            System.arraycopy(nArray, n10, nArray2, n12, n6);
            ++n8;
            n9 += n;
            n10 += n;
            n11 += n2;
            n12 += n2;
        }
        if (n7 > 0) {
            n9 = 0;
            n10 = n5;
            n11 = n5;
            while (n9 < n3) {
                n8 = nArray[n10];
                n12 = n11 + n7;
                while (n11 < n12) {
                    nArray2[n11] = n8;
                    ++n11;
                }
                ++n9;
                n10 += n;
                n11 += n;
            }
        }
        return nArray2;
    }

    private static int[] widenPixH(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = Math.min(n, n2);
        int n8 = n7 >> 1;
        int n9 = n7 - n8;
        int n10 = n2 - n9;
        int n11 = n - n9;
        int[] nArray2 = new int[n2 * n3];
        int n12 = 0;
        for (n6 = 0; n6 < n8; ++n6) {
            n5 = 0;
            n4 = n6;
            while (n5 < n3) {
                nArray2[n12] = nArray[n4];
                ++n5;
                ++n12;
                n4 += n;
            }
        }
        while (n6 < n10) {
            n5 = 0;
            n4 = n8;
            while (n5 < n3) {
                nArray2[n12] = nArray[n4];
                ++n5;
                ++n12;
                n4 += n;
            }
            ++n6;
        }
        n5 = n11;
        while (n6 < n2) {
            n4 = 0;
            int n13 = n5;
            while (n4 < n3) {
                nArray2[n12] = nArray[n13];
                ++n4;
                ++n12;
                n13 += n;
            }
            ++n6;
            ++n5;
        }
        return nArray2;
    }

    private static int[] hsbFade(int n, int n2, int[] nArray, int[] nArray2, boolean bl) {
        int[] nArray3;
        int[] nArray4;
        int[] nArray5 = new int[n * n2];
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float f = 1.0f / (float)(n2 - 2);
        if (n == 10) {
            nArray4 = nArray;
            nArray3 = nArray2;
        } else {
            nArray4 = PeakMeter.widenPixV(nArray, 10, n, 1);
            nArray3 = PeakMeter.widenPixV(nArray2, 10, n, 1);
        }
        for (int i = 0; i < n; ++i) {
            float f2;
            float f3;
            int n3;
            int n4;
            int n5 = nArray4[i];
            Color.RGBtoHSB(n5 >> 16 & 0xFF, n5 >> 8 & 0xFF, n5 & 0xFF, fArray);
            n5 = nArray3[i];
            Color.RGBtoHSB(n5 >> 16 & 0xFF, n5 >> 8 & 0xFF, n5 & 0xFF, fArray2);
            if (bl) {
                n4 = 0;
                n3 = i;
                while (n4 < n2) {
                    f3 = (float)n4 * f;
                    f2 = 1.0f - f3;
                    n5 = Color.HSBtoRGB(fArray[0] * f2 + fArray2[0] * f3, fArray[1] * f2 + fArray2[1] * f3, fArray[2] * f2 + fArray2[2] * f3);
                    nArray5[n3] = n5 | 0xFF000000;
                    nArray5[n3 + n] = -16777216;
                    n4 += 2;
                    n3 += n << 1;
                }
                continue;
            }
            n3 = i * n2;
            for (n4 = 0; n4 < n2; n4 += 2) {
                f3 = (float)n4 * f;
                f2 = 1.0f - f3;
                n5 = Color.HSBtoRGB(fArray[0] * f3 + fArray2[0] * f2, fArray[1] * f3 + fArray2[1] * f2, fArray[2] * f3 + fArray2[2] * f2);
                nArray5[n3++] = n5 | 0xFF000000;
                nArray5[n3++] = -16777216;
            }
        }
        return nArray5;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = n2 - (this.insets.left + this.insets.right);
        int n5 = n3 - (this.insets.top + this.insets.bottom);
        if (this.vertical) {
            n = n5;
            this.recentBreadth = n4;
        } else {
            n = n4;
            this.recentBreadth = n5;
        }
        int n6 = n - 1 & 0xFFFFFFFE;
        int n7 = n6 + 1;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n2, n3);
        if (n7 <= 0) {
            return;
        }
        if (n7 != this.recentLength) {
            this.holdPixPos = (int)(this.holdNorm * (float)n6) & 0xFFFFFFFE;
            this.peakPixPos = (int)(this.peakNorm * (float)n6) & 0xFFFFFFFE;
            this.rmsPixPos = Math.min((int)(this.rmsNorm * (float)n6) & 0xFFFFFFFE, this.peakPixPos - 4);
            this.recentLength = n7;
        }
        if (this.calcedLength != this.recentLength || this.calcedBreadth != this.recentBreadth) {
            this.recalcPaint();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.vertical) {
            graphics2D.translate(this.insets.left, this.insets.top + (n - n7));
            graphics2D.setPaint(this.pntBg);
            int n8 = n6 - this.holdPixPos;
            int n9 = n6 - this.peakPixPos;
            if (this.rmsPainted) {
                int n10 = n6 - this.rmsPixPos;
                graphics2D.fillRect(0, 0, this.recentBreadth, Math.min(n7, n10));
                if (this.holdPainted && this.holdPixPos >= 0) {
                    graphics2D.drawImage(this.imgPeak, 0, n8, this.recentBreadth, n8 + 1, 0, n8, this.recentBreadth, n8 + 1, this);
                }
                if (this.peakPixPos >= 0) {
                    int n11 = Math.min(n7, n10 - 2);
                    graphics2D.drawImage(this.imgPeak, 0, n9, this.recentBreadth, n11, 0, n9, this.recentBreadth, n11, this);
                }
                if (this.rmsPixPos >= 0) {
                    graphics2D.drawImage(this.imgRMS, 0, n10, this.recentBreadth, n7, 0, n10, this.recentBreadth, n7, this);
                }
            } else {
                graphics2D.fillRect(0, 0, this.recentBreadth, n9);
                if (this.holdPainted && this.holdPixPos >= 0) {
                    graphics2D.drawImage(this.imgPeak, 0, n8, this.recentBreadth, n8 + 1, 0, n8, this.recentBreadth, n8 + 1, this);
                }
                if (this.peakPixPos >= 0) {
                    graphics2D.drawImage(this.imgPeak, 0, n9, this.recentBreadth, n7, 0, n9, this.recentBreadth, n7, this);
                }
            }
        } else {
            graphics2D.translate(this.insets.left, this.insets.top);
            graphics2D.setPaint(this.pntBg);
            if (this.rmsPainted) {
                int n12 = Math.max(0, this.rmsPixPos);
                graphics2D.fillRect(n12, 0, n7 - n12, this.recentBreadth);
                if (this.holdPainted && this.holdPixPos >= 0) {
                    graphics2D.drawImage(this.imgPeak, this.holdPixPos, 0, this.holdPixPos + 1, this.recentBreadth, this.holdPixPos, 0, this.holdPixPos + 1, this.recentBreadth, this);
                }
                if (this.peakPixPos >= 0) {
                    int n13 = Math.max(0, this.rmsPixPos + 3);
                    graphics2D.drawImage(this.imgPeak, n13, 0, this.peakPixPos + 1, this.recentBreadth, n13, 0, this.peakPixPos + 1, this.recentBreadth, this);
                }
                if (this.rmsPixPos >= 0) {
                    graphics2D.drawImage(this.imgRMS, 0, 0, this.rmsPixPos + 1, this.recentBreadth, 0, 0, this.rmsPixPos + 1, this.recentBreadth, this);
                }
            } else {
                int n14 = Math.max(0, this.peakPixPos);
                graphics2D.fillRect(n14, 0, n7 - n14, this.recentBreadth);
                if (this.holdPainted && this.holdPixPos >= 0) {
                    graphics2D.drawImage(this.imgPeak, this.holdPixPos, 0, this.holdPixPos + 1, this.recentBreadth, this.holdPixPos, 0, this.holdPixPos + 1, this.recentBreadth, this);
                }
                if (this.peakPixPos >= 0) {
                    graphics2D.drawImage(this.imgPeak, 0, 0, this.peakPixPos + 1, this.recentBreadth, 0, 0, this.peakPixPos + 1, this.recentBreadth, this);
                }
            }
        }
        this.peakToPaint = -160.0f;
        this.rmsToPaint = -160.0f;
        this.holdToPaint = -160.0f;
        this.peakPixPosP = this.peakPixPos;
        this.rmsPixPosP = this.rmsPixPos;
        this.holdPixPosP = this.holdPixPos;
        graphics2D.setTransform(affineTransform);
    }

    private void disposeImages() {
        if (this.imgPeak != null) {
            this.imgPeak.flush();
            this.imgPeak = null;
        }
        if (this.imgRMS != null) {
            this.imgRMS.flush();
            this.imgRMS = null;
        }
        if (this.imgBg != null) {
            this.imgBg.flush();
            this.imgBg = null;
            this.pntBg = null;
        }
        this.calcedLength = -1;
    }

    @Override
    public void dispose() {
        this.disposeImages();
    }
}

