/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;

public class PathList {
    public static final String KEY_USERPATHS = "usrpaths";
    private final int capacity;
    private final List paths;
    private final Preferences prefs;
    private final String prefsKey;

    public PathList(int n) {
        this.capacity = n;
        this.paths = new ArrayList(n);
        this.prefs = null;
        this.prefsKey = null;
    }

    public PathList(int n, Preferences preferences, String string) {
        this.capacity = n;
        this.paths = new ArrayList(n);
        this.prefs = preferences;
        this.prefsKey = string;
        this.fromPrefs();
    }

    public int getCapacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPathCount() {
        List list = this.paths;
        synchronized (list) {
            return this.paths.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getPath(int n) {
        List list = this.paths;
        synchronized (list) {
            return (File)this.paths.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(int n, File file) {
        List list = this.paths;
        synchronized (list) {
            this.paths.set(n, file);
            this.toPrefs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        List list = this.paths;
        synchronized (list) {
            this.paths.remove(n);
            this.toPrefs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(File file) {
        List list = this.paths;
        synchronized (list) {
            this.paths.remove(file);
            this.toPrefs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPathToHead(File file) {
        boolean bl = false;
        List list = this.paths;
        synchronized (list) {
            this.paths.add(0, file);
            if (this.paths.size() > this.capacity) {
                this.paths.remove(this.paths.size() - 1);
                bl = true;
            }
            this.toPrefs();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPathToTail(File file) {
        boolean bl = false;
        List list = this.paths;
        synchronized (list) {
            this.paths.add(file);
            if (this.paths.size() > this.capacity) {
                this.paths.remove(0);
                bl = true;
            }
            this.toPrefs();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List list = this.paths;
        synchronized (list) {
            this.paths.clear();
            this.toPrefs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(File file) {
        List list = this.paths;
        synchronized (list) {
            return this.paths.contains(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(File file) {
        List list = this.paths;
        synchronized (list) {
            return this.paths.indexOf(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toPrefs() {
        if (this.prefs == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.paths;
        synchronized (list) {
            for (int i = 0; i < this.paths.size(); ++i) {
                stringBuffer.append(((File)this.paths.get(i)).getAbsolutePath());
                stringBuffer.append(File.pathSeparator);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            this.prefs.put(this.prefsKey, stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fromPrefs() {
        List list = this.paths;
        synchronized (list) {
            this.paths.clear();
            if (this.prefs == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.prefs.get(this.prefsKey, ""), File.pathSeparator);
            while (stringTokenizer.hasMoreTokens() && this.paths.size() < this.capacity) {
                this.paths.add(new File(stringTokenizer.nextToken()));
            }
        }
    }
}

