/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.gui.MenuAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LogTextArea
extends JTextArea {
    protected final boolean useLogFile;
    protected final File logFile;
    private final PrintStream outStream;
    protected FileWriter logFileWriter = null;
    private int totalLength = 0;
    private MenuAction actionClear = null;

    public LogTextArea(int n, int n2, boolean bl, File file) {
        super(n, n2);
        this.useLogFile = bl;
        this.logFile = file;
        this.outStream = new PrintStream(new RedirectedStream());
        this.setEditable(false);
        this.setLineWrap(true);
    }

    public LogTextArea() {
        this(6, 40, false, null);
    }

    public PrintStream getLogStream() {
        return this.outStream;
    }

    @Override
    public void append(String string) {
        super.append(string);
        this.totalLength += string.length();
        this.updateCaret();
    }

    private void updateCaret() {
        try {
            this.setCaretPosition(Math.max(0, this.totalLength - 1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.totalLength = string == null ? 0 : string.length();
    }

    public MenuAction getClearAction() {
        if (this.actionClear == null) {
            this.actionClear = new ActionClear();
        }
        return this.actionClear;
    }

    public JScrollPane placeMeInAPane() {
        JScrollPane jScrollPane = new JScrollPane(this, 20, 31);
        jScrollPane.putClientProperty("styleId", "undecorated");
        return jScrollPane;
    }

    public void makeSystemOutput() {
        System.setOut(this.getLogStream());
        System.setErr(this.getLogStream());
    }

    private class ActionClear
    extends MenuAction {
        protected ActionClear() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogTextArea.this.setText(null);
        }
    }

    private class RedirectedStream
    extends OutputStream {
        private byte[] cheesy = new byte[1];

        protected RedirectedStream() {
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            String string = new String(byArray, n, n2);
            LogTextArea.this.append(string);
            if (LogTextArea.this.useLogFile) {
                if (LogTextArea.this.logFileWriter == null) {
                    LogTextArea.this.logFileWriter = new FileWriter(LogTextArea.this.logFile);
                }
                LogTextArea.this.logFileWriter.write(string);
            }
        }

        @Override
        public void flush() throws IOException {
            if (LogTextArea.this.logFileWriter != null) {
                LogTextArea.this.logFileWriter.flush();
            }
            super.flush();
        }

        @Override
        public void close() throws IOException {
            if (LogTextArea.this.logFileWriter != null) {
                LogTextArea.this.logFileWriter.close();
                LogTextArea.this.logFileWriter = null;
            }
            super.close();
        }

        @Override
        public void write(int n) throws IOException {
            this.cheesy[0] = (byte)n;
            this.write(this.cheesy);
        }
    }
}

