/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.DynamicAncestorAdapter;
import de.sciss.app.DynamicListening;
import de.sciss.app.LaterInvocationManager;
import de.sciss.app.PreferenceEntrySync;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class KeyStrokeTextField
extends JTextField
implements DynamicListening,
PreferenceChangeListener,
LaterInvocationManager.Listener,
PreferenceEntrySync {
    private boolean listening = false;
    private Preferences prefs = null;
    private String key = null;
    private final LaterInvocationManager lim = new LaterInvocationManager(this);
    protected KeyStroke guiStroke = null;
    private KeyStroke defaultValue = null;
    private boolean readPrefs = true;
    protected boolean writePrefs = true;

    public KeyStrokeTextField() {
        super(24);
        this.init();
    }

    public KeyStrokeTextField(KeyStroke keyStroke) {
        super(KeyStrokeTextField.strokeToString(keyStroke), 24);
        this.defaultValue = keyStroke;
        this.init();
    }

    @Override
    public void setReadPrefs(boolean bl) {
        if (bl != this.readPrefs) {
            this.readPrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.readPrefs) {
                    this.prefs.addPreferenceChangeListener(this);
                } else {
                    this.prefs.removePreferenceChangeListener(this);
                }
            }
        }
    }

    @Override
    public boolean getReadPrefs() {
        return this.readPrefs;
    }

    @Override
    public void setWritePrefs(boolean bl) {
        this.writePrefs = bl;
    }

    @Override
    public boolean getWritePrefs() {
        return this.writePrefs;
    }

    public static final KeyStroke prefsToStroke(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(32);
        KeyStroke keyStroke = null;
        try {
            if (n < 0) {
                return null;
            }
            keyStroke = KeyStroke.getKeyStroke(Integer.parseInt(string.substring(n + 1)), Integer.parseInt(string.substring(0, n)));
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return keyStroke;
    }

    public static final String strokeToPrefs(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return null;
        }
        return String.valueOf(keyStroke.getModifiers()) + ' ' + String.valueOf(keyStroke.getKeyCode());
    }

    private void init() {
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 0: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 20: 
                    case 144: 
                    case 157: 
                    case 65406: {
                        return;
                    }
                }
                KeyStrokeTextField.this.guiStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                if (KeyStrokeTextField.this.writePrefs) {
                    KeyStrokeTextField.this.writePrefs();
                }
                keyEvent.consume();
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
            }
        });
        new DynamicAncestorAdapter(this).addTo(this);
    }

    @Override
    public void writePrefs() {
        if (this.prefs != null && this.key != null) {
            KeyStroke keyStroke = KeyStrokeTextField.prefsToStroke(this.prefs.get(this.key, null));
            if (keyStroke == null && this.guiStroke != null || keyStroke != null && this.guiStroke == null || keyStroke != null && this.guiStroke != null && !keyStroke.equals(this.guiStroke)) {
                this.prefs.put(this.key, KeyStrokeTextField.strokeToPrefs(this.guiStroke));
            }
            this.setText(KeyStrokeTextField.strokeToString(this.guiStroke));
        }
    }

    private static final String strokeToString(KeyStroke keyStroke) {
        return KeyEvent.getKeyModifiersText(keyStroke.getModifiers()) + ' ' + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    @Override
    public void setPreferenceNode(Preferences preferences) {
        this.setPreferences(preferences, this.key);
    }

    @Override
    public void setPreferenceKey(String string) {
        this.setPreferences(this.prefs, string);
    }

    @Override
    public void setPreferences(Preferences preferences, String string) {
        if (this.listening) {
            this.stopListening();
            this.prefs = preferences;
            this.key = string;
            this.startListening();
        } else {
            this.prefs = preferences;
            this.key = string;
        }
    }

    @Override
    public Preferences getPreferenceNode() {
        return this.prefs;
    }

    @Override
    public String getPreferenceKey() {
        return this.key;
    }

    @Override
    public void startListening() {
        if (this.prefs != null && this.readPrefs) {
            this.prefs.addPreferenceChangeListener(this);
            this.listening = true;
            if (this.key != null) {
                this.readPrefsFromString(this.prefs.get(this.key, null));
            }
        }
    }

    @Override
    public void stopListening() {
        if (this.prefs != null) {
            this.prefs.removePreferenceChangeListener(this);
            this.listening = false;
        }
    }

    @Override
    public void laterInvocation(Object object) {
        this.readPrefsFromString(((PreferenceChangeEvent)object).getNewValue());
    }

    @Override
    public void readPrefs() {
        if (this.prefs != null && this.key != null) {
            this.readPrefsFromString(this.prefs.get(this.key, null));
        }
    }

    private void readPrefsFromString(String string) {
        KeyStroke keyStroke = KeyStrokeTextField.prefsToStroke(string);
        if (keyStroke == null) {
            if (this.defaultValue != null) {
                this.guiStroke = this.defaultValue;
                if (this.writePrefs) {
                    this.writePrefs();
                }
            }
            return;
        }
        if (this.guiStroke == null || this.guiStroke != null && !keyStroke.equals(this.guiStroke)) {
            this.setText(KeyStrokeTextField.strokeToString(keyStroke));
            this.guiStroke = keyStroke;
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(this.key)) {
            this.lim.queue(preferenceChangeEvent);
        }
    }
}

