/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.BasicEvent;
import de.sciss.app.EventManager;
import de.sciss.gui.NumberEvent;
import de.sciss.gui.NumberListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public class Jog
extends JComponent
implements PropertyChangeListener,
EventManager.Processor {
    private static final ColorScheme lightScheme = new ColorScheme(new GradientPaint(10.0f, 9.0f, new Color(235, 235, 235), 10.0f, 19.0f, new Color(248, 248, 248)), new Color(40, 40, 40), new Color(251, 251, 251), new Color(255, 255, 255), new GradientPaint(12.0f, 0.0f, new Color(40, 40, 40, 160), 8.0f, 15.0f, new Color(40, 40, 40, 0)), new GradientPaint(0.0f, -3.0f, new Color(88, 88, 88), 0.0f, 3.0f, new Color(208, 208, 208)));
    private static final ColorScheme lightSchemeD = new ColorScheme(new GradientPaint(10.0f, 9.0f, new Color(235, 235, 235, 127), 10.0f, 19.0f, new Color(248, 248, 248, 127)), new Color(40, 40, 40, 127), new Color(251, 251, 251, 127), new Color(255, 255, 255, 127), new GradientPaint(12.0f, 0.0f, new Color(40, 40, 40, 80), 8.0f, 15.0f, new Color(40, 40, 40, 0)), new GradientPaint(0.0f, -3.0f, new Color(88, 88, 88, 127), 0.0f, 3.0f, new Color(208, 208, 208, 127)));
    private static final ColorScheme darkScheme = new ColorScheme(new GradientPaint(10.0f, 9.0f, new Color(24, 24, 24), 10.0f, 19.0f, new Color(32, 32, 32)), new Color(0, 0, 0), new GradientPaint(0.0f, 1.0f, new Color(72, 72, 72, 128), 0.0f, 10.0f, new Color(48, 48, 48, 64)), new Color(64, 64, 64), new GradientPaint(12.0f, 0.0f, new Color(16, 16, 16, 160), 8.0f, 15.0f, new Color(16, 16, 16, 0)), new GradientPaint(0.0f, -3.0f, new Color(72, 72, 72), 0.0f, 3.0f, new Color(160, 160, 160)));
    private static final ColorScheme darkSchemeD = new ColorScheme(new GradientPaint(10.0f, 9.0f, new Color(24, 24, 24, 127), 10.0f, 19.0f, new Color(32, 32, 32, 127)), new Color(0, 0, 0, 127), new GradientPaint(0.0f, 1.0f, new Color(72, 72, 72, 64), 0.0f, 10.0f, new Color(48, 48, 48, 32)), new Color(64, 64, 64), new GradientPaint(12.0f, 0.0f, new Color(16, 16, 16, 80), 8.0f, 15.0f, new Color(16, 16, 16, 0)), new GradientPaint(0.0f, -3.0f, new Color(72, 72, 72, 127), 0.0f, 3.0f, new Color(160, 160, 160, 127)));
    private static final Stroke strkOutline = new BasicStroke(0.5f);
    private static final Stroke strkArcShadow = new BasicStroke(1.2f);
    private static final Stroke strkArcLight = new BasicStroke(1.0f);
    private static final Shape shpBelly = new Ellipse2D.Double(-2.5, -2.5, 5.0, 5.0);
    protected final Point2D bellyPos = new Point2D.Double(-0.7071064, -0.7071064);
    protected static final Cursor dragCursor = new Cursor(13);
    protected Cursor savedCursor = null;
    protected int dragX;
    protected int dragY;
    protected double dragArc;
    protected double displayArc = -2.356194;
    protected boolean reFire = false;
    private static final double PI2 = Math.PI * 2;
    protected Insets in;
    private EventManager elm = null;
    private final ColorScheme colors;
    private final ColorScheme colorsD;

    public Jog() {
        this(UIManager.getBoolean("dark-skin"));
    }

    public Jog(boolean bl) {
        this.colors = bl ? darkScheme : lightScheme;
        this.colorsD = bl ? darkSchemeD : lightSchemeD;
        this.updatePreferredSize();
        this.setFocusable(true);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Jog.this.reFire = false;
                if (!Jog.this.isEnabled()) {
                    return;
                }
                Jog.this.requestFocus();
                Window window = SwingUtilities.getWindowAncestor(Jog.this);
                if (window != null) {
                    Jog.this.savedCursor = window.getCursor();
                    window.setCursor(dragCursor);
                }
                this.processMouse(mouseEvent, false);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (!Jog.this.isEnabled()) {
                    return;
                }
                Window window = SwingUtilities.getWindowAncestor(Jog.this);
                if (window != null) {
                    window.setCursor(Jog.this.savedCursor);
                }
                if (Jog.this.reFire) {
                    Jog.this.dispatchChange(0, false);
                    Jog.this.reFire = false;
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!Jog.this.isEnabled()) {
                    return;
                }
                this.processMouse(mouseEvent, true);
            }

            private void processMouse(MouseEvent mouseEvent, boolean bl) {
                int n = Jog.this.getWidth() - Jog.this.in.left - Jog.this.in.right;
                int n2 = Jog.this.getWidth() - Jog.this.in.top - Jog.this.in.bottom;
                double d = (double)(mouseEvent.getX() - Jog.this.in.left) - (double)n * 0.5;
                double d2 = (double)(mouseEvent.getY() - Jog.this.in.top) - (double)n2 * 0.5;
                if (bl) {
                    double d3 = Math.atan2(d, d2) + Math.PI;
                    double d4 = Math.max(0.125, Math.sqrt((d /= (double)n) * d + (d2 /= (double)n2) * d2) / 2.0);
                    double d5 = d3 - Jog.this.dragArc;
                    if (d5 < -Math.PI) {
                        d5 = Math.PI * 2 - d5;
                    } else if (d5 > Math.PI) {
                        d5 = Math.PI * -2 + d5;
                    }
                    d = mouseEvent.getX() - Jog.this.dragX;
                    d2 = mouseEvent.getY() - Jog.this.dragY;
                    int n3 = (int)(Math.sqrt(d * d + d2 * d2) * 0.5);
                    double d6 = (Jog.this.displayArc + (double)(d5 < 0.0 ? -1 : 1) * Math.min(0.4, d4 * (double)n3)) % (Math.PI * 2);
                    if (n3 >= 1) {
                        if (n3 >= 17) {
                            n3 *= n3 - 16;
                        }
                        Jog.this.displayArc = d6;
                        Jog.this.dragArc = d3;
                        Jog.this.dragX = mouseEvent.getX();
                        Jog.this.dragY = mouseEvent.getY();
                        Jog.this.repaint();
                        Jog.this.dispatchChange(n3 *= d5 < 0.0 ? 1 : -1, true);
                        Jog.this.reFire = true;
                    }
                } else {
                    Jog.this.dragX = mouseEvent.getX();
                    Jog.this.dragY = mouseEvent.getY();
                    Jog.this.dragArc = Math.atan2(d, d2) + Math.PI;
                }
                Jog.this.bellyPos.setLocation(Math.cos(Jog.this.displayArc), Math.sin(Jog.this.displayArc));
                Jog.this.repaint();
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        this.addPropertyChangeListener("border", this);
    }

    private void updatePreferredSize() {
        this.in = this.getInsets();
        Dimension dimension = new Dimension(20 + this.in.left + this.in.right, 20 + this.in.top + this.in.bottom);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.translate(0.5f + (float)this.in.left, 0.5f + (float)this.in.top);
        ColorScheme colorScheme = this.isEnabled() ? this.colors : this.colorsD;
        graphics2D.setPaint(colorScheme.pntBack);
        graphics2D.fillOval(2, 3, 16, 16);
        graphics2D.setPaint(colorScheme.pntLight);
        graphics2D.fillOval(5, 1, 9, 10);
        graphics2D.setPaint(colorScheme.pntArcShadow);
        graphics2D.setStroke(strkArcShadow);
        graphics2D.drawOval(1, 1, 17, 17);
        graphics2D.setStroke(strkArcLight);
        graphics2D.setPaint(colorScheme.pntArcLight);
        graphics2D.drawArc(1, 2, 17, 17, 180, 180);
        graphics2D.setPaint(colorScheme.pntOutline);
        graphics2D.setStroke(strkOutline);
        graphics2D.drawOval(1, 1, 17, 17);
        graphics2D.translate(this.bellyPos.getX() * 4.0 + 10.0, -this.bellyPos.getY() * 4.5 + 10.0);
        graphics2D.setPaint(colorScheme.pntBelly);
        graphics2D.fill(shpBelly);
        graphics2D.setStroke(stroke);
        graphics2D.setTransform(affineTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(NumberListener numberListener) {
        Jog jog = this;
        synchronized (jog) {
            if (this.elm == null) {
                this.elm = new EventManager(this);
            }
            this.elm.addListener(numberListener);
        }
    }

    public void removeListener(NumberListener numberListener) {
        if (this.elm != null) {
            this.elm.removeListener(numberListener);
        }
    }

    @Override
    public void processEvent(BasicEvent basicEvent) {
        block3: for (int i = 0; i < this.elm.countListeners(); ++i) {
            NumberListener numberListener = (NumberListener)this.elm.getListener(i);
            switch (basicEvent.getID()) {
                case 0: {
                    numberListener.numberChanged((NumberEvent)basicEvent);
                    continue block3;
                }
                default: {
                    assert (false) : basicEvent.getID();
                    continue block3;
                }
            }
        }
    }

    protected void dispatchChange(int n, boolean bl) {
        if (this.elm != null) {
            this.elm.dispatchEvent(new NumberEvent(this, 0, System.currentTimeMillis(), n, bl));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("border")) {
            this.updatePreferredSize();
        }
    }

    private static final class ColorScheme {
        final Paint pntBack;
        final Paint pntOutline;
        final Paint pntLight;
        final Paint pntArcLight;
        final Paint pntArcShadow;
        final Paint pntBelly;

        ColorScheme(Paint paint, Paint paint2, Paint paint3, Paint paint4, Paint paint5, Paint paint6) {
            this.pntBack = paint;
            this.pntOutline = paint2;
            this.pntLight = paint3;
            this.pntArcLight = paint4;
            this.pntArcShadow = paint5;
            this.pntBelly = paint6;
        }
    }
}

