/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.AbstractApplication;
import de.sciss.app.AbstractWindow;
import de.sciss.app.Application;
import de.sciss.app.WindowHandler;
import de.sciss.gui.AbstractWindowHandler;
import de.sciss.gui.GUIUtil;
import de.sciss.gui.HelpButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class HelpFrame
implements HyperlinkListener,
PropertyChangeListener {
    public static final Object COMP_HELP = HelpFrame.class;
    private final JEditorPane htmlPane;
    protected final JButton ggEdit;
    private final JButton ggOpenInBrowser;
    protected final JButton ggBack;
    protected final ArrayList history = new ArrayList();
    protected int historyIndex = -1;
    private final JScrollBar ggVScroll;
    private final String plainTitle;
    protected final AbstractWindow win;

    public HelpFrame() {
        final Application application = AbstractApplication.getApplication();
        WindowHandler windowHandler = application.getWindowHandler();
        this.win = windowHandler.createWindow(1);
        Container container = this.win.getContentPane();
        this.plainTitle = GUIUtil.getResourceString("frameHelp");
        this.win.setTitle(this.plainTitle);
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this);
        this.htmlPane.setPreferredSize(new Dimension(320, 320));
        this.htmlPane.setAutoscrolls(true);
        this.htmlPane.addPropertyChangeListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.htmlPane);
        jScrollPane.putClientProperty("styleId", "undecorated");
        this.ggVScroll = jScrollPane.getVerticalScrollBar();
        Box box = Box.createHorizontalBox();
        this.ggEdit = new JButton(GUIUtil.getResourceString("buttonTextEdit"));
        box.add(this.ggEdit);
        box.add(Box.createHorizontalGlue());
        this.ggEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HelpFrame.this.historyIndex < 0) {
                    return;
                }
                try {
                    String[] stringArray = application.getUserPrefs().get("text-editor", "gedit").split(" ");
                    HistoryEntry historyEntry = (HistoryEntry)HelpFrame.this.history.get(HelpFrame.this.historyIndex);
                    String[] stringArray2 = new String[stringArray.length + 1];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    stringArray2[stringArray2.length - 1] = new File(new URI(historyEntry.url.toString())).getAbsolutePath();
                    Runtime.getRuntime().exec(stringArray2);
                }
                catch (IOException iOException) {
                    GUIUtil.displayError(HelpFrame.this.win.getWindow(), iOException, HelpFrame.this.ggEdit.getText());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    GUIUtil.displayError(HelpFrame.this.win.getWindow(), illegalArgumentException, HelpFrame.this.ggEdit.getText());
                }
                catch (URISyntaxException uRISyntaxException) {
                    GUIUtil.displayError(HelpFrame.this.win.getWindow(), uRISyntaxException, HelpFrame.this.ggEdit.getText());
                }
            }
        });
        this.ggBack = new JButton(GUIUtil.getResourceString("buttonBack"));
        this.ggBack.setEnabled(false);
        box.add(this.ggBack);
        this.ggBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HelpFrame.this.historyIndex > 0) {
                    try {
                        try {
                            --HelpFrame.this.historyIndex;
                            HelpFrame.this.loadURL();
                        }
                        catch (IOException iOException) {
                            ++HelpFrame.this.historyIndex;
                            HelpFrame.this.loadURL();
                            throw iOException;
                        }
                    }
                    catch (IOException iOException) {
                        GUIUtil.displayError(HelpFrame.this.win.getWindow(), iOException, HelpFrame.this.ggBack.getText());
                    }
                }
            }
        });
        this.ggOpenInBrowser = new JButton(GUIUtil.getResourceString("helpOpenBrowser"));
        this.ggOpenInBrowser.setEnabled(false);
        box.add(this.ggOpenInBrowser);
        this.ggOpenInBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpFrame.this.openInBrowser();
            }
        });
        JButton jButton = new JButton(GUIUtil.getResourceString("buttonClose"));
        box.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpFrame.this.dispose();
            }
        });
        this.win.addListener(new AbstractWindow.Adapter(){

            @Override
            public void windowClosing(AbstractWindow.Event event) {
                HelpFrame.this.dispose();
            }
        });
        box.add(new HelpButton("HelpHTMLPane"));
        box.add(Box.createHorizontalStrut(16));
        container.add((Component)jScrollPane, "Center");
        container.add((Component)box, "South");
        AbstractWindowHandler.setDeepFont(this.win.getContentPane(), null);
        jScrollPane.setPreferredSize(new Dimension(512, 512));
        this.win.pack();
        this.win.setDefaultCloseOperation(0);
        this.win.init();
        application.addComponent(COMP_HELP, this);
    }

    public void dispose() {
        AbstractApplication.getApplication().removeComponent(COMP_HELP);
        this.win.dispose();
    }

    public static void openViewerAndLoadHelpFile(String string) {
        try {
            URL uRL = new File("help", string + ".html").toURI().toURL();
            HelpFrame.openViewerAndLoadHelpFile(uRL);
        }
        catch (IOException iOException) {
            GUIUtil.displayError(null, iOException, null);
        }
    }

    public static void openViewerAndLoadHelpFile(URL uRL) {
        HelpFrame helpFrame = (HelpFrame)AbstractApplication.getApplication().getComponent(COMP_HELP);
        if (helpFrame == null) {
            helpFrame = new HelpFrame();
        }
        helpFrame.loadHelpFile(uRL);
        helpFrame.win.setVisible(true);
        helpFrame.win.toFront();
    }

    public void loadHelpFile(String string) {
        try {
            URL uRL = new File("help", string + ".html").toURI().toURL();
            this.loadHelpFile(uRL);
        }
        catch (IOException iOException) {
            GUIUtil.displayError(this.win.getWindow(), iOException, null);
        }
    }

    public void loadHelpFile(URL uRL) {
        try {
            this.addAndLoadURL(uRL);
        }
        catch (IOException iOException) {
            GUIUtil.displayError(this.win.getWindow(), iOException, null);
        }
    }

    private void addAndLoadURL(URL uRL) throws IOException {
        if (this.historyIndex >= 0) {
            ((HistoryEntry)this.history.get(this.historyIndex)).setVerticalScroll(this.ggVScroll.getValue());
        }
        this.history.add(++this.historyIndex, new HistoryEntry(uRL));
        try {
            this.loadURL();
            for (int i = this.history.size() - 1; i > this.historyIndex; --i) {
                this.history.remove(i);
            }
        }
        catch (IOException iOException) {
            this.history.remove(this.historyIndex--);
            if (this.historyIndex >= 0) {
                this.loadURL();
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadURL() throws IOException {
        try {
            HistoryEntry historyEntry = (HistoryEntry)this.history.get(this.historyIndex);
            this.htmlPane.setPage(historyEntry.url);
        }
        finally {
            this.updateButtons();
        }
    }

    private void updateButtons() {
        this.ggOpenInBrowser.setEnabled(this.historyIndex >= 0);
        this.ggEdit.setEnabled(this.historyIndex >= 0);
        this.ggBack.setEnabled(this.historyIndex > 0);
    }

    protected void openInBrowser() {
        if (this.historyIndex >= 0) {
            try {
                URI uRI = ((HistoryEntry)this.history.get((int)this.historyIndex)).url.toURI();
                Desktop.getDesktop().browse(uRI);
            }
            catch (IOException iOException) {
                GUIUtil.displayError(this.win.getWindow(), iOException, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                GUIUtil.displayError(this.win.getWindow(), uRISyntaxException, null);
            }
        }
    }

    private void pageIsLoaded() {
        Document document = this.htmlPane.getDocument();
        HistoryEntry historyEntry = (HistoryEntry)this.history.get(this.historyIndex);
        if (document != null) {
            Object object = document.getProperty("title");
            this.win.setTitle(object == null ? this.plainTitle : this.plainTitle + " : " + object);
            this.ggVScroll.setValue(historyEntry.getVerticalScroll());
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.addAndLoadURL(hyperlinkEvent.getURL());
            }
            catch (IOException iOException) {
                GUIUtil.displayError(this.win.getWindow(), iOException, null);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("page")) {
            this.pageIsLoaded();
        }
    }

    private static class HistoryEntry {
        protected final URL url;
        private int verticalScroll;

        private HistoryEntry(URL uRL, int n) {
            this.url = uRL;
            this.verticalScroll = n;
        }

        protected HistoryEntry(URL uRL) {
            this(uRL, 0);
        }

        protected void setVerticalScroll(int n) {
            this.verticalScroll = n;
        }

        protected int getVerticalScroll() {
            return this.verticalScroll;
        }
    }
}

