/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class GradientPanel
extends JPanel {
    private static final Paint pntTopBorderLight = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 255), 0.0f, 8.0f, new Color(255, 255, 255, 0));
    private static final Paint pntBottomBorderLight = new GradientPaint(0.0f, 0.0f, new Color(159, 159, 159, 0), 0.0f, 8.0f, new Color(159, 159, 159, 255));
    private static final Paint pntTopBorderDark = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 79), 0.0f, 8.0f, new Color(255, 255, 255, 0));
    private static final Paint pntBottomBorderDark = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 0, 0), 0.0f, 8.0f, new Color(0, 0, 0, 127));
    private GradientPaint grad = null;
    private boolean topBorder = false;
    private boolean bottomBorder = false;
    private int gradXShift = 0;
    private int gradYShift = 0;

    private static boolean isDark() {
        return UIManager.getBoolean("dark-skin");
    }

    public static Paint pntTopBorder() {
        return GradientPanel.isDark() ? pntTopBorderDark : pntTopBorderLight;
    }

    public static Paint pntBottomBorder() {
        return GradientPanel.isDark() ? pntBottomBorderDark : pntBottomBorderLight;
    }

    public GradientPanel() {
        this.setOpaque(true);
    }

    public void setGradient(GradientPaint gradientPaint) {
        this.grad = gradientPaint;
        this.repaint();
    }

    public void setGradientShift(int n, int n2) {
        this.gradXShift = n;
        this.gradYShift = n2;
        this.repaint();
    }

    public void setTopBorder(boolean bl) {
        this.topBorder = bl;
        this.repaint();
    }

    public void setBottomBorder(boolean bl) {
        this.bottomBorder = bl;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.grad != null) {
            graphics2D.setPaint(this.grad);
            graphics2D.translate(-this.gradXShift, -this.gradYShift);
            graphics2D.fillRect(this.gradXShift, this.gradYShift, n, n2);
            graphics2D.translate(this.gradXShift, this.gradYShift);
        } else {
            super.paintComponent(graphics);
        }
        if (this.bottomBorder) {
            graphics2D.translate(0, n2 - 8);
            graphics2D.setPaint(GradientPanel.pntBottomBorder());
            graphics2D.fillRect(0, 0, n, 8);
            graphics2D.translate(0, 8 - n2);
        }
    }

    @Override
    public void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.topBorder) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getWidth();
            graphics2D.setPaint(GradientPanel.pntTopBorder());
            graphics2D.fillRect(0, 0, n, 8);
        }
    }
}

