/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.AbstractApplication;
import de.sciss.app.AbstractWindow;
import de.sciss.app.Application;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;

public class FloatingPaletteHandler
implements ActionListener {
    private static final int TIMEOUT = 100;
    private final Set palettes = new HashSet();
    protected final Set frames = new HashSet();
    private final Set hiddenPalettes = new HashSet();
    protected final Timer timer = new Timer(100, this);
    private AbstractWindow focusedWindow = null;
    private static final Map instances = new HashMap();
    private final AbstractWindow.Listener winListener;
    private boolean listen = false;
    private static final boolean DEBUG = false;
    private int modalDlgs = 0;

    public static FloatingPaletteHandler getInstance() {
        return FloatingPaletteHandler.getInstance(AbstractApplication.getApplication());
    }

    public static FloatingPaletteHandler getInstance(Application application) {
        FloatingPaletteHandler floatingPaletteHandler = (FloatingPaletteHandler)instances.get(application);
        if (floatingPaletteHandler == null) {
            floatingPaletteHandler = new FloatingPaletteHandler();
            instances.put(application, floatingPaletteHandler);
        }
        return floatingPaletteHandler;
    }

    public FloatingPaletteHandler() {
        this.timer.setRepeats(false);
        this.winListener = new AbstractWindow.Adapter(){

            @Override
            public void windowActivated(AbstractWindow.Event event) {
                AbstractWindow abstractWindow = event.getWindow();
                FloatingPaletteHandler.this.timer.stop();
                if (FloatingPaletteHandler.this.frames.contains(abstractWindow)) {
                    FloatingPaletteHandler.this.setFocusedWindow(abstractWindow);
                }
            }

            @Override
            public void windowDeactivated(AbstractWindow.Event event) {
                FloatingPaletteHandler.this.timer.restart();
            }
        };
    }

    public void setListening(boolean bl) {
        this.listen = bl;
        if (!this.palettes.isEmpty() || !this.frames.isEmpty()) {
            throw new IllegalStateException("Must only be called initially");
        }
    }

    public void add(AbstractWindow abstractWindow) {
        if (abstractWindow.isFloating()) {
            if (!this.palettes.add(abstractWindow)) {
                throw new IllegalArgumentException("Palette was already registered");
            }
            if (this.listen) {
                abstractWindow.addListener(this.winListener);
            }
        } else {
            if (!this.frames.add(abstractWindow)) {
                throw new IllegalArgumentException("Frame was already registered");
            }
            if (this.listen) {
                abstractWindow.addListener(this.winListener);
                if (FloatingPaletteHandler.isFocused(abstractWindow)) {
                    this.focusedWindow = abstractWindow;
                }
            }
        }
    }

    public void addModalDialog() {
        ++this.modalDlgs;
    }

    public void removeModalDialog() {
        --this.modalDlgs;
    }

    public void remove(AbstractWindow abstractWindow) {
        if (abstractWindow.isFloating()) {
            if (!this.palettes.remove(abstractWindow)) {
                throw new IllegalArgumentException("Palette was not registered");
            }
            if (this.listen) {
                abstractWindow.removeListener(this.winListener);
            }
            this.hiddenPalettes.remove(abstractWindow);
        } else {
            if (!this.frames.remove(abstractWindow)) {
                throw new IllegalArgumentException("Frame was not registered");
            }
            if (this.listen) {
                abstractWindow.removeListener(this.winListener);
                if (FloatingPaletteHandler.isFocused(abstractWindow)) {
                    this.focusedWindow = null;
                    this.timer.restart();
                }
            }
        }
    }

    public AbstractWindow getFocussedWindow() {
        return this.focusedWindow;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setFocusedWindow(null);
    }

    private static boolean isFocused(AbstractWindow abstractWindow) {
        if (abstractWindow.isActive()) {
            return true;
        }
        Window[] windowArray = abstractWindow.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (!FloatingPaletteHandler.isFocused(windowArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isFocused(Window window) {
        if (window.isFocused()) {
            return true;
        }
        Window[] windowArray = window.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (!FloatingPaletteHandler.isFocused(windowArray[i])) continue;
            return true;
        }
        return false;
    }

    protected void setFocusedWindow(AbstractWindow abstractWindow) {
        this.focusedWindow = abstractWindow;
        if (this.modalDlgs == 0) {
            if (abstractWindow != null) {
                this.showPalettes();
            } else {
                this.hidePalettes();
            }
        }
    }

    private void showPalettes() {
        if (!this.hiddenPalettes.isEmpty()) {
            for (AbstractWindow abstractWindow : this.hiddenPalettes) {
                abstractWindow.setVisible(true);
            }
            this.hiddenPalettes.clear();
            if (this.focusedWindow != null) {
                this.focusedWindow.setVisible(true);
            }
        }
    }

    private void hidePalettes() {
        if (!this.frames.isEmpty()) {
            for (AbstractWindow abstractWindow : this.frames) {
                if (!FloatingPaletteHandler.isFocused(abstractWindow)) continue;
                return;
            }
        }
        if (!this.palettes.isEmpty()) {
            for (AbstractWindow abstractWindow : this.palettes) {
                if (!FloatingPaletteHandler.isFocused(abstractWindow)) continue;
                return;
            }
        }
        for (AbstractWindow abstractWindow : this.palettes) {
            if (!abstractWindow.isVisible()) continue;
            this.hiddenPalettes.add(abstractWindow);
            abstractWindow.setVisible(false);
        }
    }
}

