/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.gui.ComponentHost;
import de.sciss.gui.VectorSpace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class Axis
extends JComponent {
    private static final long[] DECIMAL_RASTER = new long[]{100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L, 100L, 10L, 1L};
    private static final long[] INTEGERS_RASTER = new long[]{100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L};
    private static final long[] TIME_RASTER = new long[]{60000000L, 6000000L, 600000L, 60000L, 10000L, 1000L, 100L, 10L, 1L};
    private static final int MIN_LAB_SPC = 16;
    private int recentWidth = 0;
    private int recentHeight = 0;
    private boolean doRecalculate = true;
    private String[] labels = new String[0];
    private int[] labelPos = new int[0];
    private final GeneralPath shpTicks = new GeneralPath();
    private final int orient;
    private VectorSpace space;
    private final Paint pntBackground;
    private final Paint pntTicks;
    private final Paint pntLabel;
    private final BufferedImage img;
    private final Font fntLabel;
    private static final String[] msgNormalPattern = new String[]{"{0,number,0}", "{0,number,0.0}", "{0,number,0.00}", "{0,number,0.000}"};
    private static final String[] msgTimePattern = new String[]{"{0,number,integer}:{1,number,00}", "{0,number,integer}:{1,number,00.0}", "{0,number,integer}:{1,number,00.00}", "{0,number,integer}:{1,number,00.000}"};
    private final MessageFormat msgForm = new MessageFormat(msgNormalPattern[0], Locale.US);
    private final Object[] msgArgs = new Object[2];
    private static final int[] pntBarGradPixLight = new int[]{-4671304, -4144960, -3618616, -2894893, -2368549, -1776412, -1315861, -921103, -592138, -328966, -263173, -197380, -394759, -723724, -1052689};
    private static final int[] pntBarGradPixDark = new int[]{-16250872, -15724528, -15461356, -15000805, -14869219, -14540254, -14342875, -14145496, -13948117, -13816531, -13816531, -13750738, -13882324, -14013910, -14211289};
    private static final int barExtent = pntBarGradPixLight.length;
    private final AffineTransform trnsVertical = new AffineTransform();
    private String[] msgPattern;
    private long[] labelRaster;
    private long labelMinRaster;
    private int flags = -1;
    private boolean flMirror;
    private boolean flTimeFormat;
    private boolean flIntegers;
    private boolean flFixedBounds;
    private static final double ln10 = Math.log(10.0);
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int MIRROIR = 2;
    public static final int TIMEFORMAT = 4;
    public static final int INTEGERS = 8;
    public static final int FIXEDBOUNDS = 16;
    private final ComponentHost host;

    public Axis(int n) {
        this(n, UIManager.getBoolean("dark-skin"));
    }

    public Axis(int n, boolean bl) {
        this(n, 0, bl);
    }

    public Axis(int n, int n2) {
        this(n, n2, UIManager.getBoolean("dark-skin"));
    }

    public Axis(int n, int n2, boolean bl) {
        this(n, n2, bl, null);
    }

    public Axis(int n, int n2, ComponentHost componentHost) {
        this(n, n2, UIManager.getBoolean("dark-skin"), componentHost);
    }

    public Axis(int n, int n2, boolean bl, ComponentHost componentHost) {
        int n3;
        int n4;
        this.orient = n;
        this.host = componentHost;
        Font font = UIManager.getFont("Slider.font", Locale.US);
        Font font2 = this.fntLabel = font != null ? font.deriveFont(Math.min(font.getSize2D(), 9.5f)) : new Font("SansSerif", 0, 9);
        if (n == 0) {
            this.setMaximumSize(new Dimension(this.getMaximumSize().width, barExtent));
            this.setMinimumSize(new Dimension(this.getMinimumSize().width, barExtent));
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, barExtent));
            n4 = 1;
            n3 = barExtent;
        } else {
            this.setMaximumSize(new Dimension(barExtent, this.getMaximumSize().height));
            this.setMinimumSize(new Dimension(barExtent, this.getMinimumSize().height));
            this.setPreferredSize(new Dimension(barExtent, this.getPreferredSize().height));
            n4 = barExtent;
            n3 = 1;
        }
        this.setFlags(n2);
        this.img = new BufferedImage(n4, n3, 2);
        int[] nArray = bl ? pntBarGradPixDark : pntBarGradPixLight;
        this.img.setRGB(0, 0, n4, n3, nArray, 0, n4);
        this.pntBackground = new TexturePaint(this.img, new Rectangle(0, 0, n4, n3));
        this.pntTicks = bl ? new Color(192, 192, 192, 160) : Color.lightGray;
        this.pntLabel = bl ? Color.lightGray : Color.black;
        this.setOpaque(true);
    }

    public void setFlags(int n) {
        if (this.flags == n) {
            return;
        }
        this.flags = n;
        this.flMirror = (n & 2) != 0;
        this.flTimeFormat = (n & 4) != 0;
        this.flIntegers = (n & 8) != 0;
        boolean bl = this.flFixedBounds = (n & 0x10) != 0;
        if (this.flTimeFormat) {
            this.msgPattern = msgTimePattern;
            this.labelRaster = TIME_RASTER;
        } else {
            this.msgPattern = msgNormalPattern;
            this.labelRaster = this.flIntegers ? INTEGERS_RASTER : DECIMAL_RASTER;
        }
        this.labelMinRaster = this.labelRaster[this.labelRaster.length - 1];
        this.triggerRedisplay();
    }

    public int getFlags() {
        return this.flags;
    }

    public void setSpace(VectorSpace vectorSpace) {
        this.space = vectorSpace;
        this.triggerRedisplay();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        AffineTransform affineTransform = graphics2D.getTransform();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setFont(this.fntLabel);
        if (this.doRecalculate || n2 != this.recentWidth || n3 != this.recentHeight) {
            this.recentWidth = n2;
            this.recentHeight = n3;
            this.recalculateLabels(graphics);
            if (this.orient == 1) {
                this.recalculateTransforms();
            }
            this.doRecalculate = false;
        }
        graphics2D.setPaint(this.pntBackground);
        graphics2D.fillRect(0, 0, n2, n3);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.orient == 1) {
            graphics2D.transform(this.trnsVertical);
            n = n2 - 2 - fontMetrics.getMaxDescent();
        } else {
            n = n3 - 2 - fontMetrics.getMaxDescent();
        }
        graphics2D.setPaint(this.pntTicks);
        graphics2D.draw(this.shpTicks);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(this.pntLabel);
        for (int i = 0; i < this.labels.length; ++i) {
            graphics2D.drawString(this.labels[i], this.labelPos[i], n);
        }
        graphics2D.setTransform(affineTransform);
    }

    private void recalculateTransforms() {
        this.trnsVertical.setToRotation(-1.5707963267948966, (double)this.recentHeight / 2.0, (double)this.recentHeight / 2.0);
    }

    private int calcStringWidth(FontMetrics fontMetrics, double d) {
        if (this.flTimeFormat) {
            this.msgArgs[0] = (int)(d / 60.0);
            this.msgArgs[1] = d % 60.0;
        } else {
            this.msgArgs[0] = d;
        }
        return fontMetrics.stringWidth(this.msgForm.format(this.msgArgs));
    }

    private int calcMinLabSpc(FontMetrics fontMetrics, double d, double d2) {
        return Math.max(this.calcStringWidth(fontMetrics, d), this.calcStringWidth(fontMetrics, d2)) + 16;
    }

    private void recalculateLabels(Graphics graphics) {
        int n;
        double d;
        double d2;
        int n2;
        double d3;
        int n3;
        int n4;
        int n5;
        double d4;
        double d5;
        int n6;
        int n7;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.shpTicks.reset();
        if (this.space == null) {
            this.labels = new String[0];
            this.labelPos = new int[0];
            return;
        }
        if (this.orient == 0) {
            if (this.space.hlog) {
                this.recalculateLogLabels();
                return;
            }
            n7 = this.recentWidth;
            n6 = this.recentHeight;
            d5 = this.space.hmin;
            d4 = this.space.hmax;
        } else {
            if (this.space.vlog) {
                this.recalculateLogLabels();
                return;
            }
            n7 = this.recentHeight;
            n6 = this.recentWidth;
            d5 = this.space.vmin;
            d4 = this.space.vmax;
        }
        double d6 = (double)n7 / (d4 - d5);
        double d7 = 1000.0 * d5;
        double d8 = 1000.0 * d4;
        if (this.flFixedBounds) {
            long l = (long)Math.abs(d7);
            n5 = l % 1000L == 0L ? 0 : (l % 100L == 0L ? 1 : (l % 10L == 0L ? 2 : 3));
            l = (long)Math.abs(d8);
            if (l % 1000L != 0L) {
                n5 = l % 100L == 0L ? Math.max(n5, 1) : (l % 10L == 0L ? Math.max(n5, 2) : 3);
            }
            this.msgForm.applyPattern(this.msgPattern[n5]);
            n4 = this.calcMinLabSpc(fontMetrics, d5, d4);
            int n8 = 0;
            for (n3 = Math.max(1, n7 / n4); n3 > 2; n3 >>= 1) {
                ++n8;
            }
            d3 = (d8 - d7) / (double)(n3 <<= n8);
            l = (long)d3;
            int n9 = l % 1000L == 0L ? n5 : (l % 100L == 0L ? Math.max(n5, 1) : (l % 10L == 0L ? Math.max(n5, 2) : 3));
            if (n9 != n5) {
                this.msgForm.applyPattern(this.msgPattern[n9]);
                n4 = this.calcMinLabSpc(fontMetrics, d5, d4);
                n8 = 0;
                for (n3 = Math.max(1, n7 / n4); n3 > 2; n3 >>= 1) {
                    ++n8;
                }
                d3 = (d8 - d7) / (double)(n3 <<= n8);
                l = (long)d3;
                n9 = l % 1000L == 0L ? n5 : (l % 100L == 0L ? Math.max(n5, 1) : (l % 10L == 0L ? Math.max(n5, 2) : 3));
                this.msgForm.applyPattern(this.msgPattern[n9]);
            }
            n2 = 4;
            d2 = d7;
            d = 0.0;
        } else {
            this.msgForm.applyPattern(this.msgPattern[0]);
            n4 = this.calcMinLabSpc(fontMetrics, d5, d4);
            n3 = Math.max(1, n7 / n4);
            d3 = Math.ceil((d8 - d7) / (double)n3);
            n5 = this.flIntegers ? 0 : 3;
            long l = this.labelMinRaster;
            for (n = 0; n < this.labelRaster.length; ++n) {
                if (!(d3 >= (double)this.labelRaster[n])) continue;
                n5 = Math.max(0, n - 5);
                l = this.labelRaster[n];
                break;
            }
            this.msgForm.applyPattern(this.msgPattern[n5]);
            if (n5 > 0) {
                n4 = Math.max(this.calcStringWidth(fontMetrics, d5), this.calcStringWidth(fontMetrics, d4)) + 16;
                n3 = Math.max(1, n7 / n4);
                d3 = Math.ceil((d8 - d7) / (double)n3);
            }
            if ((d3 = Math.max(1.0, Math.floor((d3 + (double)l - 1.0) / (double)l))) > 9.0) {
                n2 = 5;
            } else {
                switch ((int)d3) {
                    case 2: 
                    case 4: 
                    case 8: {
                        n2 = 4;
                        break;
                    }
                    case 3: 
                    case 6: {
                        n2 = 6;
                        break;
                    }
                    case 7: 
                    case 9: {
                        d3 = 10.0;
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 5;
                    }
                }
            }
            d2 = Math.floor(Math.abs(d7) / (d3 *= (double)l)) * (d7 >= 0.0 ? d3 : -d3);
            d = (d2 - d7) / 1000.0 * d6 + 0.5;
        }
        double d9 = d3 / 1000.0 * d6;
        double d10 = d9 / (double)n2;
        n3 = Math.max(0, (int)(((double)n7 - d + d9 - 1.0) / d9));
        if (this.labels.length != n3) {
            this.labels = new String[n3];
        }
        if (this.labelPos.length != n3) {
            this.labelPos = new int[n3];
        }
        if (this.flMirror) {
            d = (double)n7 - d;
            d10 = -d10;
        }
        for (n = 0; n < n3; ++n) {
            if (this.flTimeFormat) {
                this.msgArgs[0] = (int)(d2 / 60000.0);
                this.msgArgs[1] = d2 % 60000.0 / 1000.0;
            } else {
                this.msgArgs[0] = d2 / 1000.0;
            }
            this.labels[n] = this.msgForm.format(this.msgArgs);
            this.labelPos[n] = (int)d + 2;
            d2 += d3;
            this.shpTicks.moveTo((float)d, 1.0f);
            this.shpTicks.lineTo((float)d, n6 - 2);
            d += d10;
            for (int i = 1; i < n2; ++i) {
                this.shpTicks.moveTo((float)d, n6 - 4);
                this.shpTicks.lineTo((float)d, n6 - 2);
                d += d10;
            }
        }
    }

    private void recalculateLogLabels() {
        double d;
        double d2;
        int n;
        int n2;
        if (this.orient == 0) {
            n2 = this.recentWidth;
            n = this.recentHeight;
            d2 = this.space.hmin;
            d = this.space.hmax;
        } else {
            n2 = this.recentHeight;
            n = this.recentWidth;
            d2 = this.space.vmin;
            d = this.space.vmax;
        }
        double d3 = Math.pow(d / d2, 72.0 / (double)n2);
        int n3 = (int)(Math.log(d3) / ln10);
        int n4 = (int)(Math.ceil(d3 / Math.pow(10.0, n3)) + 0.5);
        if (n4 > 5) {
            ++n3;
            n4 = 1;
        } else if (n4 > 3) {
            n4 = 4;
        } else if (n4 > 2) {
            n4 = 5;
        }
        d3 = (double)n4 * Math.pow(10.0, n3);
        int n5 = (int)(Math.ceil(Math.log(d / d2) / Math.log(d3)) + 0.5);
        if (this.labels.length != n5) {
            this.labels = new String[n5];
        }
        if (this.labelPos.length != n5) {
            this.labelPos = new int[n5];
        }
        int n6 = 8;
        int n7 = -1;
        for (int i = 0; i < n5; ++i) {
            int n8;
            double d4 = d2 * Math.pow(d3, i);
            int n9 = 3;
            for (n8 = 1000; n8 > 1 && d4 * (double)n8 % 1.0 == 0.0; n8 /= 10) {
                --n9;
            }
            if (n7 != n9) {
                this.msgForm.applyPattern(this.msgPattern[n9]);
                n7 = n9;
            }
            double d5 = this.orient == 0 ? this.space.hSpaceToUnity(d4) * (double)n2 : this.space.vSpaceToUnity(d4) * (double)n2;
            this.msgArgs[0] = d4;
            this.labels[i] = this.msgForm.format(this.msgArgs);
            this.labelPos[i] = (int)d5 + 2;
            this.shpTicks.moveTo((float)d5, 1.0f);
            this.shpTicks.lineTo((float)d5, n - 2);
            double d6 = d4 * (d3 - 1.0) / (double)n6;
            for (n8 = 1; n8 < n6; ++n8) {
                d5 = this.orient == 0 ? this.space.hSpaceToUnity(d4 + d6 * (double)n8) * (double)n2 : this.space.vSpaceToUnity(d4 + d6 * (double)n8) * (double)n2;
                this.shpTicks.moveTo((float)d5, n - 4);
                this.shpTicks.lineTo((float)d5, n - 2);
            }
        }
    }

    private void triggerRedisplay() {
        this.doRecalculate = true;
        if (this.host != null) {
            this.host.update(this);
        } else if (this.isVisible()) {
            this.repaint();
        }
    }

    public void dispose() {
        this.labels = null;
        this.labelPos = null;
        this.shpTicks.reset();
        this.img.flush();
    }
}

