/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class AquaFocusBorder
extends AbstractBorder {
    private static int aquaColorVariant = -1;
    private final Insets insets = new Insets(3, 3, 3, 3);
    private static final Color[] colrFocusGraphite = new Color[]{new Color(150, 165, 183, 64), new Color(150, 165, 183, 128), new Color(150, 165, 183, 192), new Color(150, 165, 183, 144), new Color(150, 165, 183, 64)};
    private static final Color[] colrFocusBlue = new Color[]{new Color(100, 156, 209, 64), new Color(100, 156, 209, 128), new Color(100, 156, 209, 192), new Color(100, 156, 209, 144), new Color(100, 156, 209, 64)};
    private final Color[] colrFocus;
    private boolean visible = true;

    public AquaFocusBorder() {
        switch (AquaFocusBorder.getAquaColorVariant()) {
            case 1: {
                this.colrFocus = colrFocusBlue;
                break;
            }
            default: {
                this.colrFocus = colrFocusGraphite;
            }
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = this.insets.top;
        insets.left = this.insets.left;
        insets.bottom = this.insets.bottom;
        insets.right = this.insets.right;
        return insets;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (!component.hasFocus() || !this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n5 = 0;
        int n6 = 1;
        while (n5 < 5) {
            graphics2D.setColor(this.colrFocus[n5]);
            graphics2D.drawRoundRect(n + n5, n2 + n5, n3 - n6, n4 - n6, 10 - n6, 10 - n6);
            ++n5;
            n6 += 2;
        }
    }

    public static int getAquaColorVariant() {
        if (aquaColorVariant == -1) {
            Color color = UIManager.getColor("Menu.selectionBackground");
            if (color == null) {
                aquaColorVariant = 6;
            } else {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, 1, 1);
                graphics2D.dispose();
                int n = bufferedImage.getRGB(0, 0);
                bufferedImage.flush();
                int n2 = (n & 0xFF0000) >> 16;
                int n3 = (n & 0xFF00) >> 8;
                int n4 = n & 0xFF;
                int n5 = (int)Math.sqrt(((n2 - 43) * (n2 - 43) + (n3 - 107) * (n3 - 107) + (n4 - 206) * (n4 - 206)) / 3);
                int n6 = (int)Math.sqrt(((n2 - 88) * (n2 - 88) + (n3 - 101) * (n3 - 101) + (n4 - 116) * (n4 - 116)) / 3);
                int n7 = n5 + n6;
                aquaColorVariant = n5 == 0 ? 1 : (n6 == 0 ? 6 : (100 * n5 / n7 < 20 ? 1 : (100 * n6 / n7 < 20 ? 6 : 6)));
            }
        }
        return aquaColorVariant;
    }
}

