/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.common;

import de.sciss.app.AbstractWindow;
import de.sciss.app.DocumentEvent;
import de.sciss.app.DocumentHandler;
import de.sciss.app.DocumentListener;
import de.sciss.common.BasicApplication;
import de.sciss.common.BasicDocument;
import de.sciss.common.BasicWindowHandler;
import de.sciss.common.ProcessingThread;
import de.sciss.common.URLViewerAction;
import de.sciss.gui.AboutBox;
import de.sciss.gui.MenuAction;
import de.sciss.gui.MenuGroup;
import de.sciss.gui.MenuItem;
import de.sciss.gui.MenuRadioGroup;
import de.sciss.gui.MenuRadioItem;
import de.sciss.gui.MenuRoot;
import de.sciss.gui.MenuSeparator;
import de.sciss.gui.PathList;
import de.sciss.io.IOUtil;
import de.sciss.util.Flag;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public abstract class BasicMenuFactory
extends MenuRoot
implements DocumentListener {
    private static final String KEY_OPENRECENT = "recent";
    public static final int MENU_SHORTCUT = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private int uniqueNumber = 0;
    private MenuGroup mgWindow;
    private MenuRadioGroup mWindowRadioGroup;
    protected MenuGroup mgRecent;
    protected final PathList openRecentPaths;
    protected ActionOpenRecent actionOpenRecent;
    private Action actionClearRecent;
    private Action actionCloseAll;
    private final BasicApplication root;

    public BasicMenuFactory(BasicApplication basicApplication) {
        this.root = basicApplication;
        this.openRecentPaths = new PathList(8, this.root.getUserPrefs(), KEY_OPENRECENT);
    }

    public void init() {
        this.createActions();
        this.createProtoType();
        this.root.getDocumentHandler().addDocumentListener(this);
    }

    public BasicApplication getApplication() {
        return this.root;
    }

    public ProcessingThread closeAll(boolean bl, Flag flag) {
        DocumentHandler documentHandler = this.root.getDocumentHandler();
        while (documentHandler.getDocumentCount() > 0) {
            BasicDocument basicDocument = (BasicDocument)documentHandler.getDocument(0);
            ProcessingThread processingThread = basicDocument.closeDocument(bl, flag);
            if (processingThread == null) {
                if (flag.isSet()) continue;
                return null;
            }
            return processingThread;
        }
        flag.set(true);
        return null;
    }

    private void createActions() {
        this.actionOpenRecent = this.createOpenRecentAction(this.getResourceString("menuOpenRecent"), null);
        this.actionClearRecent = new ActionClearRecent(this.getResourceString("menuClearRecent"), null);
        this.actionCloseAll = new ActionCloseAll(this.getResourceString("menuCloseAll"), null);
    }

    protected ActionOpenRecent createOpenRecentAction(String string, File file) {
        return new ActionOpenRecent(string, file);
    }

    private void createProtoType() {
        MenuGroup menuGroup = new MenuGroup("file", this.getResourceString("menuFile"));
        menuGroup.add(new MenuItem("open", this.getOpenAction()));
        this.mgRecent = new MenuGroup("openRecent", this.actionOpenRecent);
        if (this.openRecentPaths.getPathCount() > 0) {
            for (int i = 0; i < this.openRecentPaths.getPathCount(); ++i) {
                this.mgRecent.add(new MenuItem(String.valueOf(this.uniqueNumber++), this.createOpenRecentAction(null, this.openRecentPaths.getPath(i))));
            }
            this.actionOpenRecent.setPath(this.openRecentPaths.getPath(0));
            this.actionOpenRecent.setEnabled(true);
            this.actionClearRecent.setEnabled(true);
        }
        this.mgRecent.addSeparator();
        this.mgRecent.add(new MenuItem("clearRecent", this.actionClearRecent));
        menuGroup.add(this.mgRecent);
        if (this.root.getDocumentHandler().isMultiDocumentApplication()) {
            menuGroup.add(new MenuItem("close", this.getResourceString("menuClose"), KeyStroke.getKeyStroke(87, MENU_SHORTCUT)));
            menuGroup.add(new MenuItem("closeAll", this.actionCloseAll));
        }
        menuGroup.add(new MenuSeparator());
        menuGroup.add(new MenuItem("save", this.getResourceString("menuSave"), KeyStroke.getKeyStroke(83, MENU_SHORTCUT)));
        menuGroup.add(new MenuItem("saveAs", this.getResourceString("menuSaveAs"), KeyStroke.getKeyStroke(83, MENU_SHORTCUT + 1)));
        menuGroup.add(new MenuItem("saveCopyAs", this.getResourceString("menuSaveCopyAs")));
        menuGroup.addSeparator();
        menuGroup.add(new MenuItem("quit", this.root.getQuitAction()));
        this.add(menuGroup);
        menuGroup = new MenuGroup("edit", this.getResourceString("menuEdit"));
        menuGroup.add(new MenuItem("undo", this.getResourceString("menuUndo"), KeyStroke.getKeyStroke(90, MENU_SHORTCUT)));
        menuGroup.add(new MenuItem("redo", this.getResourceString("menuRedo"), KeyStroke.getKeyStroke(90, MENU_SHORTCUT + 1)));
        menuGroup.addSeparator();
        menuGroup.add(new MenuItem("cut", this.getResourceString("menuCut"), KeyStroke.getKeyStroke(88, MENU_SHORTCUT)));
        menuGroup.add(new MenuItem("copy", this.getResourceString("menuCopy"), KeyStroke.getKeyStroke(67, MENU_SHORTCUT)));
        menuGroup.add(new MenuItem("paste", this.getResourceString("menuPaste"), KeyStroke.getKeyStroke(86, MENU_SHORTCUT)));
        menuGroup.add(new MenuItem("clear", this.getResourceString("menuClear"), KeyStroke.getKeyStroke(8, 0)));
        menuGroup.addSeparator();
        menuGroup.add(new MenuItem("selectAll", this.getResourceString("menuSelectAll"), KeyStroke.getKeyStroke(65, MENU_SHORTCUT)));
        MenuAction menuAction = new ActionPreferences(this.getResourceString("menuPreferences"), KeyStroke.getKeyStroke(44, MENU_SHORTCUT));
        menuGroup.addSeparator();
        menuGroup.add(new MenuItem("preferences", menuAction));
        this.add(menuGroup);
        this.mWindowRadioGroup = new MenuRadioGroup();
        this.mgWindow = new MenuGroup("window", this.getResourceString("menuWindow"));
        this.mgWindow.addSeparator();
        this.mgWindow.add(new MenuItem("collect", ((BasicWindowHandler)this.root.getWindowHandler()).getCollectAction()));
        this.mgWindow.addSeparator();
        this.add(this.mgWindow);
        menuGroup = new MenuGroup("help", this.getResourceString("menuHelp"));
        menuGroup.add(new MenuItem("manual", new URLViewerAction(this.getResourceString("menuHelpManual"), KeyStroke.getKeyStroke(45, MENU_SHORTCUT + 1), "index", false)));
        menuGroup.add(new MenuItem("shortcuts", new URLViewerAction(this.getResourceString("menuHelpShortcuts"), null, "Shortcuts", false)));
        menuGroup.addSeparator();
        menuGroup.add(new MenuItem("website", new URLViewerAction(this.getResourceString("menuHelpWebsite"), null, this.getResourceString("appURL"), true)));
        menuAction = new ActionAbout(this.getResourceString("menuAbout"), null);
        menuGroup.addSeparator();
        menuGroup.add(new MenuItem("about", menuAction));
        this.add(menuGroup);
        this.addMenuItems();
    }

    protected abstract void addMenuItems();

    public abstract void showPreferences();

    protected abstract Action getOpenAction();

    public abstract void openDocument(File var1);

    public void addRecent(File file) {
        int n = this.openRecentPaths.indexOf(file);
        if (n == 0) {
            return;
        }
        if (n == -1 && this.openRecentPaths.getCapacity() == this.openRecentPaths.getPathCount()) {
            n = this.openRecentPaths.getPathCount() - 1;
        }
        if (n > 0) {
            this.openRecentPaths.remove(file);
            this.mgRecent.remove(n);
        }
        this.openRecentPaths.addPathToHead(file);
        this.actionOpenRecent.setPath(file);
        this.actionClearRecent.setEnabled(true);
        this.mgRecent.add(new MenuItem(String.valueOf(this.uniqueNumber++), this.createOpenRecentAction(null, file)), 0);
    }

    public String getResourceString(String string) {
        return this.root.getResourceString(string);
    }

    public void addToWindowMenu(Action action) {
        String string = "window" + String.valueOf(this.uniqueNumber++);
        this.mgWindow.add(new MenuRadioItem(this.mWindowRadioGroup, string, action));
    }

    public void removeFromWindowMenu(Action action) {
        MenuRadioItem menuRadioItem = (MenuRadioItem)this.mgWindow.getByAction(action);
        this.mgWindow.remove(menuRadioItem);
    }

    public void setSelectedWindow(Action action) {
        MenuRadioItem menuRadioItem = (MenuRadioItem)this.mgWindow.getByAction(action);
        menuRadioItem.setSelected(true);
    }

    @Override
    public void documentAdded(DocumentEvent documentEvent) {
        if (!this.actionCloseAll.isEnabled()) {
            this.actionCloseAll.setEnabled(true);
        }
    }

    @Override
    public void documentRemoved(DocumentEvent documentEvent) {
        if (this.root.getDocumentHandler().getDocumentCount() == 0) {
            this.actionCloseAll.setEnabled(false);
        }
    }

    @Override
    public void documentFocussed(DocumentEvent documentEvent) {
    }

    protected static String abbrName(String string) {
        int n = string.length();
        if (n <= 25) {
            return string;
        }
        int n2 = string.lastIndexOf(91);
        if (n2 == -1) {
            return string;
        }
        int n3 = string.indexOf(93, n2 + 1);
        if (n3 - n2 < 25) {
            return string;
        }
        return string.substring(0, n2 + 12) + "\u2026" + string.substring(n3 - 12);
    }

    public class ActionShowWindow
    extends MenuAction {
        private final Object component;

        public ActionShowWindow(String string, KeyStroke keyStroke, Object object) {
            super(string, keyStroke);
            this.component = object;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractWindow abstractWindow = (AbstractWindow)BasicMenuFactory.this.getApplication().getComponent(this.component);
            if (abstractWindow != null) {
                abstractWindow.setVisible(true);
                abstractWindow.toFront();
            }
        }
    }

    private class ActionAbout
    extends MenuAction {
        protected ActionAbout(String string, KeyStroke keyStroke) {
            super(string, keyStroke);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = (JFrame)BasicMenuFactory.this.getApplication().getComponent(AboutBox.COMP_ABOUTBOX);
            if (jFrame == null) {
                jFrame = new AboutBox();
            }
            jFrame.setVisible(true);
            jFrame.toFront();
        }
    }

    public class ActionPreferences
    extends MenuAction {
        protected ActionPreferences(String string, KeyStroke keyStroke) {
            super(string, keyStroke);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.perform();
        }

        public void perform() {
            BasicMenuFactory.this.showPreferences();
        }
    }

    private class ActionCloseAll
    extends MenuAction
    implements ProcessingThread.Listener {
        protected ActionCloseAll(String string, KeyStroke keyStroke) {
            super(string, keyStroke);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.perform();
        }

        private void perform() {
            ProcessingThread processingThread = BasicMenuFactory.this.closeAll(false, new Flag(false));
            if (processingThread != null) {
                processingThread.addListener(this);
                ((BasicDocument)processingThread.getClientArg("doc")).start(processingThread);
            }
        }

        @Override
        public void processStarted(ProcessingThread.Event event) {
        }

        @Override
        public void processStopped(ProcessingThread.Event event) {
            if (event.isDone()) {
                this.perform();
            }
        }
    }

    private class ActionClearRecent
    extends MenuAction {
        protected ActionClearRecent(String string, KeyStroke keyStroke) {
            super(string, keyStroke);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = BasicMenuFactory.this.openRecentPaths.getPathCount() - 1; i >= 0; --i) {
                BasicMenuFactory.this.mgRecent.remove(i);
            }
            BasicMenuFactory.this.openRecentPaths.clear();
            BasicMenuFactory.this.actionOpenRecent.setPath(null);
            this.setEnabled(false);
        }
    }

    protected class ActionOpenRecent
    extends MenuAction {
        private File path;

        public ActionOpenRecent(String string, File file) {
            super(string == null ? IOUtil.abbreviate(new File(file.getParentFile(), BasicMenuFactory.abbrName(file.getName())).getAbsolutePath(), 40) : string);
            this.setPath(file);
        }

        protected void setPath(File file) {
            this.path = file;
            this.setEnabled(file != null && file.isFile());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicMenuFactory.this.openDocument(this.path);
        }
    }
}

