/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.app;

import de.sciss.app.BasicEvent;
import java.awt.EventQueue;
import java.util.ArrayList;

public class EventManager
implements Runnable {
    public static final boolean DEBUG_EVENTS = false;
    private final ArrayList collListeners = new ArrayList();
    private final ArrayList collQueue = new ArrayList();
    private boolean paused = false;
    private volatile boolean invoked = false;
    protected Processor eventProcessor;
    private Object[] events = new Object[2];

    public EventManager(Processor processor) {
        this.eventProcessor = processor;
    }

    protected EventManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.collListeners.clear();
            this.collQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Object object) {
        if (object != null) {
            EventManager eventManager = this;
            synchronized (eventManager) {
                this.collQueue.add(new PostponedAction(object, true));
                EventQueue.invokeLater(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Object object) {
        if (object != null) {
            EventManager eventManager = this;
            synchronized (eventManager) {
                this.collQueue.add(new PostponedAction(object, false));
                EventQueue.invokeLater(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n;
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.invoked = false;
            if (this.paused) {
                return;
            }
            n = this.collQueue.size();
            this.events = this.collQueue.toArray(this.events);
            this.collQueue.clear();
        }
        for (int i = 0; i < n; ++i) {
            if (this.events[i] instanceof BasicEvent) {
                try {
                    this.eventProcessor.processEvent((BasicEvent)this.events[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                PostponedAction postponedAction = (PostponedAction)this.events[i];
                if (postponedAction.state) {
                    if (!this.collListeners.contains(postponedAction.listener)) {
                        this.collListeners.add(postponedAction.listener);
                    }
                } else {
                    this.collListeners.remove(postponedAction.listener);
                }
            }
            this.events[i] = null;
        }
    }

    public Object getListener(int n) {
        return this.collListeners.get(n);
    }

    public int countListeners() {
        return this.collListeners.size();
    }

    public void debugDump() {
        for (int i = 0; i < this.collListeners.size(); ++i) {
            System.err.println("listen " + i + " = " + this.collListeners.get(i).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(BasicEvent basicEvent) {
        boolean bl;
        EventManager eventManager = this;
        synchronized (eventManager) {
            Object e;
            bl = !this.paused && !this.invoked;
            int n = this.collQueue.size() - 1;
            if (n >= 0 && (e = this.collQueue.get(n)) instanceof BasicEvent && basicEvent.incorporate((BasicEvent)e)) {
                this.collQueue.set(n, basicEvent);
            } else {
                this.collQueue.add(basicEvent);
            }
        }
        if (bl) {
            this.invoked = true;
            EventQueue.invokeLater(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        boolean bl;
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.paused = false;
            bl = !this.collQueue.isEmpty();
        }
        if (bl) {
            EventQueue.invokeLater(this);
        }
    }

    private class PostponedAction {
        protected final Object listener;
        protected final boolean state;

        protected PostponedAction(Object object, boolean bl) {
            this.listener = object;
            this.state = bl;
        }
    }

    public static interface Processor {
        public void processEvent(BasicEvent var1);
    }
}

