/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.app;

import de.sciss.app.DynamicListening;
import de.sciss.app.LaterInvocationManager;
import de.sciss.app.PreferenceNodeSync;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class DynamicPrefChangeManager
implements DynamicListening,
PreferenceChangeListener,
PreferenceNodeSync,
LaterInvocationManager.Listener {
    private final String[] keys;
    private Preferences prefs;
    private final LaterInvocationManager lim;
    private final PreferenceChangeListener client;
    private final String[] values;
    private boolean listening = false;

    public DynamicPrefChangeManager(Preferences preferences, String[] stringArray, PreferenceChangeListener preferenceChangeListener) {
        this(preferences, stringArray, preferenceChangeListener, true);
    }

    public DynamicPrefChangeManager(Preferences preferences, String[] stringArray, PreferenceChangeListener preferenceChangeListener, boolean bl) {
        this.keys = stringArray;
        this.prefs = preferences;
        this.client = preferenceChangeListener;
        this.lim = new LaterInvocationManager(this);
        this.values = new String[stringArray.length];
        if (bl) {
            this.deliverChanges();
        }
    }

    @Override
    public void setPreferences(Preferences preferences) {
        if (this.listening) {
            this.stopListening();
            this.prefs = preferences;
            this.startListening();
        } else {
            this.prefs = preferences;
        }
    }

    public void deliverChanges() {
        for (int i = 0; i < this.keys.length; ++i) {
            String string = this.values[i];
            String string2 = this.prefs.get(this.keys[i], string);
            if (string2 == string || string2 != null && string != null && string2.equals(string)) continue;
            this.values[i] = string2;
            this.client.preferenceChange(new PreferenceChangeEvent(this.prefs, this.keys[i], string2));
        }
    }

    @Override
    public void startListening() {
        if (this.prefs != null) {
            this.prefs.addPreferenceChangeListener(this);
            this.deliverChanges();
        }
        this.listening = true;
    }

    @Override
    public void stopListening() {
        if (this.prefs != null) {
            this.prefs.removePreferenceChangeListener(this);
        }
        this.listening = false;
    }

    @Override
    public void laterInvocation(Object object) {
        this.client.preferenceChange((PreferenceChangeEvent)object);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        String string = preferenceChangeEvent.getKey();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(string)) continue;
            String string2 = this.values[i];
            String string3 = preferenceChangeEvent.getNewValue();
            if (!(string3 == string2 || string3 != null && string2 != null && string3.equals(string2))) {
                this.values[i] = string3;
                this.lim.queue(preferenceChangeEvent);
            }
            return;
        }
    }
}

