/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.app;

import de.sciss.app.AncestorAdapter;
import de.sciss.app.DynamicListening;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;

public class DynamicAncestorAdapter
extends AncestorAdapter {
    private final DynamicListening dynL;
    private final WindowListener winL;
    private final ComponentListener cmpL;
    private Window win = null;
    private JComponent cmp = null;
    protected boolean listening = false;

    public DynamicAncestorAdapter(DynamicListening dynamicListening) {
        this.dynL = dynamicListening;
        this.winL = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                if (!DynamicAncestorAdapter.this.listening) {
                    DynamicAncestorAdapter.this.startListening();
                }
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (DynamicAncestorAdapter.this.listening) {
                    DynamicAncestorAdapter.this.stopListening();
                }
            }
        };
        this.cmpL = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                if (!DynamicAncestorAdapter.this.listening) {
                    DynamicAncestorAdapter.this.startListening();
                }
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                if (DynamicAncestorAdapter.this.listening) {
                    DynamicAncestorAdapter.this.stopListening();
                }
            }
        };
    }

    public void addTo(JComponent jComponent) {
        if (this.cmp != null) {
            throw new IllegalStateException("Already added");
        }
        this.cmp = jComponent;
        jComponent.addAncestorListener(this);
        this.learnWindow(jComponent.getTopLevelAncestor());
    }

    public void remove() {
        if (this.cmp == null) {
            throw new IllegalStateException("Was not added");
        }
        this.cmp.removeAncestorListener(this);
        this.forgetWindow();
        this.cmp = null;
    }

    public JComponent getComponent() {
        return this.cmp;
    }

    public boolean isListening() {
        return this.listening;
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        Container container = ancestorEvent.getComponent().getTopLevelAncestor();
        if (container != this.win) {
            this.forgetWindow();
            this.learnWindow(container);
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.forgetWindow();
    }

    private void forgetWindow() {
        if (this.win != null) {
            this.win.removeWindowListener(this.winL);
            this.win.removeComponentListener(this.cmpL);
            this.win = null;
            if (this.listening) {
                this.stopListening();
            }
        }
    }

    private void learnWindow(Container container) {
        if (container != null && container instanceof Window) {
            this.win = (Window)container;
            this.win.addWindowListener(this.winL);
            this.win.addComponentListener(this.cmpL);
            if (!this.listening && this.win.isShowing()) {
                this.startListening();
            }
        }
    }

    protected void startListening() {
        this.dynL.startListening();
        this.listening = true;
    }

    protected void stopListening() {
        this.dynL.stopListening();
        this.listening = false;
    }
}

