/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.managers.log.Log;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class RectangleConverter
extends AbstractSingleValueConverter {
    public static final String separator = ",";

    public boolean canConvert(Class type) {
        return Rectangle.class.isAssignableFrom(type);
    }

    public Object fromString(String insets) {
        return RectangleConverter.rectangleFromString(insets);
    }

    public String toString(Object object) {
        return RectangleConverter.rectangleToString((Rectangle)object);
    }

    public static Rectangle rectangleFromString(String insets) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(insets, separator, false);
            int x = Integer.parseInt(tokenizer.nextToken().trim());
            int y = Integer.parseInt(tokenizer.nextToken().trim());
            int width = Integer.parseInt(tokenizer.nextToken().trim());
            int height = Integer.parseInt(tokenizer.nextToken().trim());
            return new Rectangle(x, y, width, height);
        }
        catch (Throwable e) {
            Log.get().error("Unable to parse Rectangle: " + insets, e);
            return new Rectangle();
        }
    }

    public static String rectangleToString(Rectangle r) {
        return r.x + separator + r.y + separator + r.width + separator + r.height;
    }
}

