/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.managers.log.Log;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Point;
import java.util.List;

public class PointConverter
extends AbstractSingleValueConverter {
    public boolean canConvert(Class type) {
        return Point.class.isAssignableFrom(type);
    }

    public Object fromString(String str) {
        return PointConverter.pointFromString(str);
    }

    public String toString(Object obj) {
        return PointConverter.pointToString((Point)obj);
    }

    public static Point pointFromString(String point) {
        try {
            List<String> points = TextUtils.stringToList(point, ",");
            int x = Integer.parseInt(points.get(0));
            int y = Integer.parseInt(points.get(1));
            return new Point(x, y);
        }
        catch (Throwable e) {
            Log.get().error("Unable to parse Point: " + point, e);
            return new Point();
        }
    }

    public static String pointToString(Point point) {
        return point.x + "," + point.y;
    }
}

