/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.system;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersion {
    private static final Pattern versionPattern = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(_([^-]+))?(.*)");
    private static final Pattern simpleVersionPattern = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(.*)");
    private double majorVersion;
    private int minorVersion;
    private int updateNumber;
    private String patch;

    public JavaVersion(double major, int update) {
        this.majorVersion = major;
        this.minorVersion = 0;
        this.updateNumber = update;
    }

    public JavaVersion(double major, int minor, int update) {
        this.majorVersion = major;
        this.minorVersion = minor;
        this.updateNumber = update;
    }

    public JavaVersion(String version) {
        this.applyJavaVersion(version);
    }

    public void applyJavaVersion(String version) {
        block11: {
            try {
                String s;
                Matcher matcher = versionPattern.matcher(version);
                if (!matcher.matches()) break block11;
                int groups = matcher.groupCount();
                this.majorVersion = Double.parseDouble(matcher.group(1));
                if (groups >= 3 && matcher.group(3) != null) {
                    this.minorVersion = Integer.parseInt(matcher.group(3));
                }
                if (groups >= 5 && matcher.group(5) != null) {
                    try {
                        this.updateNumber = Integer.parseInt(matcher.group(5));
                    }
                    catch (NumberFormatException e) {
                        this.patch = matcher.group(5);
                    }
                }
                if (groups >= 6 && matcher.group(6) != null && (s = matcher.group(6)) != null && s.trim().length() > 0) {
                    this.patch = s;
                }
            }
            catch (NumberFormatException e) {
                try {
                    Matcher matcher = simpleVersionPattern.matcher(version);
                    if (matcher.matches()) {
                        int groups = matcher.groupCount();
                        this.majorVersion = Double.parseDouble(matcher.group(1));
                        if (groups >= 3 && matcher.group(3) != null) {
                            this.minorVersion = Integer.parseInt(matcher.group(3));
                        }
                    }
                }
                catch (NumberFormatException e1) {
                    this.majorVersion = 1.4;
                    this.minorVersion = 0;
                    this.updateNumber = 0;
                }
            }
        }
    }

    public int compareVersion(double major, int minor, int update) {
        double majorResult = this.majorVersion - major;
        if (majorResult != 0.0) {
            return majorResult < 0.0 ? -1 : 1;
        }
        int result = this.minorVersion - minor;
        if (result != 0) {
            return result;
        }
        return this.updateNumber - update;
    }

    public double getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getUpdateNumber() {
        return this.updateNumber;
    }

    public String getPatch() {
        return this.patch;
    }
}

