/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.data.TextConverter;
import com.alee.utils.HtmlUtils;
import com.alee.utils.MergeUtils;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;

@XStreamAlias(value="text")
@XStreamConverter(value=TextConverter.class)
public final class Text
implements Serializable,
Cloneable {
    private String text;
    private String state;

    public Text() {
        this("");
    }

    public Text(String text) {
        this(text, null);
    }

    public Text(String text, String state) {
        this.text = text;
        this.state = state;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Text clone() {
        return MergeUtils.cloneByFieldsSafely(this, new Object[0]);
    }

    public String toString() {
        return TextUtils.shortenText(HtmlUtils.getPlainText(this.text), 50, true);
    }
}

