/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net.test;

import de.sciss.net.OSCBundle;
import de.sciss.net.OSCClient;
import de.sciss.net.OSCConnectionListener;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCReceiver;
import de.sciss.net.OSCServer;
import de.sciss.net.OSCTransmitter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Random;

public abstract class NetUtilTest {
    protected static boolean pause = false;
    protected static volatile boolean received;

    private NetUtilTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void client(String string) {
        OSCClient oSCClient;
        NetUtilTest.postln("NetUtilTest.client( \"" + string + "\" )\n");
        NetUtilTest.postln("talking to localhost port 57110");
        final Object object = new Object();
        try {
            oSCClient = OSCClient.newUsing(string);
            oSCClient.setTarget(new InetSocketAddress(InetAddress.getLocalHost(), 57110));
            NetUtilTest.postln("  start()");
            oSCClient.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        oSCClient.addOSCListener(new OSCListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageReceived(OSCMessage oSCMessage, SocketAddress socketAddress, long l) {
                if (oSCMessage.getName().equals("/n_end")) {
                    Object object2 = object;
                    synchronized (object2) {
                        object.notifyAll();
                    }
                }
            }
        });
        oSCClient.dumpOSC(3, System.err);
        try {
            oSCClient.send(new OSCMessage("/notify", new Object[]{1}));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        for (int i = 0; i < 4; ++i) {
            OSCBundle oSCBundle = new OSCBundle(System.currentTimeMillis() + 50L);
            OSCBundle oSCBundle2 = new OSCBundle(System.currentTimeMillis() + 1550L);
            int n = 1001 + i;
            oSCBundle.addPacket(new OSCMessage("/s_new", new Object[]{"default", n, 1, 0}));
            oSCBundle.addPacket(new OSCMessage("/n_set", new Object[]{n, "freq", Float.valueOf((float)(Math.pow(2.0, (float)i / 6.0f) * 441.0))}));
            oSCBundle2.addPacket(new OSCMessage("/n_set", new Object[]{n, "gate", Float.valueOf(-3.0f)}));
            try {
                oSCClient.send(oSCBundle);
                oSCClient.send(oSCBundle2);
                Object object2 = object;
                synchronized (object2) {
                    object.wait();
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            oSCClient.send(new OSCMessage("/notify", new Object[]{0}));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        oSCClient.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void server(String string) {
        OSCServer oSCServer;
        NetUtilTest.postln("NetUtilTest.server( \"" + string + "\" )\n");
        NetUtilTest.postln("listening at port 21588. recognized commands: /pause, /quit, /dumpOSC");
        final Object object = new Object();
        try {
            oSCServer = OSCServer.newUsing(string, 21588);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        oSCServer.addConnectionListener(new OSCConnectionListener(){

            @Override
            public void onConnected(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
                NetUtilTest.postln("onConnected - remote = " + inetSocketAddress2);
            }

            @Override
            public void onDisconnected(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
                NetUtilTest.postln("onDisconnected - remote = " + inetSocketAddress2);
            }
        });
        oSCServer.addOSCListener(new OSCListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageReceived(OSCMessage oSCMessage, SocketAddress socketAddress, long l) {
                try {
                    NetUtilTest.postln("send " + socketAddress);
                    oSCServer.send(new OSCMessage("/done", new Object[]{oSCMessage.getName()}), socketAddress);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (oSCMessage.getName().equals("/pause")) {
                    pause = true;
                    Object object2 = object;
                    synchronized (object2) {
                        object.notifyAll();
                    }
                } else if (oSCMessage.getName().equals("/quit")) {
                    Object object3 = object;
                    synchronized (object3) {
                        object.notifyAll();
                    }
                } else if (oSCMessage.getName().equals("/dumpOSC")) {
                    Object object4 = oSCMessage.getArgCount() > 0 ? oSCMessage.getArg(0) : null;
                    int n = object4 instanceof Number ? ((Number)object4).intValue() : 1;
                    oSCServer.dumpOSC(n, System.err);
                }
            }
        });
        try {
            do {
                if (pause) {
                    NetUtilTest.postln("  waiting four seconds...");
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    pause = false;
                }
                NetUtilTest.postln("  start()");
                oSCServer.start();
                try {
                    Object object2 = object;
                    synchronized (object2) {
                        object.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                NetUtilTest.postln("  stop()");
                oSCServer.stop();
            } while (pause);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        oSCServer.dispose();
    }

    public static void codecSpeed() {
        int n;
        long l;
        int n2;
        int n3;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(65536);
        ArrayList<Object> arrayList = new ArrayList<Object>(1024);
        Object[][] objectArrayArray = new Object[1024][];
        Random random = new Random(19088760L);
        ByteBuffer[] byteBufferArray = new ByteBuffer[1024];
        byte[] byArray = new byte[16];
        NetUtilTest.postln("Testing OSCMessage encoding speed...");
        for (int i = 0; i < objectArrayArray.length; ++i) {
            arrayList.clear();
            block17: for (n3 = 0; n3 < i % 1024; ++n3) {
                switch (n3 % 5) {
                    case 0: {
                        arrayList.add(random.nextInt());
                        continue block17;
                    }
                    case 1: {
                        arrayList.add(Float.valueOf(random.nextFloat()));
                        continue block17;
                    }
                    case 2: {
                        arrayList.add(random.nextLong());
                        continue block17;
                    }
                    case 3: {
                        arrayList.add(random.nextDouble());
                        continue block17;
                    }
                    case 4: {
                        random.nextBytes(byArray);
                        for (n2 = 0; n2 < byArray.length; ++n2) {
                            byArray[n2] = (byte)(Math.max(32, byArray[n2]) & 0x7F);
                        }
                        arrayList.add(new String(byArray));
                    }
                }
            }
            objectArrayArray[i] = arrayList.toArray();
        }
        try {
            l = System.currentTimeMillis();
            n = 0;
            while (System.currentTimeMillis() - l < 5000L) {
                byteBuffer.clear();
                new OSCMessage("/test", objectArrayArray[n % objectArrayArray.length]).encode(byteBuffer);
                ++n;
            }
            NetUtilTest.postln(n + " messages encoded in 5 seconds.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        NetUtilTest.postln("Testing OSCMessage decoding speed...");
        try {
            ByteBuffer byteBuffer2;
            for (int i = 0; i < byteBufferArray.length; ++i) {
                arrayList.clear();
                block21: for (n3 = 0; n3 < i % 1024; ++n3) {
                    switch (n3 % 3) {
                        case 0: {
                            arrayList.add(random.nextInt());
                            continue block21;
                        }
                        case 1: {
                            arrayList.add(Float.valueOf(random.nextFloat()));
                            continue block21;
                        }
                        case 2: {
                            random.nextBytes(byArray);
                            for (n2 = 0; n2 < byArray.length; ++n2) {
                                byArray[n2] = (byte)(Math.max(32, byArray[n2]) & 0x7F);
                            }
                            arrayList.add(new String(byArray));
                        }
                    }
                }
                OSCMessage oSCMessage = new OSCMessage("/test", arrayList.toArray());
                byteBuffer2 = ByteBuffer.allocateDirect(oSCMessage.getSize());
                oSCMessage.encode(byteBuffer2);
                byteBufferArray[i] = byteBuffer2;
            }
            l = System.currentTimeMillis();
            n = 0;
            while (System.currentTimeMillis() - l < 5000L) {
                byteBuffer2 = byteBufferArray[n % byteBufferArray.length];
                byteBuffer2.clear();
                byteBuffer2.position(8);
                OSCMessage.decodeMessage("/test", byteBuffer2);
                ++n;
            }
            NetUtilTest.postln(n + " messages decoded in 5 seconds.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pingPong() {
        Object object;
        boolean bl;
        int n;
        String[] stringArray = new String[]{"udp", "tcp"};
        String[] stringArray2 = new String[]{"One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve"};
        final Object object2 = new Object();
        int n2 = 0;
        int n3 = 0;
        System.out.println("\n---------- RECEIVER / TRANSMITTER ----------");
        for (int i = 0; i < 1; ++i) {
            String string = stringArray[i];
            System.out.println("---------- Testing protocol '" + string + "' ----------");
            for (int j = 0; j < 4; ++j) {
                boolean bl2 = j / 2 == 0;
                n = j % 2 == 0 ? 1 : 0;
                bl = n == 0 && bl2;
                received = false;
                System.out.println("Receiver loopBack = " + bl2 + "; Transmitter loopBack = " + (n != 0));
                OSCReceiver oSCReceiver = null;
                OSCTransmitter oSCTransmitter = null;
                try {
                    oSCReceiver = OSCReceiver.newUsing(string, 0, bl2);
                    oSCTransmitter = OSCTransmitter.newUsing(string, 0, n != 0);
                    oSCReceiver.dumpOSC(1, System.out);
                    oSCReceiver.startListening();
                    oSCReceiver.addOSCListener(new OSCListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void messageReceived(OSCMessage oSCMessage, SocketAddress socketAddress, long l) {
                            System.out.println("   Received msg '" + oSCMessage.getName() + "' from " + socketAddress);
                            Object object = object2;
                            synchronized (object) {
                                received = true;
                                object2.notifyAll();
                            }
                        }
                    });
                    oSCTransmitter.connect();
                    int n4 = oSCReceiver.getLocalAddress().getPort();
                    object = n != 0 ? new InetSocketAddress("127.0.0.1", n4) : new InetSocketAddress(InetAddress.getLocalHost(), n4);
                    oSCTransmitter.setTarget((SocketAddress)object);
                    oSCTransmitter.send(new OSCMessage("/test", new Object[]{stringArray2[n2], n2 + 1}));
                    try {
                        Object object3 = object2;
                        synchronized (object3) {
                            object2.wait(2000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (received != bl) {
                    System.out.println("... OK");
                } else {
                    System.out.println("\n... FAILED!!!\n");
                    ++n3;
                }
                if (oSCReceiver != null) {
                    oSCReceiver.dispose();
                }
                if (oSCTransmitter != null) {
                    oSCTransmitter.dispose();
                }
                n2 = (n2 + 1) % stringArray2.length;
            }
        }
        System.out.println("\n------------- CLIENT / SERVER --------------");
        for (String string : stringArray) {
            System.out.println("---------- Testing protocol '" + string + "' ----------");
            for (n = 0; n < 4; ++n) {
                bl = n / 2 == 0;
                boolean bl3 = n % 2 == 0;
                boolean bl4 = !bl && bl3;
                received = false;
                System.out.println("Client loopBack = " + bl + "; Server loopBack = " + bl3);
                OSCClient oSCClient = null;
                object = null;
                try {
                    oSCClient = OSCClient.newUsing(string, 0, bl);
                    object = OSCServer.newUsing(string, 0, bl3);
                    ((OSCServer)object).dumpOSC(1, System.out);
                    ((OSCServer)object).start();
                    ((OSCServer)object).addOSCListener(new OSCListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void messageReceived(OSCMessage oSCMessage, SocketAddress socketAddress, long l) {
                            System.out.println("   Received msg '" + oSCMessage.getName() + "' from " + socketAddress);
                            Object object = object2;
                            synchronized (object) {
                                received = true;
                                object2.notifyAll();
                            }
                        }
                    });
                    int n5 = ((OSCServer)object).getLocalAddress().getPort();
                    InetSocketAddress inetSocketAddress = bl ? new InetSocketAddress("127.0.0.1", n5) : new InetSocketAddress(InetAddress.getLocalHost(), n5);
                    oSCClient.setTarget(inetSocketAddress);
                    oSCClient.connect();
                    oSCClient.send(new OSCMessage("/test", new Object[]{stringArray2[n2], n2 + 1}));
                    try {
                        Object object4 = object2;
                        synchronized (object4) {
                            object2.wait(2000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (received != bl4) {
                    System.out.println("... OK");
                } else {
                    System.out.println("\n... FAILED!!!\n");
                    ++n3;
                }
                if (oSCClient != null) {
                    oSCClient.dispose();
                }
                if (object != null) {
                    ((OSCServer)object).dispose();
                }
                n2 = (n2 + 1) % stringArray2.length;
            }
        }
        System.out.println("\nNumber of tests failed: " + n3);
    }

    protected static void postln(String string) {
        System.err.println(string);
    }
}

