/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net;

import de.sciss.net.OSCBidi;
import de.sciss.net.OSCConnectionListener;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCPacket;
import de.sciss.net.OSCPacketCodec;
import de.sciss.net.OSCReceiver;
import de.sciss.net.OSCTransmitter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class OSCClient
implements OSCBidi {
    private final OSCReceiver rcv;
    private final OSCTransmitter trns;
    private int bufSize = 8192;
    private final String protocol;

    private OSCClient(OSCReceiver oSCReceiver, OSCTransmitter oSCTransmitter, String string) {
        this.rcv = oSCReceiver;
        this.trns = oSCTransmitter;
        this.protocol = string;
    }

    public static OSCClient newUsing(String string) throws IOException {
        return OSCClient.newUsing(OSCPacketCodec.getDefaultCodec(), string);
    }

    public static OSCClient newUsing(OSCPacketCodec oSCPacketCodec, String string) throws IOException {
        return OSCClient.newUsing(oSCPacketCodec, string, 0);
    }

    public static OSCClient newUsing(String string, int n) throws IOException {
        return OSCClient.newUsing(OSCPacketCodec.getDefaultCodec(), string, n);
    }

    public static OSCClient newUsing(OSCPacketCodec oSCPacketCodec, String string, int n) throws IOException {
        return OSCClient.newUsing(oSCPacketCodec, string, n, false);
    }

    public static OSCClient newUsing(String string, int n, boolean bl) throws IOException {
        return OSCClient.newUsing(OSCPacketCodec.getDefaultCodec(), string, n, bl);
    }

    public static OSCClient newUsing(OSCPacketCodec oSCPacketCodec, String string, int n, boolean bl) throws IOException {
        OSCReceiver oSCReceiver = OSCReceiver.newUsing(oSCPacketCodec, string, n, bl);
        OSCTransmitter oSCTransmitter = OSCTransmitter.newUsing(oSCPacketCodec, string, n, bl);
        return new OSCClient(oSCReceiver, oSCTransmitter, string);
    }

    public static OSCClient newUsing(String string, InetSocketAddress inetSocketAddress) throws IOException {
        OSCReceiver oSCReceiver = OSCReceiver.newUsing(string, inetSocketAddress);
        OSCTransmitter oSCTransmitter = OSCTransmitter.newUsing(string, inetSocketAddress);
        return new OSCClient(oSCReceiver, oSCTransmitter, string);
    }

    public static OSCClient newUsing(OSCPacketCodec oSCPacketCodec, String string, InetSocketAddress inetSocketAddress) throws IOException {
        OSCReceiver oSCReceiver = OSCReceiver.newUsing(oSCPacketCodec, string, inetSocketAddress);
        OSCTransmitter oSCTransmitter = OSCTransmitter.newUsing(oSCPacketCodec, string, inetSocketAddress);
        return new OSCClient(oSCReceiver, oSCTransmitter, string);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        return this.rcv.getLocalAddress();
    }

    public void setTarget(SocketAddress socketAddress) {
        this.rcv.setTarget(socketAddress);
        this.trns.setTarget(socketAddress);
    }

    @Override
    public void setCodec(OSCPacketCodec oSCPacketCodec) {
        this.rcv.setCodec(oSCPacketCodec);
        this.trns.setCodec(oSCPacketCodec);
    }

    @Override
    public OSCPacketCodec getCodec() {
        return this.rcv.getCodec();
    }

    public void connect() throws IOException {
        this.trns.connect();
    }

    public boolean isConnected() {
        return this.trns.isConnected();
    }

    public void send(OSCPacket oSCPacket) throws IOException {
        this.trns.send(oSCPacket);
    }

    public void addOSCListener(OSCListener oSCListener) {
        this.rcv.addOSCListener(oSCListener);
    }

    public void removeOSCListener(OSCListener oSCListener) {
        this.rcv.removeOSCListener(oSCListener);
    }

    public void addConnectionListener(OSCConnectionListener oSCConnectionListener) {
        this.rcv.addConnectionListener(oSCConnectionListener);
    }

    public void removeConnectionListener(OSCConnectionListener oSCConnectionListener) {
        this.rcv.removeConnectionListener(oSCConnectionListener);
    }

    @Override
    public void start() throws IOException {
        if (!this.trns.isConnected()) {
            this.trns.connect();
            this.rcv.setChannel(this.trns.getChannel());
        }
        this.rcv.startListening();
    }

    @Override
    public boolean isActive() {
        return this.rcv.isListening();
    }

    @Override
    public void stop() throws IOException {
        this.rcv.stopListening();
    }

    @Override
    public void setBufferSize(int n) {
        this.bufSize = n;
        this.rcv.setBufferSize(n);
        this.trns.setBufferSize(n);
    }

    @Override
    public int getBufferSize() {
        return this.bufSize;
    }

    @Override
    public void dumpOSC(int n, PrintStream printStream) {
        this.dumpIncomingOSC(n, printStream);
        this.dumpOutgoingOSC(n, printStream);
    }

    @Override
    public void dumpIncomingOSC(int n, PrintStream printStream) {
        this.rcv.dumpOSC(n, printStream);
    }

    @Override
    public void dumpOutgoingOSC(int n, PrintStream printStream) {
        this.trns.dumpOSC(n, printStream);
    }

    @Override
    public void dispose() {
        this.rcv.dispose();
        this.trns.dispose();
    }
}

