/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.util;

import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.SmpZone;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SmpMap
implements Cloneable {
    public ParamSpace hSpace;
    public ParamSpace vSpace;
    public int type;
    protected Vector smps;

    public SmpMap(ParamSpace paramSpace, ParamSpace paramSpace2, int n) {
        this.hSpace = paramSpace;
        this.vSpace = paramSpace2;
        this.type = n;
        this.smps = new Vector();
    }

    public SmpMap(ParamSpace paramSpace, ParamSpace paramSpace2) {
        this(paramSpace, paramSpace2, 0);
    }

    public SmpMap(SmpMap smpMap) {
        this.hSpace = smpMap.hSpace;
        this.vSpace = smpMap.vSpace;
        this.type = smpMap.type;
        this.smps = (Vector)smpMap.smps.clone();
    }

    public Object clone() {
        return new SmpMap(this);
    }

    public int addSample(SmpZone smpZone) {
        int n = -1;
        Param param = Param.transform(smpZone.freqHi, this.vSpace.unit, null, null);
        Param param2 = Param.transform(smpZone.freqLo, this.vSpace.unit, null, null);
        Param param3 = Param.transform(smpZone.velHi, this.hSpace.unit, null, null);
        Param param4 = Param.transform(smpZone.velLo, this.hSpace.unit, null, null);
        if (param != null && this.vSpace.contains(param.value) && param2 != null && this.vSpace.contains(param2.value) && param3 != null && this.hSpace.contains(param3.value) && param4 != null && this.hSpace.contains(param4.value)) {
            double d = (param.value - this.vSpace.min) / (this.vSpace.max - this.vSpace.min);
            double d2 = d * d;
            d = (param3.value - this.hSpace.min) / (this.hSpace.max - this.hSpace.min);
            d2 += d * d;
            n = this.smps.size();
            for (int i = 0; i < this.smps.size(); ++i) {
                SmpZone smpZone2 = (SmpZone)this.smps.elementAt(i);
                double d3 = Param.transform((Param)smpZone2.freqHi, (int)this.vSpace.unit, null, null).value;
                double d4 = Param.transform((Param)smpZone2.freqLo, (int)this.vSpace.unit, null, null).value;
                double d5 = Param.transform((Param)smpZone2.velHi, (int)this.hSpace.unit, null, null).value;
                double d6 = Param.transform((Param)smpZone2.velLo, (int)this.hSpace.unit, null, null).value;
                if (n > i) {
                    d = (d3 - this.vSpace.min) / (this.vSpace.max - this.vSpace.min);
                    double d7 = d * d;
                    d = (d5 - this.hSpace.min) / (this.hSpace.max - this.hSpace.min);
                    if (d2 <= (d7 += d * d)) {
                        n = i;
                    }
                }
                if (!(d6 < param3.value - 1.0E-6) || !(d5 > param4.value + 1.0E-6) || !(d4 < param.value - 1.0E-6) || !(d3 > param2.value + 1.0E-6)) continue;
                return -1;
            }
            if (n >= 0) {
                this.smps.insertElementAt(smpZone, n);
            }
        }
        return n;
    }

    public boolean removeSample(int n) {
        try {
            this.smps.removeElementAt(n);
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    public SmpZone getSample(int n) {
        SmpZone smpZone = null;
        try {
            smpZone = (SmpZone)this.smps.elementAt(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return smpZone;
    }

    public Enumeration getSamples() {
        return this.smps.elements();
    }

    public int size() {
        return this.smps.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.hSpace.toString() + '|' + this.vSpace.toString() + '|' + this.type);
        for (int i = 0; i < this.smps.size(); ++i) {
            stringBuffer.append("|" + ((SmpZone)this.smps.elementAt(i)).toString());
        }
        return stringBuffer.toString();
    }

    public static SmpMap valueOf(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        SmpMap smpMap = new SmpMap(ParamSpace.valueOf(stringTokenizer.nextToken()), ParamSpace.valueOf(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
        while (stringTokenizer.hasMoreElements()) {
            smpMap.smps.addElement(SmpZone.valueOf(stringTokenizer.nextToken()));
        }
        return smpMap;
    }
}

