/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.util;

import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.util.Curve;
import de.sciss.fscape.util.Envelope;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;

public class Modulator {
    protected Curve[] curve;
    protected double atkStart = 0.0;
    protected double atkEnd = 0.0;
    protected double susStart = 0.0;
    protected double susPeriod = 0.0;
    protected double rlsStart = 0.0;
    protected double rlsEnd = 0.0;
    protected double streamLength = 0.0;
    protected double frameLength = 0.0;
    protected Param base;
    protected Param depth;
    protected Envelope env;
    protected SpectStream stream;

    public Modulator(Param param, Param param2, Envelope envelope, SpectStream spectStream) {
        Curve curve = null;
        this.base = param;
        this.depth = param2;
        this.env = envelope;
        this.stream = spectStream;
        if (this.stream != null) {
            this.frameLength = SpectStream.framesToMillis(this.stream, 1L);
            this.streamLength = SpectStream.framesToMillis(this.stream, this.stream.frames);
        }
        this.curve = new Curve[3];
        this.rlsStart = this.streamLength;
        this.rlsEnd = this.streamLength;
        Param param3 = new Param(this.streamLength, envelope.hUnit);
        block10: for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    curve = envelope.atkState ? envelope.atkCurve : null;
                    break;
                }
                case 1: {
                    curve = envelope.rlsState ? envelope.rlsCurve : null;
                    break;
                }
                case 2: {
                    curve = envelope.susState ? envelope.susCurve : null;
                    param3 = new Param(this.rlsStart - this.atkEnd, envelope.hUnit);
                    break;
                }
            }
            if (curve == null) continue;
            Param param4 = Param.transform(new Param(curve.hSpace.min, curve.hSpace.unit), envelope.hUnit, param3, this.stream);
            Param param5 = Param.transform(new Param(curve.hSpace.max, curve.hSpace.unit), envelope.hUnit, param3, this.stream);
            if (param4 == null || param5 == null) continue;
            ParamSpace paramSpace = new ParamSpace(param4.value, param5.value, 1.0E-4, envelope.hUnit);
            this.curve[i] = Curve.transform(curve, paramSpace, curve.vSpace, param3, null, this.stream);
            switch (i) {
                case 0: {
                    this.atkStart = paramSpace.min;
                    this.atkEnd = paramSpace.max;
                    continue block10;
                }
                case 1: {
                    this.rlsStart -= paramSpace.max - paramSpace.min;
                    continue block10;
                }
                case 2: {
                    this.susStart = paramSpace.min + this.atkEnd;
                    this.susPeriod = paramSpace.max - paramSpace.min;
                }
            }
        }
    }

    public Param calc() {
        return this.calc(this.stream.getTime(), this.frameLength);
    }

    public Param calc(double d) {
        return this.calc(d, this.frameLength);
    }

    public Param calc(double d, double d2) {
        Param param;
        Curve curve = null;
        double d3 = 0.0;
        if (d >= this.atkEnd) {
            if (d >= this.rlsStart) {
                curve = this.curve[1];
                d -= this.rlsStart;
            } else {
                curve = this.curve[2];
                d = (d - this.susStart) % this.susPeriod;
            }
        } else {
            curve = this.curve[0];
            d -= this.atkStart;
        }
        if (curve != null && (param = Param.transform(new Param(this.depth.value * (d3 = Curve.average(curve, d, d + d2) / 100.0), this.depth.unit), this.env.hUnit, this.base, this.stream)) != null) {
            return param;
        }
        return this.base;
    }
}

