/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.spect;

import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class SpectralFile
extends GenericFile {
    public static final int MODE_REMOVEDC = 65536;
    public static final int PVA_LIN = 1;
    public static final int PVA_EXP = 2;
    public static final int PVA_MAG = 1;
    public static final int PVA_PHASE = 2;
    public static final int PVA_POLAR = 3;
    public static final int PVA_REAL = 4;
    public static final int PVA_IMAG = 5;
    public static final int PVA_RECT = 6;
    public static final int PVA_PVOC = 7;
    public static final int PVA_CQ = 32;
    public static final String ERR_ILLEGALFREQFORMAT = "Unsupported frequency format";
    public static final String ERR_ILLEGALFRAMEFORMAT = "Unsupported frame format";
    private int[] hdr = new int[14];
    protected static final int hdr_magic = 0;
    protected static final int hdr_headBsize = 1;
    protected static final int hdr_dataBsize = 2;
    protected static final int hdr_dataFormat = 3;
    protected static final int hdr_smpRate = 4;
    protected static final int hdr_chanNum = 5;
    protected static final int hdr_frameSize = 6;
    protected static final int hdr_smpPerFrame = 7;
    protected static final int hdr_frameBsize = 8;
    protected static final int hdr_frameFormat = 9;
    protected static final int hdr_loFreq = 10;
    protected static final int hdr_hiFreq = 11;
    protected static final int hdr_freqMode = 12;
    protected static final int hdr_info = 13;
    protected static final int hdr_sizeof = 14;
    protected static final int CSA_UNK_LEN = -1;
    protected static final int PVA_SHORT = 2;
    protected static final int PVA_LONG = 4;
    protected static final int PVA_FLOAT = 36;
    protected static final int PVA_DOUBLE = 40;
    protected int bands;
    protected long frames;
    protected int dataOffset;
    protected int dataNum;
    protected SpectStream stream = null;
    protected byte[] buffer;

    public SpectralFile(File file, int n) throws IOException {
        super(file, n & 0xFFFF000F | 0x40);
    }

    public SpectralFile(String string, int n) throws IOException {
        this(new File(string), n);
    }

    public SpectStream getDescr() throws IOException {
        if (this.stream == null) {
            this.stream = new SpectStream();
            this.readHeader();
            float f = Float.intBitsToFloat(this.hdr[4]);
            float f2 = Float.intBitsToFloat(this.hdr[11]);
            if (f2 > f / 2.0f) {
                f2 = f / 2.0f;
            }
            this.stream.setChannels(this.hdr[5]);
            this.stream.setBands(Float.intBitsToFloat(this.hdr[10]), f2, this.bands, this.hdr[12]);
            this.stream.setRate(f, this.hdr[7]);
            this.stream.setEstimatedLength(this.frames);
            this.buffer = new byte[this.stream.bands * this.dataNum * this.stream.chanNum << 2];
        }
        this.seekFrame(0L);
        return this.stream;
    }

    public void initWriter(SpectStream spectStream, int n) throws IOException {
        this.dataNum = n == 3 ? 2 : 1;
        this.dataOffset = n == 2 ? 1 : 0;
        this.bands = spectStream.bands;
        this.frames = spectStream.frames;
        this.hdr[0] = 1165124197;
        this.hdr[1] = 56;
        this.hdr[2] = -1;
        this.hdr[3] = 36;
        this.hdr[4] = Float.floatToIntBits(spectStream.smpRate);
        this.hdr[5] = spectStream.chanNum;
        this.hdr[6] = (spectStream.bands - 1) * this.dataNum;
        this.hdr[7] = spectStream.smpPerFrame;
        this.hdr[8] = this.hdr[6] << 1;
        this.hdr[9] = n;
        this.hdr[10] = Float.floatToIntBits(spectStream.loFreq);
        this.hdr[11] = Float.floatToIntBits(spectStream.hiFreq);
        this.hdr[12] = spectStream.freqMode;
        this.hdr[13] = 1179861840;
        for (int i = 0; i < this.hdr.length; ++i) {
            this.writeInt(this.hdr[i]);
        }
        if (this.hdr[5] == 2) {
            byte[] byArray = new byte[spectStream.bands * this.dataNum << 2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
            this.write(byArray);
        }
        this.buffer = new byte[spectStream.bands * this.dataNum * spectStream.chanNum << 2];
        this.stream = spectStream;
    }

    public void seekFrame(long l) throws IOException {
        this.seek((long)this.hdr[1] + l * (long)this.hdr[8] * (long)this.hdr[5]);
    }

    public SpectFrame readFrame() throws IOException {
        float f;
        int n;
        int n2;
        SpectFrame spectFrame = this.stream.allocFrame();
        this.readFully(this.buffer, 0, spectFrame.data.length * (spectFrame.data[0].length >> 1) * this.dataNum * (this.hdr[3] & 0xF));
        switch (this.hdr[3]) {
            case 36: {
                int n3 = 0;
                for (n2 = 0; n2 < spectFrame.data.length; ++n2) {
                    for (n = 0; n < spectFrame.data[n2].length; n += 2) {
                        if (this.dataOffset == 0) {
                            spectFrame.data[n2][n + 0] = Float.intBitsToFloat((this.buffer[n3] & 0xFF) << 24 | (this.buffer[n3 + 1] & 0xFF) << 16 | (this.buffer[n3 + 2] & 0xFF) << 8 | this.buffer[n3 + 3] & 0xFF);
                            n3 += 4;
                        } else {
                            spectFrame.data[n2][n + 0] = 0.0f;
                        }
                        if (this.dataOffset + this.dataNum == 2) {
                            spectFrame.data[n2][n + 1] = Float.intBitsToFloat((this.buffer[n3] & 0xFF) << 24 | (this.buffer[n3 + 1] & 0xFF) << 16 | (this.buffer[n3 + 2] & 0xFF) << 8 | this.buffer[n3 + 3] & 0xFF);
                            n3 += 4;
                            continue;
                        }
                        spectFrame.data[n2][n + 1] = 0.0f;
                    }
                }
                break;
            }
            case 4: {
                int n3 = 0;
                for (n2 = 0; n2 < spectFrame.data.length; ++n2) {
                    for (n = 0; n < spectFrame.data[n2].length; n += 2) {
                        if (this.dataOffset == 0) {
                            spectFrame.data[n2][n + 0] = (this.buffer[n3] & 0xFF) << 24 | (this.buffer[n3 + 1] & 0xFF) << 16 | (this.buffer[n3 + 2] & 0xFF) << 8 | this.buffer[n3 + 3] & 0xFF;
                            n3 += 4;
                        } else {
                            spectFrame.data[n2][n + 0] = 0.0f;
                        }
                        if (this.dataOffset + this.dataNum == 2) {
                            spectFrame.data[n2][n + 1] = (this.buffer[n3] & 0xFF) << 24 | (this.buffer[n3 + 1] & 0xFF) << 16 | (this.buffer[n3 + 2] & 0xFF) << 8 | this.buffer[n3 + 3] & 0xFF;
                            n3 += 4;
                            continue;
                        }
                        spectFrame.data[n2][n + 1] = 0.0f;
                    }
                }
                break;
            }
            case 40: {
                int n3 = 0;
                for (n2 = 0; n2 < spectFrame.data.length; ++n2) {
                    for (n = 0; n < spectFrame.data[n2].length; n += 2) {
                        if (this.dataOffset == 0) {
                            spectFrame.data[n2][n + 0] = (float)Double.longBitsToDouble(((long)this.buffer[n3] & 0xFFL) << 56 | ((long)this.buffer[n3 + 1] & 0xFFL) << 48 | ((long)this.buffer[n3 + 2] & 0xFFL) << 40 | ((long)this.buffer[n3 + 3] & 0xFFL) << 32 | ((long)this.buffer[n3 + 4] & 0xFFL) << 24 | ((long)this.buffer[n3 + 5] & 0xFFL) << 16 | ((long)this.buffer[n3 + 6] & 0xFFL) << 8 | (long)this.buffer[n3 + 7] & 0xFFL);
                            n3 += 8;
                        } else {
                            spectFrame.data[n2][n + 0] = 0.0f;
                        }
                        if (this.dataOffset + this.dataNum == 2) {
                            spectFrame.data[n2][n + 1] = (float)Double.longBitsToDouble(((long)this.buffer[n3] & 0xFFL) << 56 | ((long)this.buffer[n3 + 1] & 0xFFL) << 48 | ((long)this.buffer[n3 + 2] & 0xFFL) << 40 | ((long)this.buffer[n3 + 3] & 0xFFL) << 32 | ((long)this.buffer[n3 + 4] & 0xFFL) << 24 | ((long)this.buffer[n3 + 5] & 0xFFL) << 16 | ((long)this.buffer[n3 + 6] & 0xFFL) << 8 | (long)this.buffer[n3 + 7] & 0xFFL);
                            n3 += 8;
                            continue;
                        }
                        spectFrame.data[n2][n + 1] = 0.0f;
                    }
                }
                break;
            }
            case 2: {
                int n3 = 0;
                for (n2 = 0; n2 < spectFrame.data.length; ++n2) {
                    for (n = 0; n < spectFrame.data[n2].length; n += 2) {
                        if (this.dataOffset == 0) {
                            spectFrame.data[n2][n + 0] = (this.buffer[n3] & 0xFF) << 8 | this.buffer[n3 + 1] & 0xFF;
                            n3 += 2;
                        } else {
                            spectFrame.data[n2][n + 0] = 0.0f;
                        }
                        if (this.dataOffset + this.dataNum == 2) {
                            spectFrame.data[n2][n + 1] = (this.buffer[n3] & 0xFF) << 8 | this.buffer[n3 + 1] & 0xFF;
                            n3 += 2;
                            continue;
                        }
                        spectFrame.data[n2][n + 1] = 0.0f;
                    }
                }
                break;
            }
        }
        if (this.hdr[9] == 6) {
            for (n2 = 0; n2 < spectFrame.data.length; ++n2) {
                for (n = 0; n < spectFrame.data[n2].length; n += 2) {
                    f = spectFrame.data[n2][n + 0];
                    float f2 = spectFrame.data[n2][n + 1];
                    spectFrame.data[n2][n + 0] = (float)Math.sqrt(f * f + f2 * f2);
                    spectFrame.data[n2][n + 1] = (float)Math.atan2(f2, f);
                }
            }
        }
        if ((this.mode & 0x10000) != 0 && this.stream.loFreq < 10.0f) {
            f = (this.stream.hiFreq - this.stream.loFreq) / (float)this.stream.bands;
            n2 = 0;
            while ((float)n2 * f + this.stream.loFreq < 10.0f) {
                for (n = 0; n < spectFrame.data.length; ++n) {
                    spectFrame.data[n][(n2 << 1) + 0] = 0.0f;
                    spectFrame.data[n][(n2 << 1) + 1] = 0.0f;
                }
                ++n2;
            }
        }
        return spectFrame;
    }

    public void writeFrame(SpectFrame spectFrame) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < spectFrame.data.length; ++n3) {
            for (n2 = 0; n2 < spectFrame.data[n3].length; n2 += 2) {
                if (this.dataOffset == 0) {
                    n = Float.floatToIntBits(spectFrame.data[n3][n2 + 0]);
                    this.buffer[n4] = (byte)((n & 0xFF000000) >> 24);
                    this.buffer[n4 + 1] = (byte)((n << 8 & 0xFF000000) >> 24);
                    this.buffer[n4 + 2] = (byte)((n << 16 & 0xFF000000) >> 24);
                    this.buffer[n4 + 3] = (byte)(n << 24 >> 24);
                    n4 += 4;
                }
                if (this.dataOffset + this.dataNum != 2) continue;
                n = Float.floatToIntBits(spectFrame.data[n3][n2 + 1]);
                this.buffer[n4] = (byte)((n & 0xFF000000) >> 24);
                this.buffer[n4 + 1] = (byte)((n << 8 & 0xFF000000) >> 24);
                this.buffer[n4 + 2] = (byte)((n << 16 & 0xFF000000) >> 24);
                this.buffer[n4 + 3] = (byte)(n << 24 >> 24);
                n4 += 4;
            }
        }
        if ((this.mode & 0x10000) != 0 && this.stream.loFreq < 10.0f) {
            float f = (this.stream.hiFreq - this.stream.loFreq) / (float)this.stream.bands;
            n4 = 0;
            for (n3 = 0; n3 < this.stream.chanNum; ++n3) {
                n2 = 0;
                n = n4;
                while ((float)n2 * f + this.stream.loFreq < 10.0f) {
                    this.buffer[n++] = 0;
                    this.buffer[n++] = 0;
                    if (this.dataNum == 2) {
                        this.buffer[n++] = 0;
                        this.buffer[n++] = 0;
                    }
                    ++n2;
                }
                n4 += this.stream.bands * (this.dataNum << 1);
            }
        }
        this.write(this.buffer, 0, spectFrame.data.length * (spectFrame.data[0].length << 1) * this.dataNum);
    }

    public SpectFrame allocFrame() {
        return this.stream.allocFrame();
    }

    public void freeFrame(SpectFrame spectFrame) {
        this.stream.freeFrame(spectFrame);
    }

    @Override
    public void close() throws IOException {
        this.stream = null;
        if ((this.mode & 0xF) == 1) {
            try {
                if (this.length() >= 56L) {
                    this.seek(8L);
                    this.writeInt((int)this.length() - this.hdr[1]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.close();
    }

    @Override
    public String getFormat() throws IOException {
        SpectStream spectStream = this.stream;
        if (spectStream == null) {
            spectStream = this.getDescr();
        }
        return SpectStream.getFormat(spectStream);
    }

    private void readHeader() throws IOException {
        this.seek(0L);
        this.hdr[0] = this.readInt();
        if (this.hdr[0] != 1165124197 && this.hdr[0] != 517730) {
            throw new UnsupportedEncodingException("Unsupported file format");
        }
        this.mode = this.mode & 0xFFFF000F | 0x40;
        for (int i = 1; i < this.hdr.length; ++i) {
            this.hdr[i] = this.readInt();
        }
        if (this.hdr[12] != 1 && this.hdr[12] != 2) {
            throw new UnsupportedEncodingException(ERR_ILLEGALFREQFORMAT);
        }
        this.hdr[9] = this.hdr[9] & 0xF;
        switch (this.hdr[9]) {
            case 1: {
                this.dataOffset = 0;
                this.dataNum = 1;
                break;
            }
            case 2: {
                this.dataOffset = 1;
                this.dataNum = 1;
                break;
            }
            case 3: {
                this.dataOffset = 0;
                this.dataNum = 2;
                break;
            }
            case 6: {
                this.dataOffset = 0;
                this.dataNum = 2;
                break;
            }
            default: {
                throw new UnsupportedEncodingException(ERR_ILLEGALFRAMEFORMAT);
            }
        }
        if (this.hdr[2] <= 0) {
            this.hdr[2] = (int)this.length() - this.hdr[1];
        }
        this.bands = this.hdr[6] / this.dataNum + 1;
        this.hdr[8] = this.bands * this.dataNum * (this.hdr[3] & 0xF);
        this.frames = this.hdr[2] / (this.hdr[8] * this.hdr[5]);
        if (this.hdr[5] == 2) {
            this.hdr[1] = this.hdr[1] + this.hdr[8];
        }
    }
}

