/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.session;

import de.sciss.fscape.gui.OpConnector;
import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.OpPanel;
import de.sciss.fscape.gui.SpectPatchDlg;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.BasicProperties;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.SpectStreamSlot;
import java.awt.Point;
import java.io.IOException;
import java.io.SyncFailedException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SpectPatch {
    private SpectPatchDlg win;
    private String name = null;
    public boolean running = false;
    public boolean pausing = false;
    private Vector<Operator> ops = new Vector();
    private ThreadGroup opThreadGroup = null;
    private static final String FILE_OP = "Op";
    private static final String FILE_OPHEAD = "Head";
    private static final String FILE_OPPROP = "Prop";
    private static final String LINK_DEST = "Dest";
    private static final String LINK_LOC = "Loc";
    private static final String HEAD_CLASS = "Class";
    private static final String HEAD_NAME = "Name";
    private static final String HEAD_LOC = "Loc";
    private static final String HEAD_ALIAS = "Alias";
    private static final String HEAD_ORIGINAL = "Orig";

    public SpectPatch(SpectPatchDlg spectPatchDlg) {
        this.win = spectPatchDlg;
    }

    public boolean load(Properties properties) {
        boolean bl = true;
        Vector<Operator> vector = new Vector<Operator>();
        try {
            String string;
            if (!this.clear()) {
                return false;
            }
            OpPanel opPanel = this.win.getOpPanel();
            int n = 0;
            while ((string = properties.getProperty(FILE_OP + n + FILE_OPHEAD)) != null) {
                block32: {
                    Properties properties2 = Presets.valueToProperties(string);
                    string = properties.getProperty(FILE_OP + n + FILE_OPPROP);
                    Properties properties3 = Presets.valueToProperties(string);
                    string = properties2.getProperty(HEAD_CLASS);
                    Point point = BasicProperties.getPointProperty(properties2, "Loc");
                    if (point == null) {
                        point = new Point();
                    }
                    if (string != null) {
                        string = "de.sciss.fscape.op." + string;
                        try {
                            Operator operator;
                            int n2;
                            Operator operator2 = (Operator)Class.forName(string).newInstance();
                            vector.addElement(operator2);
                            if (properties3 != null) {
                                PropertyArray propertyArray = operator2.getPropertyArray();
                                propertyArray.fromProperties(true, properties3);
                            }
                            opPanel.addOperator(operator2, point.x, point.y);
                            Enumeration<SpectStreamSlot> enumeration = operator2.getSlots(1).elements();
                            while (enumeration.hasMoreElements()) {
                                SpectStreamSlot spectStreamSlot = enumeration.nextElement();
                                string = properties.getProperty(FILE_OP + n + spectStreamSlot.toString());
                                Properties properties4 = Presets.valueToProperties(string);
                                if (properties4 == null || (string = properties4.getProperty(LINK_DEST)) == null || string.length() == 0) continue;
                                try {
                                    int n3 = string.indexOf(44);
                                    String string2 = string.substring(n3 + 1);
                                    n2 = Integer.parseInt(string.substring(0, n3));
                                    operator = (Operator)vector.elementAt(n2);
                                    SpectStreamSlot spectStreamSlot2 = operator.getSlot(string2);
                                    if (spectStreamSlot2 == null) continue;
                                    opPanel.linkOperators(spectStreamSlot, spectStreamSlot2);
                                    OpConnector opConnector = opPanel.getConnector(spectStreamSlot);
                                    Point point2 = BasicProperties.getPointProperty(properties4, "Loc");
                                    if (opConnector == null) continue;
                                    if (point2 != null) {
                                        opConnector.setVisible(true);
                                        opPanel.moveConnector(opConnector, point2.x, point2.y);
                                        continue;
                                    }
                                    opConnector.setVisible(false);
                                }
                                catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                                    bl = false;
                                }
                                catch (NoSuchElementException noSuchElementException) {
                                    bl = false;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    bl = false;
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                            }
                            string = properties2.getProperty(HEAD_NAME);
                            if (string != null) {
                                opPanel.renameOperator(operator2, string);
                            }
                            if ((string = properties2.getProperty(HEAD_ALIAS)) != null) {
                                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                                while (stringTokenizer.hasMoreTokens()) {
                                    try {
                                        n2 = Integer.parseInt(stringTokenizer.nextToken());
                                        operator = (Operator)vector.elementAt(n2);
                                        operator.turnIntoAlias(operator2);
                                    }
                                    catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                                        bl = false;
                                    }
                                    catch (SyncFailedException syncFailedException) {
                                        bl = false;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        bl = false;
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                                }
                            }
                            if ((string = properties2.getProperty(HEAD_ORIGINAL)) == null) break block32;
                            try {
                                n2 = Integer.parseInt(string);
                                operator = (Operator)vector.elementAt(n2);
                                operator2.turnIntoAlias(operator);
                            }
                            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                                bl = false;
                            }
                            catch (SyncFailedException syncFailedException) {
                                bl = false;
                            }
                            catch (NumberFormatException numberFormatException) {
                                bl = false;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            }
                        }
                        catch (InstantiationException instantiationException) {
                            bl = false;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            bl = false;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties save() {
        OpPanel opPanel = this.win.getOpPanel();
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        Properties properties3 = new Properties();
        Vector<Operator> vector = this.ops;
        synchronized (vector) {
            for (int i = 0; i < this.ops.size(); ++i) {
                Enumeration enumeration;
                int n;
                Operator operator = this.ops.elementAt(i);
                OpIcon opIcon = (OpIcon)operator.getIcon();
                properties2.clear();
                properties3.clear();
                String string = operator.getClass().getName();
                string = string.substring(string.lastIndexOf(46) + 1);
                properties2.put(HEAD_CLASS, string);
                properties2.put(HEAD_NAME, opIcon.getName());
                BasicProperties.setPointProperty(properties2, "Loc", opIcon.getLocation());
                Operator operator2 = operator.getOriginal();
                if (operator2 != null && (n = this.ops.indexOf(operator2)) >= 0) {
                    properties2.put(HEAD_ORIGINAL, String.valueOf(n));
                }
                if ((enumeration = operator.getAliases()).hasMoreElements()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    while (enumeration.hasMoreElements()) {
                        operator2 = (Operator)enumeration.nextElement();
                        n = this.ops.indexOf(operator2);
                        if (n < 0) continue;
                        stringBuffer.append(n);
                        if (!enumeration.hasMoreElements()) continue;
                        stringBuffer.append(',');
                    }
                    properties2.put(HEAD_ALIAS, stringBuffer.toString());
                }
                string = Presets.propertiesToValue(properties2);
                properties.put(FILE_OP + i + FILE_OPHEAD, string);
                PropertyArray propertyArray = operator.getPropertyArray();
                string = Presets.propertiesToValue(propertyArray.toProperties(true));
                properties.put(FILE_OP + i + FILE_OPPROP, string);
                Enumeration<SpectStreamSlot> enumeration2 = operator.getSlots(2).elements();
                while (enumeration2.hasMoreElements()) {
                    SpectStreamSlot spectStreamSlot = enumeration2.nextElement();
                    SpectStreamSlot spectStreamSlot2 = spectStreamSlot.getLinked();
                    if (spectStreamSlot2 != null && (n = this.ops.indexOf(operator2 = spectStreamSlot2.getOwner())) >= 0) {
                        properties3.put(LINK_DEST, "" + n + ',' + spectStreamSlot2.toString());
                        OpConnector opConnector = opPanel.getConnector(spectStreamSlot);
                        if (opConnector != null && opConnector.isVisible()) {
                            BasicProperties.setPointProperty(properties3, "Loc", opConnector.getLocation());
                        }
                    }
                    string = Presets.propertiesToValue(properties3);
                    properties.put(FILE_OP + i + spectStreamSlot.toString(), string);
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clear() {
        Vector<Operator> vector = this.ops;
        synchronized (vector) {
            this.win.clear();
            this.ops.removeAllElements();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Vector<Operator> vector = this.ops;
        synchronized (vector) {
            if (!this.running) {
                this.pausing = false;
                this.opThreadGroup = new ThreadGroup("Operators");
                for (int i = 0; i < this.ops.size(); ++i) {
                    Operator operator = this.ops.elementAt(i);
                    if (!operator.threadDead) continue;
                    Thread thread = new Thread(this.opThreadGroup, operator, operator.getIcon().getName());
                    operator.threadPaused = false;
                    operator.threadDead = false;
                    operator.owner = this;
                    thread.start();
                }
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Vector<Operator> vector = this.ops;
        synchronized (vector) {
            if (this.running) {
                this.pausing = false;
                for (int i = 0; i < this.ops.size(); ++i) {
                    Operator operator = this.ops.elementAt(i);
                    if (operator.threadDead) continue;
                    operator.runStop();
                    Enumeration<SpectStreamSlot> enumeration = operator.getSlots(2).elements();
                    while (enumeration.hasMoreElements()) {
                        SpectStreamSlot spectStreamSlot;
                        SpectStreamSlot spectStreamSlot2 = spectStreamSlot = enumeration.nextElement();
                        synchronized (spectStreamSlot2) {
                            if (spectStreamSlot.state == 3) {
                                spectStreamSlot.getOwnerThread().interrupt();
                            }
                        }
                    }
                }
                while (this.opThreadGroup.activeCount() > 0) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.running = false;
            }
        }
        this.win.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pause(boolean bl) {
        Vector<Operator> vector = this.ops;
        synchronized (vector) {
            if (this.running && bl != this.pausing) {
                Operator operator;
                int n;
                for (n = 0; n < this.ops.size(); ++n) {
                    operator = this.ops.elementAt(n);
                    if (operator.threadDead) continue;
                    operator.runPause(bl);
                    Enumeration<SpectStreamSlot> enumeration = operator.getSlots(2).elements();
                    while (enumeration.hasMoreElements()) {
                        SpectStreamSlot spectStreamSlot;
                        SpectStreamSlot spectStreamSlot2 = spectStreamSlot = enumeration.nextElement();
                        synchronized (spectStreamSlot2) {
                            if (spectStreamSlot.state == 3) {
                                spectStreamSlot.getOwnerThread().interrupt();
                            }
                        }
                    }
                }
                if (bl) {
                    boolean bl2;
                    do {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        bl2 = true;
                        for (n = 0; n < this.ops.size(); ++n) {
                            operator = this.ops.elementAt(n);
                            if (operator.threadDead || operator.threadPausing) continue;
                            bl2 = false;
                        }
                    } while (!bl2);
                }
                this.pausing = bl;
            }
        }
    }

    public synchronized void operatorTerminated(Operator operator) {
        if (Thread.activeCount() == 1) {
            this.running = false;
            this.win.stop();
        }
    }

    public synchronized void operatorPaused(Operator operator) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperator(Operator operator) {
        Vector<Operator> vector = this.ops;
        synchronized (vector) {
            this.ops.addElement(operator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOperator(Operator operator) {
        Vector<Operator> vector = this.ops;
        synchronized (vector) {
            this.ops.removeElement(operator);
        }
        operator.dispose();
    }

    public ModulePanel getModule() {
        return this.win;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getOperators() {
        Vector<Operator> vector = this.ops;
        synchronized (vector) {
            return this.ops.elements();
        }
    }
}

